:! DIV - Calculate PCNT=(X*10000)/Y without overflow
:#
:     DIV calculates PCNT=(X*10000)/Y without the overflow that would
:     result if X > 20000.  Thus, PCNT is the percent X is of Y in the
:     form NN.NN%.
:> CALLING SEQUENCE
:     X   - Dividend
:     Y   - Divisor
:     GOSUB 7550
:     PCNT- percentage X of Y
:$ STORAGE USED
:     I%  - Temporary (loop control)
:     Z1  - Temporary (remainder)
::
7550 REM \ DIV
7552 LET PCNT=0
7555 IF Y=0 THEN RETURN 
7560 LET Z1=X
7565 FOR I%=0 TO 4
7575   LET PCNT=PCNT*10+Z1/Y
7580   LET Z1=MOD(Z1,Y)*10*SGN(Z1)
7585 NEXT I%
7588 IF ABS(Z1)/Y>4 THEN PCNT=PCNT+SGN(Z1)
7590 RETURN 
7599 REM * END DIV.SL 12/30/81
