/*************************************************************************
*
*
*	Name:  xcall12.c
*
*	Description:  XCALL 12, 13, & 14  statements
*
*
*	History:
*	Date		By		Comments
*
*	4/12/83	waf
*	4/20/83	waf	Use strdes structure as arg in xcall14 call.
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> Assumed default start values -
	'1' for XCALL 12 & 13.
	'0' for XCALL 14.



.SH */
#include	"/bb/include/ptype.h"
#include "/bb/include/bberms.h"


			/**  XCALL 12 & 13  **/

xcall12 ( posvar, str1, str2, start )

/* scan str1 while in str2 */

NUMDES	posvar;
STRDES	str1, str2;
int		start;

	{

	wuscan( posvar, str1, str2, start, 12 );
	}


xcall13 ( posvar, str1, str2, start )

/* scan str1 until in str2 */

NUMDES	posvar;
STRDES	str1, str2;
int		start;

	{

	wuscan( posvar, str1, str2, start, 13 );
	}

/* 
.SH */



wuscan ( posvar, str1, str2, start, xcflag )

/* scan str1 while/until char is in str2 */

NUMDES	posvar;
STRDES	str1, str2;
int	start, xcflag;

	{
	register int	pos;		/* position offset */
	register char	c;

	/** set ptrs **/
	pos = scanset( start, &str1 );
	if ( pos == -1 )
		{
		/* start too big */
		putvj( &posvar, 0 );
		return ;
		}
	if ( pos == 0 )
		bberr( BEFAR );		/* 0 not allowed for xcall 12 & 13 */

	/** do scan **/
	forever
		{

		/** get next char in str1 **/
		if ( x12gb( &c, pos, &str1) == FALSE )
			{

			/** end of str1 reached **/
			putvj( &posvar, str1.curlth );
			return;
			}

		/** test for match **/
		if ( xcmatch( c, &str2 ) == FALSE )
			{

			/** No match. Return pos if xcall 12 **/
			if ( xcflag == 12 )
				{
				putvj( &posvar, pos - 1 );
				return;
				}
			}
		else
			{

			/** Match. Return pos if xcall 13 **/
			if ( xcflag == 13 )
				{
				putvj( &posvar, pos - 1 );
				return;
				}
			}

		/** inc ptr **/
		pos++ ;  

		}		/* continue till end of str2 or while/until satisfied */
	}

/* 
.SH */
			/** common subroutines **/


	scanset ( start, strdes )

	/* set up ptr for scan
		Returns -1 if bad start val,
			else returns offset in string */

	/* NOTE - start val and return val are reletive to '1' */

	int		start;		/* 'start' input val */
	STRDES	*strdes;

		{

		if ( start < 0 )  bberr( BEFAR );

		if ( start > strdes->curlth )
			{
			/* start too big */
			return( -1 );		/* return error flag */
			}

		return( start );
		}



xcmatch ( c, delstr )

/* chk c for match in delstr */
/* return TRUE for match, FALSE for no match */

char	c;
STRDES	*delstr;

	{
	register int	i;

	for ( i=0 ; i < delstr->curlth ; i++ )
		if ( *(delstr->data + i) == c )
			return( TRUE );	/* match */
	return( FALSE );		/* no match */
	}



x12gb ( c, pos, str )

/* get byte at 'reletive position' pos in str.
	Returns FALSE if end of string. */

/* NOTE - input pos is reletive to '1' */

char	*c;
int	pos;
STRDES	*str;
	{

	if ( pos > str->curlth )
		{
		*c = '\0';
		return( FALSE );		/* flag end of $ */
		}
	
	pos-- ;		/* is reletive to '1' */
	*c = *(str->data + pos);
	return( TRUE );
}


/* 
.SH */

		/**  XCALL 14  **/

xcall14 ( field, instr, delstr, posvar )

STRDES	field;		/* ret str */
STRDES	instr, delstr;
NUMDES	posvar;

	{
	register int pos, lpos, rpos;
	char	*sptr;
	int	i;
	char	c;

	/** get start pos **/
	pos = getvj( &posvar ) ;		/* set pos to start */
	if ( pos > 0 && pos > instr.curlth )
		{
		putvj( &posvar, pos );		/* ??? */
		return ;
		}
	pos = scanset( pos, &instr );
	if ( pos == -1 )
		{
		/* start too big */
		putvj( &posvar, 0 );
		return;
		}

	/** init ptrs **/
	pos++ ;		/* skip previous delimiter */
	sptr = instr.data ;

	/** chk for leading ' 's */
	forever
		{
		x12gb( &c, pos, &instr );		/* next char */
		if ( c != ' ' )  break ;
		pos++ ;
		}

	/** init sub$ ptrs **/
	lpos = pos ;		/* left ptr */
	rpos = lpos ;		/* right ptr */

	/** chk empty $ **/
	if ( x12gb( &c, pos, &instr ) == FALSE )
		{
		pos = -1 ;
		goto putrstr ;
		}

	/** scan **/
	while ( xcmatch( c, &delstr ) == FALSE )	/* while char not in delims */
		{
		
		/** update ptrs **/
		rpos++ ;
		pos++ ;

		/** chk next char **/
		if ( x12gb( &c, pos, &instr ) == FALSE )
			{

			/** end of instr **/
			pos = -1 ;
			goto putrstr ;
			}

		/** chk space **/
		if ( c == ' ' )
			{

			/** terminating spaces **/
			forever
				{
				pos++ ;

				/* chk end of $ */
				if ( x12gb( &c, pos, &instr ) == FALSE )
					{
					/* end of str */
					pos = -1 ;
					goto putrstr ;
					}

				/* chk ' ' */
				if ( c != ' ' )
					break ;
				}

			/* test char after ' 's */
			if ( xcmatch( c, &delstr ) == FALSE )
				pos-- ;  	/* back up to last ' ' */
			break;
			}
		}

	/** end of scan **/
	/* scan term'ed on delim char */


	putrstr: 	/* return pos value to posvar and sub-string to retstr */

	/** return pos val **/
	putvj( &posvar, pos );

	/** move into field sub-str des **/
	/* (field data ptr is already at start of sub-str) */
	i = rpos - lpos ;		/* len of sub$ */
	if ( i < 0 )
		i = 0 ;
	lpos-- ;			/* reletive to 0 */
	movbd( sptr + lpos, i, &field );

	/** update parent des **/
	updcl( &field );
	}
