/*************************************************************************
*
*
*	Name:  pmach2.c
*
*	Description:
*			This executes p-codes with a lead-in code of 2
*
*
*	History:
*	Date		By		Comments
*
*	03/02/83	mas
*	04/18/83	mas	changed to check for SWAP/CHAIN file
*						before doing SWAP/CHAIN
*	04/19/83	mas	changed trace to go to stderr
*	04/29/83	mas	fixed SWAP and CHAIN to remove STRDES of
*						program name from stack before calling 
*						pmdump() by using BSP instead of SP
*	05/09/83	mas	moved ONGO + ONGS to pmach.c added STOP
*								and SYSTEM, PSAVE, PREPLACE
*	05/09/83	mas	added call to phinc();
*	05/17/83	mas	cancelled all alarms if not used
*	05/24/83	mas	added call to KADDS, KNXTS, KDELS, KFNDS
*						and LOCKS
*	06/24/83	mas	fixed bug in DIML DIMA where the total 
*						was greater than 65535 by using longs
*	06/29/83	mas	changed to leave noikey alone in START
*						have to handle run-only differently
*	06/29/83	mas	changed to call bpause instead of pause
*						bpause handles interrupts 
*	07/12/83	mas	changed to set timed lock value to smallest
*						value that works if less than that (2)
*	07/28/83	mas	changed to use pushstk for location in 
*						push file
*	08/01/83	waf		Renamed 'rename()' function to 'brename()', to avoid
*					conflict with MSDOS 'rename()' function.
*	08/01/83	waf		Changed TRACE code to reflect new xlt2bchan() function.
*	08/15/83	waf		DELAY - if value = '0', do NOT do 'delay' system call.
*	09/02/83	waf		END - pass NORM_XIT code to pexit().
*	11/09/83	waf		Changed PEND to type 0 opcode. Moved code to pmach.c
*	07/02/84	waf		M000: fix push fd bug.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/opcodes.h"
#include <signal.h>
#include "/bb/include/pexit.h"
#include "/bb/include/pcondcomp.h"

extern int onikey1(),sexit();
extern int (*oldsig)();

pmach2 (pc,sp)
POINTER	pc,sp;
	{

	STRDES	*sptr;
	PSTRDES	*psptr;
	ARRDES	*aptr;
	NUMDES	*nptr;
	LFTENT	*lfptr,lfdup;
register POINTER PC;
register POINTER SP;
	int	i,j,*iptr;
	int	tempj;
	int	onikey2();
	unsigned u,u1,u2,utot;
	long	templ,l,m,n;
	char	*cptr,buf[PATHSIZE];

	PC = pc;
	SP = sp;

#ifdef PHIST
	phinc(*PC.B,2);
#endif

	switch (((*PC.B++)&0x00ff)+512) {
		case SWAP:
			startline = *PC.J++;	/* get starting line */
			l = pushstk[ust.pushcnt]; /* get push loc */
			if (lseek(pushfd,l,0) < 0)		/* M000 */
				bberr(BESWP);
			j = pmdsw;	/* save pmdsw */
			pmdsw = TRUE;	/* turn it on */
			pmdump(PC,GFP->BSP,0);	/* push it all out there */
			pmdsw = j;
			/* the rest is similar to CHAIN */
			j = SWAP;
			if (ust.stxfl.trace == TRUE)
				write(tracefd,"\nSWAP TO ",9);
			goto CHAIN1;
		case CHAIN:
			startline = *PC.J; /* set starting line */
			j = CHAIN;
			if (ust.stxfl.trace == TRUE)
				write(tracefd,"\nCHAIN TO ",10);
		CHAIN1:
			movdb(--SP.S,buf,PATHSIZE); /* get name */
			if (ust.stxfl.trace == TRUE) {
				write(tracefd,buf,strlen(buf));
				write(tracefd,"\n",1);
				i = tracefd; /* restart trace */
				tracefd = -1;
				ptrace();
				tracefd = i;
				}
			if ((i = openpc(buf)) < 0)
				bbxerrno(); /* file not found */
			l = lseek(i,0L,1);	/* get current position */
			if (j == SWAP)
				++ust.pushcnt;	/* add one to push count */
			reloadpc(i,l);		/* reload the pcode */
			cptr = buf ;
			if (*buf == '%' || *buf == '#')
				cptr++ ;	/* skip prefix */
			strcpy(ust.pname, cptr) ;	 /* put name in ust */
			if (pcheader.stksiz == 0 || contsw == FALSE) {
				/* no stack loaded */
				SP.B = begstk;
				/* initialize regs+frame*/
				SP.B = framinit(SP);
				PC.B = begmem;
				/* initialize global mem */
				pcint = pcerr = pclast = 0;
				lastfileno = lasterrno = 0;
				randseed = timeleft = 0;
				}
			else { /* all other stuff set by updhd() */
				SP.B = pcheader.sp.B;
				PC.B = pcheader.pc.B;
				}
			break; /* done */
		case ONERR:
			if (*PC.J == 0) {	/* reset vectors */
				GFP->ERRVEC.B = (char *)-1;
				PC.J++; /* skip offset*/
				break;
				}
			GFP->ERRVEC.B = PC.B + sizeof(int);
			PC.B += *PC.J;		/* jump to next stmt */
			break;
		case ONINT:
			if (*PC.J == 0) {	/* reset vectors */
				GFP->INTVEC.B = (char *)-1;
				PC.J++; /* skip RETERR+offset*/
				break;
				}
			GFP->INTVEC.B = PC.B + sizeof(int);
			PC.B += *PC.J;		/* jump to next stmt */
			break;
		case RETERR:
			PC.B = nextstmt(pcerr); /* goto statement after err */
			break;
		case RETINT:
			PC.B = nextstmt(pcint); /* goto statement after int */
			break;
		case DELETE:
			delete(*--SP.N,*--SP.S);
			break;
		case RENAME:
			brename(*--SP.N,*--SP.S,*--SP.S);
			break;
		case OPEN:
			bopen(*--SP.N,*--SP.J,*--SP.L,*--SP.S);
			break;
		case CLOSE:
			bclose(*--SP.J);	/* close channel */
			break;
		case SPOS:
			spos(*--SP.J,*--SP.L);	/* set position */
			break;
		case DELAY:
			termflush();		/* flush any output */
			i = *--SP.J;		/* pop time to delay */
			if ( i == 0 )
				break;		/* DELAY 0 - do not do delay */
			i += 9;			/* round up to seconds */
			i /= 10;
			if (setjmp(ikeyenv) == 0)
				valikey = TRUE;	/* long jump to here on ikey */
			else {
				/* comes here on ikey during delay */
				valikey = FALSE;	/* no more longjumps */
				valalarm = FALSE;	/* no more longjumps */
				alarm(0);		/* cancel alarms */
				ikeyz(PC,SP);	/* check for user */
				return;
				}
			if (setjmp(alarmenv) == 0)
				valalarm = TRUE; /*long jump here on alarm */
			else {
				/* comes here on alarm during delay */
				valikey = FALSE;	/* no more longjumps */
				valalarm = FALSE;	/* no more longjumps */
				break;		/* should be next statement */
				}
			alarm((unsigned)i);	/* set alarm */
			bpause();	/* wait for it */
			break;
		case RNDMZ:
			rndmz();
			break;
		case DIMA:
			/* get size of string in bytes with 500 bytes pad */
			utot = (unsigned)*--SP.J + 500;
			/* check if room left in memory */
			if((long)(unsigned)SP.B + (long)utot
					       >= (long)(unsigned)endmem)
				bberr(BEDTM);	/* out of memory */

			/* point to parent descriptor */
			psptr = (PSTRPTR)(((char *)GFP) + *PC.J++);
			/* dim'ed yet? */
			if (psptr->ppardes != 0) { /* no */
				if (*SP.J > psptr->pmaxsiz)
					bberr(BEDIM);
				psptr->pmaxlth = *SP.J;
				}
			else { 		   /* yes */
				psptr->pdata = (char *)SP.J;
				psptr->pmaxlth = psptr->pmaxsiz = *SP.J;
				SP.B += *SP.J;
				GFP->BSP.B = SP.B;
				psptr->ppardes = psptr;
				}
			psptr->pcurlth = 0;
			break;
		case DIML:
			/* point to arrdes */
			aptr = (ARRPTR)(((char *)GFP) + *PC.J++);
			u1 = *--SP.J;		/* get number of dims */
			for (u = 0,n = 1; u < u1; ++u) /* compute size */
				n *= *(SP.J-(u+1)) + 1;  /* in longs     */
			if (n*sizeof(long)+(unsigned)SP.B+500>(unsigned)endmem)
				bberr(BEDTM);
			if (n > 65000/sizeof(long))
			 	bberr(BEDTM);
			u2 = n;
			/* get size in bytes */
			utot = (u2 * sizeof(long)) + 500; /* 500 bytes pad */

			/* check if room left in memory */
			if ((long)(unsigned)SP.B + (long)utot
						>= (long)(unsigned)endmem)
				bberr(BEDTM);	/* out of memory */

			/* already dim'ed */
			if (aptr->ndata.l != (long *)0) {
				if (aptr->amaxsiz < u2*sizeof(long))
					bberr(BEDIM);
				for (u = 0; u < u1; ++u)
					aptr->bound[u1-(u+1)] = *--SP.J;
				break;
				}
			/* not dim'ed yet */
			aptr->type = 1;
			aptr->amaxsiz = u2 * sizeof(long);
			aptr->numdim = u1;
			for (u = 0; u < u1; ++u) {
				aptr->bound[u1-(u+1)] = *--SP.J;
				}
			aptr->adata.l = SP.L;
			for (u = 0; u < u2; ++u)
				*SP.L++ = 0L; /* fill up arr w/0 */
			GFP->BSP.B = SP.B; /* reset BSP */
			break;
		case LOCKS:
		case LOCKL:
			nptr = --SP.N;		/* timerr numeric desc */
			/* if timerr var given then set alarm */
			if (isvar(nptr) == TRUE) {
				i = getvj(nptr); /* get value */
				i += 9;	/* round up to next second */
				i /= 10;
				if (i < 2)	/*smallest value that works */
					i = 2;
				if (setjmp(alarmenv) == 0)
					valalarm = TRUE;
				else {
					/* alarm occured, clean up */
					valalarm = FALSE;
					valikey = FALSE;
					unlks(*--SP.J);	/* unlock area */
					SP.B = GFP->BSP.B;
					errchk(nptr,BERIU);
					break;
					}
				alarm((unsigned)i);	/* set alarm */
				}
			/* set up for ikey too */
			if (setjmp(ikeyenv) == 0)
				valikey = TRUE;
			else {
				/* ikey occured clean up */
				valikey = FALSE;
				valalarm = FALSE;
				alarm(0);		/* cancel alarm */
				unlks(*--SP.J);	/* unlock area */
				SP.B = GFP->BSP.B;
				ikeyz(PC,SP);
				return;
				}
			/* do lock */
			if ((*(PC.B-1)&0x00ff)+512 == LOCKL)
				lockf(*--SP.J,*--SP.J,*--SP.L,nptr,0);
			else	/* LOCKS */
				lockd(*--SP.J,*--SP.S,*--SP.L,*--SP.L,nptr,0);
			alarm(0);		/* cancel outstanding alarms */
			valalarm = FALSE;	/* no longjmp on alarm */
			valikey = FALSE;	/* no longjmp on ikey */
			break;
		case UNLOCK:
			unlks(*--SP.J);	/* unlock area */
			break;
		case BLKRD:
			blkrd(*--SP.J,*--SP.L,*--SP.S);
			break;
		case BLKRDD:
			blkrdd(*--SP.J,*--SP.L,*--SP.PA);
			break;
		case BLKWR:
			blkwr(*--SP.J,*--SP.L,*--SP.S);
			break;
		case BLKWRD:
			blkwrd(*--SP.J,*--SP.L,*--SP.PA);
			break;
		case LOPNB:
			lopnb(*--SP.N,*--SP.J,*--SP.S,*--SP.L,*--SP.S);
			break;
		case LOPNC:
			lopnc(*--SP.N,*--SP.J,*--SP.J,*--SP.L,*--SP.S,*--SP.S,
			      *--SP.L,*--SP.L,*--SP.L,*--SP.J);
			break;
		case LRD:
			lrd(*--SP.J,*--SP.L,*--SP.S);	/* read log record */
			break;
		case LWR:
			lwr(*--SP.J,*--SP.L,*--SP.S);	/* write log record */
			break;
		case KFNDL:
		case KADDL:
		case KNXTL:
		case KDELL:
		case KFNDS:
		case KADDS:
		case KNXTS:
		case KDELS:
			/* set up for ikey out of lock */
			if (setjmp(ikeyenv) != 0) {
				/* ikey occured clean up */
				valikey = FALSE;
				SP.B = GFP->BSP.B;
				ikeyz(PC,SP);
				return;
				}
			valikey = TRUE;
			switch ((*(PC.B-1)&0x00ff)+512) {
				case KFNDS:
					kfnds(*--SP.S,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KFNDL:
					kfndl(*--SP.J,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KNXTS:
					valikey = FALSE;
					knxts(*--SP.S,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KNXTL:
					valikey = FALSE;
					knxtl(*--SP.J,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KADDS:
					kadds(*--SP.S,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KADDL:
					kaddl(*--SP.J,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KDELS:
					kdels(*--SP.S,*--SP.S,*--SP.S,*--SP.N);
					break;
				case KDELL:
					kdell(*--SP.J,*--SP.S,*--SP.S,*--SP.N);
					break;
				default:
					bberr(BEUDF);
					break;
				}
			break;
		case GETREC:
			getrec(*--SP.J,*--SP.N);
			break;
		case DELREC:
			delrec(*--SP.J,*--SP.L);
			break;
		case RESTOR:
			GFP->DTP.B = PC.B + *PC.J++;
			break;
		case RSTGS:
			GFP->GSP =
			       (char *)((struct GFRAMEA *)GFP)->GSADES.adata.j;
			break;
		case RSTFN:
			iptr = ((struct GFRAMEA *)GFP)->FNADES.adata.j;
			GFP->FNSP = (FNDES *)iptr;
			break;
		case START:
			if (pcheader.runonly == TRUE) {
				debugsw = pmdsw = FALSE;
				if (startline == 0)
					break;
				bberr(BERUN);
				}
			pmdsw = TRUE;	/* enable PMD on error */
			if (debugsw == TRUE)
				ust.stxfl.debug = TRUE;
			if (startline == 0)
				break;
			if((PC.B = linetopc(startline)) == (char *)0)
				bberr(BENLN);
			pclast = PC.B;	/* up date last statement pc */
			break;
		case NEW:
			bclose(16);	/* close all open files */
		case BYE:
			pexit(NORM_XIT);
		case STOP:
			pstop(PC,SP);
			return;
		case TRACE:
			i = *--SP.J;
			if (i == -1) {
				ust.stxfl.trace = FALSE;
				write(tracefd,"\n",1); /* end trace line */
				tracefd = -1;	/* force ptrace to clean up */
				ptrace();	/* clean up */
				break;
				}
			ust.stxfl.trace = TRUE;
			j = xlt2bchan(i,&tracefd);
			if (j == 0)
				bberr(BEWRM);
			if (j == 16)
				tracefd = 2; /* set to stderr */
			break;
		case DEBUG:
			if (*--SP.J == -1)
				debugsw = FALSE;
			else
				debugsw = TRUE;
			break;
		case SBREAK:
			pbreak(PC,SP);
			return;
		case PSAVE:
			psave(PC,SP,*--SP.S,0);
			break;
		case PREPLACE:
			psave(PC,SP,*--SP.S,1);
			break;
		case SYSTEM:
			bsystem(*--SP.N,*--SP.S);
			break;
		default:
			panic();
		}
	TPC = PC.B;
	TSP = SP.B;
	return;
	}

