/*************************************************************************
*
*
*	Name:  pakset, upkset & pakend
*
*	Description:  set-up for and clean-up after PACK and UNPACK
*
*
*	History:
*	Date		By		Comments
*
*	03/10/82	WEB
*	05/09/82	WEB		fixed a problem with Z in upkset
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/
#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"

char *pakset(sp)
POINTER sp;
{
   register int length;
   char *fmtptr, *fmtend, *strptr, *strend;
   STRDES format, string;
   register PAKDES *pbuf;

   string = *(sp.S-1);			/* copy string descriptor from stack */
   format = *(sp.S-2);			/* copy format descriptor from stack */

   fmtptr = format.data;		/* get pointers to the data */
   strptr = string.data;
   fmtend = fmtptr+format.curlth;	/* determine end pointers */
   strend = strptr+string.curlth;

   *sp.PB++ = fmtptr;			/* push format pointer */
   *sp.PB++ = fmtend;			/* push format end */
   *sp.PB++ = strptr;			/* push string pointer */
   *sp.PB++ = strend;			/* push string end */

   pbuf = (PAKDES *) (sp.B - sizeof(PAKDES));

   skipsp(pbuf);			/* skip leading chaff */

   /* fill buffer with nulls if format starts with Z */
   if (*pbuf->pkfmtptr == 'Z' && pbuf->pkfmtptr < pbuf->pkfmtend) {

      pbuf->pkfmtptr++;			/* skip over format specifier */

      if ((length = getlength(pbuf)) != -1 && length > pbuf->pkstrdes.maxlth)
	 bberr(BESSZ);			/* error if length exceeds max. */

      if (length == -1)			/* use max. length if only Z */
	 length = pbuf->pkstrdes.maxlth;

      fill(&pbuf->pkstrdes, 0, length);	/* null fill string */
      updcl(&pbuf->pkstrdes);		/* update length */

      pbuf->pkstrdes.data = strptr;	 /* reset string descriptor on stack */
      pbuf->pkstrdes.curlth = length;
      pbuf->pkstrdes.maxlth = length;
      pbuf->pkstrend = strptr+length;

   } /* end-if */

   chkpos(pbuf);			/* check for @ and + */

   return(sp.B);			/* return updated stack pointer */

} /* end-pakset */

char *upkset(sp)
POINTER sp;
{
   register int length;
   char *fmtptr, *fmtend, *strptr, *strend;
   STRDES format, string;
   register PAKDES *pbuf;

   string = *(sp.S-1);			/* copy string descriptor from stack */
   format = *(sp.S-2);			/* copy format descriptor from stack */

   fmtptr = format.data;		/* get pointers to the data */
   strptr = string.data;
   fmtend = fmtptr+format.curlth;	/* determine end pointers */
   strend = strptr+string.curlth;

   *sp.PB++ = fmtptr;			/* push format pointer */
   *sp.PB++ = fmtend;			/* push format end */
   *sp.PB++ = strptr;			/* push string pointer */
   *sp.PB++ = strend;			/* push string end */

   pbuf = (PAKDES *) (sp.B - sizeof(PAKDES));

   skipsp(pbuf);			/* skip leading chaff */

   					/* skip Z in unpack */
   if (*pbuf->pkfmtptr == 'Z' && pbuf->pkfmtptr < pbuf->pkfmtend) {
      pbuf->pkfmtptr++;			/* skip over format specifier */
      length = getlength(pbuf);		/*    and length              */
   }

   chkpos(pbuf);			/* check for @ and + */

   return(sp.B);			/* return updated stack pointer */

} /* end-upkset */

char *pakend(sp)			/* clean up after PACK or UNPACK */
POINTER sp;
{

   return(sp.B - sizeof(PAKDES));	/* return updated stack pointer */

} /* end-pakend */

getlength(xpbuf)
PAKDES *xpbuf;
{
   register PAKDES *pbuf;
   register int l;
   int c = 0;

   pbuf = xpbuf;
   l = 0;

   if (*pbuf->pkfmtptr == '-')		/* error if negative number */
      bberr(BEIFS);

   while (*pbuf->pkfmtptr >= '0' && *pbuf->pkfmtptr <= '9'
				 && pbuf->pkfmtptr < pbuf->pkfmtend) {
      l = l * 10 + *pbuf->pkfmtptr - '0';
      pbuf->pkfmtptr++;
      c++;
   }

   if (c == 0)				/* return -1 if no conversion */
      l = -1;

   return(l);

} /* end-getlength */

skipsp(xpbuf)				/* skip leading spaces, etc. */
PAKDES *xpbuf;
{
   register PAKDES *pbuf;

   pbuf = xpbuf;

   while ((*pbuf->pkfmtptr == ' ' || *pbuf->pkfmtptr == ',')
                                  && pbuf->pkfmtptr < pbuf->pkfmtend)
      pbuf->pkfmtptr++;
} /* end-skipsp */

chkpos(xpbuf)				/* process @ and + in format */
PAKDES *xpbuf;
{
   register PAKDES *pbuf;
   int length;
   register char fmtchar;

   pbuf = xpbuf;

   skipsp(pbuf);			/* skip leading chaff */

   if (pbuf->pkfmtptr >= pbuf->pkfmtend)
      return;				/* exit if nothing left in format */

   fmtchar = *pbuf->pkfmtptr;

   if (fmtchar == '@' || fmtchar == '+') {

      pbuf->pkfmtptr++;			/* skip over format character */
      length = getlength(pbuf);		/* get length as position */

      if (length == 0)
	 length = 1;			/* 0 is same as 1 for @ and + */

      if (length == -1)
	 length = 1;			/* default is 1 for @ and + */

      if ((fmtchar == '@' &&
		  pbuf->pkstrdes.data + length > pbuf->pkstrend)
	     || (fmtchar == '+' &&
		  pbuf->pkstrptr+length > pbuf->pkstrend))
	 bberr(BESSZ);			/* error if length exceeds end */

      if (fmtchar == '@')	/* update pointer */
	 pbuf->pkstrptr = pbuf->pkstrdes.data + length - 1;
      else
	 pbuf->pkstrptr += length;

      chkpos(pbuf);			/* do it again in case there are more */
   }

} /* end-chkpos */
