/*************************************************************************
*
*
*	Name:  onikey.c
*
*	Description:  IKEY interrupt handler
*
*
*	History:
*	Date		By		Comments
*
*	03/01/83	mas
*	02/20/84	waf		New comments, and return value of 'ust.noikey'.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


02/20/84	waf
  These notes reflect my current understanding of ikey handling by the p-mach:

  The action taken by the 'ikey' interrupt handlers in this module is determined
by the state of the 'valikey' and 'ust.noikey' flags.
  The valikey flag is used to allow the 'longjmp(ikeyenv)' to be taken
immediately in certain, special, cases (i.e. during certain 'k-functions').
The default value of 'valikey' is FALSE. In this case, the occurance of an
ikey is noted (by setting ust.stxfl.ikey and setting/resetting ust.flag2)
and execution is resummed, exactly as if the interrupt had not occured (except
for the special case of character i/o - see ioerr() in bberr.c). The ikey is
actually 'acknowleged', and the appropriate action taken, when the next STMTX
p-code is executed (e.g. at the beginning of the next Basic 'statement').

  The noikey flag (ust.nokey) is used to implement the (software) disabling of
ikeys. When the flag is set, it means the user as executed an STMA 6,5 state-
ment, and ikeys should be 'ignored'. The first time an STMTX p-code is executed
after an ikey has occured, the dostmt() code (called by STMTX) noting that an
ikey has occured, checks the state of the noikey flag. If the flag is reset,
the ikeyz() codes is called to process the ikey. If the flag is set, however,
the ikeyz() code is not invoked, thereby 'ignoring' the ikey.
  Thus, the main use of the noikey flag is in the dostmt() code. I'm not sure
I understand the use of the noikey flag in the code below. It seems to me that,
if the valikey flag is set, then the longjmp() should ALWAYS be taken, since
(I think) the valikey flag is ONLY set when the p-code which is currently
being executed needs to trap, and handle, ikeys LOCALLY.

  Note that the valikey flag is normally FALSE, so the 'normal' action of 
the code below is to note that an ikey has been hit, then return to the code
that was interrupted.
  Note that all bets are off when an ikey occurs during character i/o. This is
a special case in Xenix, and the handling is unusual (see ioerr() in bberr.c).

*/


#include <signal.h>
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"



onikey1()
{
	signal(SIGINT, onikey1);

	ust.stxfl.ikey = TRUE;
	ust.flag2 = FALSE;

	if ( valikey && ust.noikey == FALSE )
		longjmp(ikeyenv,TRUE);

	return(FALSE);
	}



onikey2()
{
	signal(SIGQUIT, onikey2);

	ust.stxfl.ikey = TRUE;
	ust.flag2 = TRUE;

	if ( valikey && ust.noikey == FALSE )
		longjmp(ikeyenv,TRUE);

	return(FALSE);
	}

