/*************************************************************************
*
*
*	Name:  iocpy.c  
*
*	Description:  Copies data from io buffer to terminal buffer
*
*
*	History:
*	Date		By	Comments
*
*	03/10/83	mas
*	04/12/83	mas	put a check in for length > IOSIZE and
*				last character is '\n'
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	08/18/83	waf	re-wrote sections to make iocpy() more efficient.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	Copies string into iobuf and updates iocount
	the string will be concatenated onto whatever 
	is currently in the buffer

	source string must be null terminated

waf	8/18/83
  Check for null count?
  Use count = 0 to signal buffer flush?


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

iocpy(source,length)
char	*source;
int	length;
	{
	register int	len;
	register char	*cptr;
	int		width;

	if ( (len=length) > IOSIZE)
		len = IOSIZE;		/* truncate to buffer size */

	if (iostat.ofd != 1 /*stdout*/)
		width = 132;
	else
		width = ust.pagewidth;

	/** chk for buffer full **/
	if (len + iostat.iocount > IOSIZE)		/* chk space in term buffer */
		termout();		/* flush term buffer */

	/* 04/12/83 fix */
	if(iostat.ofd==1&&source[len-1]=='\n'&&len+ust.columncnt>width)
		++width;

	/** chk for line overflow **/
	if (len + ust.columncnt > width) {
		/* line overflow, flush buffer and start on new line */
		termout();
		if (ust.nocolumn == 0 && ust.columncnt != 0) {
			if (iostat.ofd == 1) {	/* going to terminal */
				iobuf[0] = '\n';
				iostat.iocount = 1;
				}
			else
				iostat.iocount = 0; /* no LF on file i/o */
			}
		ust.columncnt = 0;
		}

	/** move chars to term buffer & adjust char cntr **/
	cptr = &iobuf[iostat.iocount];	/* ptr to current pos in term buf */
	iostat.iocount += len;			/* adjust term buf char cntr */
	while ( len-- > 0 ) {
		if ( (*cptr++ = *source++) == '\n' )
			ust.columncnt = 0;
		else
			++ust.columncnt;
		}
	}

