/*************************************************************************
*
*
*	Name:  inputln.c
*
*	Description:  Input line from terminal
*
*
*	History:
*	Date		By	Comments
*
*	03/23/83	mas
*	04/11/83	WEB	added EOF test for input-file
*	04/18/83	mas	changed to read from file more efficiently
*	04/24/83	mas	changed to handle unpends of 255 correctly
*	04/26/83	WEB	added local eof flag (iofl.ineof)
*	05/05/83	mas	fixed positive and negative input maximum
*				bug.
*	05/06/83	mas	reset input maximum on unpends
*	05/11/83	mas	changed to handle input from character 
*				special files differently from block files
*	05/18/83	mas	added test for rubout as control char and
*				changed input from file (block) to do 132
*				char reads
*	05/24/83	mas	changed to make second ikey print IKEY
*				message like primary ikey
*	6/24/83 	mas	changed to use registers where possible
*	06/29/83	mas	changed to call bpause instead of pause
*				bpause handles interrupts 
*	10/27/83	waf		Use BBCHANS param.
*	10/28/83	waf		Use chanloop() macro.
*	12/14/83	waf		Chk flags when 2ndary ikey char input.
*	02/06/84	waf		Call ioerr() on error from file input.
*	02/21/84	waf		New ioerr() functionality - must handle return.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */



/*  Notes -

  Input from the terminal (stdin) is differentiated from input from a 'file'
(where a 'file' can be either a block or character device).

  See ioerr() in bberr.c for a discussion of ikey's during char i/o.
  Note that, if i/o from or to a char device is ikey'ed, the results of the i/o
are undefined. However, the code in this module will keep string and numeric
vars from being corrupted by an ikey.


Modification Notes -

02/21/84	waf
  The var 'iofl.ineof' is used to skip the rest of the INPUT stmt upon either
an EOF or an ikey of a char device.
  ** NOTE - If input is from stdin, ALL ERRORS ARE IGNORED (including EINTR).

*/



#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/syerms.h"
#include <signal.h>


#define	CHAR	0
#define	BLOCK	1




inputln()
{
	register int	i,j,filtype,chan;
	char	c,cbuf[133];
	long	l;


	iostat.iocount = 0;
	iobuf[0] = '\0';

	ust.flag2 = FALSE;

	if (iostat.ifd != 0 /* stdin */) {

		/***  File Input  ***/

		chan = findchan(iostat.ifd);
		if ((ust.ftab[chan].opmode&CHAR_FM) == CHAR_FM)
			filtype = CHAR;
		else
			filtype = BLOCK;


		/** read input **/
		if (filtype == BLOCK) {

			/* read from block device */
			l = lseek(iostat.ifd,0L,1); /* get current position */
			j = read(iostat.ifd,cbuf,132);
			} 
		else {

			/* read from char device */
			for (i=0; (j=read(iostat.ifd,&cbuf[i],1)) == 1; ++i) {
				c = cbuf[i];
				if (c=='\r'||c=='\n'||c=='\f'||c=='\0') {
					j = i+1;
					break;
					}
				}
			}

		/* chk for EOF/error */
		if ( j == 0 ) {

			/* End of File */
			if ((ust.ftab[chan].opmode&EOF_FS) == EOF_FS)
				bberr(EREOF);		/* 2nd time EOF hit */
			else {
				/* set EOF flag for this file */
				ust.ftab[chan].opmode |= EOF_FS;
				iofl.ineof = TRUE;		/* skip rest of INPUT stmt */
				return;
				}
			}
		else if (j < 0) {

			/* i/o error */
			ioerr() ;	/* report error / chk for EINTR */

			/* EINTR error. Abort input. */
			iofl.ineof = TRUE ;		/* skip rest of INPUT stmt */
			return ;
			}


		/* put chars in iobuf - convert some to CR */
		i = 0;
		do {   /*WHILE*/
			c = cbuf[i++];
			switch (c & 0x00ff) {
			case 015: /*CR*/
			case 012: /*LF*/
			case 014: /*FF*/
			case 0:   /*null*/
				interm(c);
				c = '\015'; /*CR*/
				break;
			default:
				iobuf[iostat.iocount++] = c;
				break;
				}
			} 
			while (c != '\015'/*CR*/);

		if (filtype == BLOCK)
			lseek(iostat.ifd,l + (long)(i & 0xffff),0);
		}

		/**  Terminal Input  **/

	else {
		forever {
			while (read(0/*stdin*/,&c,1) < 0)
				;	/* IGNORE all errors from stdin (including EINTR) */

			if (ust.xfrcrlf == TRUE) {		/* NAS term */
				switch (c) {
				case 0x0d:
					c = 0x0a;
					break;
				case 0x0a:
					c = 0x0d;
					break;
					}
				}

			if (c == ust.unpend1) {
				interm(c);
				break;
				}

			if (c == ust.unpend2) {
				ust.flag2 = TRUE;
				interm(c);
				break;
				}

			if (c == ust.ikey2) {
				/* Chk ikey flags. If ikey is allowed process it,
				   else set flag & ignore the ikey. */
				ust.flag2 = TRUE;		/* flag ikey2 */
				if ( valikey && ust.noikey == FALSE ) {		/* ikeys enabled */
					/* send INT signal to ourselves & wait */
					kill(getpid(),SIGINT);
					bpause(); /* wait for signal to be captured */
					}
				else
					continue ;
				}

			if ((ust.unpend1&0x00ff)==255 && (ust.unpend2&0x00ff)==255) {
				iobuf[iostat.iocount++] = c;
				interm(ust.unpend1);
				break;
				}

			if (c == ust.del) {
				if (iostat.iocount == 0)
					continue;
				else
					--iostat.iocount;

				if (ust.noecho == FALSE) {
					if (ust.dele < 0) {
						c = ust.dele & 0x7f;
						write(1,&c,1);
						write(1," ",1);
						write(1,&c,1);
						} 
					else
						write(1,&ust.dele,1);
					}
				continue;
				}

			if (c == ust.lcan) {
				iostat.iocount = 0;
				if (ust.noecho == FALSE) {
					write(1,&ust.lcane1,1);
					write(1,&ust.lcane2,1);
					}
				continue;
				}

			if ((c < ' ' || c == '\177') && ust.ctlchar == FALSE)
				continue;

			if (c >= 'a' && c <= 'z' && ust.lower == FALSE)
				c -= 'a'-'A';	/* convert lower to upper */

			if (ust.inputmax > 0 && iostat.iocount >= ust.inputmax)
				continue;

			iobuf[iostat.iocount++] = c;

			if (ust.noecho == FALSE)
				write(1,&c,1);

			if (ust.inputmax < 0 && iostat.iocount >= -ust.inputmax) {
				interm(ust.unpend1);
				break;
				}

			}
		}
	}

interm(c)
char	c;
{
	iobuf[iostat.iocount] = '\0';
	iostat.ioterm = c;
	ust.inputmax = crtctrl[ust.termtype]->cinptmx;
	return;
	}


findchan(fd)
int	fd;
{
	register int chan;

	chanloop( chan )
		if (fd == ust.ftab[chan].xfd)
			return(chan);

	return(-1);	/* should never get here */

	} /* end-findchan */
