/*************************************************************************
*
*
*	Name:  gosub.c
*
*	Description:  push next statement address on gosub stack and compute
*			new PC
*
*
*	History:
*	Date		By	Comments
*
*	03/07/83	mas
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -
	This routine used by ONGS and GOSUB

	The return address is calculated differently for a gosub than
	for an ON GOSUB. This is because a gosub can occur as the statement
	to be executed in the on error or int statement. In this case it
	must return to the next p-code following the GOSUB so that the
	RETERR p-code gets executed. This causes no problems for a regular 
	GOSUB since the p-code following the GOSUB is the next statement.
	For an ON GOSUB, however, the address  of the next statement must
	be used since the p-code following the GOSUB label actually
	used may be another label. For this reason the gosub function is
	called with a mode, to signify which calculation to use to find the 
	return address.



*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"

char	*gosub(PC,mode)
POINTER	PC;
int	mode;	/* 0 - gosub */
		/* >0 - on gosub  offset from PC to p-code after labels */
{
register char	*cptr;
	long	*pl;
register unsigned utemp;

	if (mode == 0)
		cptr = PC.B + sizeof(int);
	else
		cptr = PC.PB + mode;	/* on gosub */

	pl = ((struct GFRAMEA *)GFP)->GSADES.adata.l;
	utemp = ((struct GFRAMEA *)GFP)->GSADES.amaxsiz;

	/* make sure there is room on the stack */
	if ((char *)(GFP->GSP + 1) > ((char *)pl) + utemp)
		bberr(BEGSN);

	*GFP->GSP++ = cptr;	/* push return addr on stk */

	PC.B += *PC.J;		/* jump to routine */
	return(PC.B);
}
