/*************************************************************************
*
*
*	Name:  getdata.c
*
*	Description:  Gets data from DATA and RFORM statement 'code lists'.
*
*
*	History:
*	Date		By		Comments
*
*	4/1/83		mas
*	06/16/83	mas		squeezing out memory and speed
*	10/31/83	waf		getadata() - Use ptr to argument (not structure).
*	11/08/83	waf		chkdata() - PEND changed to type 0 opcode.
*	11/09/83	waf		Added getclstr() & chkclop() for generic code list
*					processing. Added makdl() for new MAKDL functionality.
*	12/08/83	waf		chkclop() - chk for ABORT.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

11/9/83		waf
	Functionality of the module was changed to create support for general
  purpose 'code lists'. The interface to getndata() and getadata() was not
  affected. The makdl() fn was added to support MAKDL op-code.

.SH*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/opcodes.h"
#include "/bb/include/bberms.h"

static	POINTER	clptr ;		/* code list pointer */


getndata (addr,type)		/* Get numeric DATA element */

POINTER	addr;
int	type;		/* 0 = J , 1 = L  desired return type*/
{
	register POINTER src,dest;

	src = GFP->DTP ;		/* set up source */
	dest = addr ;			/* set up dest */

	clptr = src ;
	chkclop();		/* check for PEND and JMP */
	src = clptr ;	/* get updated code ptr */


	switch(*src.B++) {
		case LD0J:
		case LD0L:
			if (type == typeJ)
				*dest.J = 0;
			else
				*dest.L = 0;
			break;
		case LD1J:
		case LD1L:
			if (type == typeJ)
				*dest.J = 1;
			else
				*dest.L = 1;
			break;
		case LDBJ:
		case LDBL:
			if (type == typeJ)
				*dest.J = (int)*src.B++;
			else
				*dest.L = (long)*src.B++;
			break;
		case LDCJ:
			if (type == typeJ)
				*dest.J = *src.J++;
			else
				*dest.L = (long)*src.J++;
			break;
		case LDCL:
			if (type == typeJ)
				*dest.J = (int)*src.L++;
			else
				*dest.L = *src.L++;
			break;
		default:
			bberr(BERDT);
		}

	GFP->DTP = src ;		/* update DATA list ptr */
	}


getadata ( sdptr )			/* Get string DATA element */

STRDES	*sdptr;		/* str des to receive string */
{
	STRDES	tstrdes;
	
	clptr = GFP->DTP ;		/* ptr to code list */

	/* get str data */
	if ( getclstr( &tstrdes ) < 0 )
		bberr( BERDT );		/* error - assume 'Wrong DATA type' */

	/* update str des */
	movdd( &tstrdes, sdptr );
	updcl( sdptr );

	/* update DATA list ptr */
	GFP->DTP = clptr ;
	}


makdl ( codeptr, sdptr )

/*
 Create a str des from the code pointed to by codeptr.
 This fn is called by MAKDL.
 'codeptr' is pointing to the code list of an RFORM statement.
*/

POINTER	codeptr;	/* ptr to code list */
STRDES	*sdptr;		/* ptr to str des space */
{

	/* get stk str des */
	clptr = codeptr ;
	if ( getclstr(sdptr) < 0 )
		panic();		/* we hit strange code */
	}


		/** Generic 'code list' fn's **/


static	getclstr ( strdes )

/*
  Build str desc from 'code list'.

  Entry:
	clptr = ptr to code list.

  Return:
	Ret val	= 0  if ok.
			  -1 if error.
	clptr	= updated code list ptr.
	*strdes	= str des for a string constant.
*/

STRDES	*strdes;	/* ptr to str desc to receive data */
{
	register STRDES	*rptr;

	chkclop();		/* check for PEND and JMP */

	rptr = strdes ;		/* use reg var */
	switch( *clptr.B++ ) {

		case LDCA:
			rptr->curlth = (int)*clptr.B++;
			rptr->data = clptr.B;
			clptr.B += (int)*(clptr.B-1);	/* inc code ptr past str */
			return( 0 );

		default:
			return( -1 );	/* bad code */
		}
	}


static	chkclop ()

/*
 Chk next opcode in code list for certain opcodes.

 JMP codes are executed (the ptr is updated).
 PEND code causes 'End of Data' error.

 Entry:
	clptr points to next op-code in code list.

 Return:
	clptr is updated.
*/
{
	register POINTER ptr;

	ptr = clptr ;		/* ptr to next opcode in code list */

	/* chk for end of DATA list */
	if ( *ptr.B == PEND ) {
		bberr( BEEOD );		/* end of data */
		}

	/* chk for JMP */
	if (*ptr.B == JMP) {
		++ptr.B;		/* skip JMP */
		clptr.B = ptr.B + *ptr.J ;	/* get target addr */
		chkclop();		/* skip any more JMPs */
		}

	/* chk for ABORT.
	   Can happen, due to pgm overlays. */
	if ( *ptr.B == ABORT )
		panic();
	}
