/*************************************************************************
*
*
*	Name:  fornext.c
*
*	Description:  forl() - This function sets up the for/next stack
*				for the for loop. It returns FALSE if
*				the control variable is initialized with
*				a value greater than the step value. If
*				there is no room left on the for/next
*				stack, an error is generated. 
*		      nextl() - This adds the step value to the control
*				variable and continues with the next 
*				statement if the limit has been reached.
*
*	History:
*	Date		By	Comments
*
*	03/03/83	mas
*	03/22/83	mas	changed to pop down to correct control variable
*				on NEXT, and to throw away duplicates F/N stack
*				entries (based on control variable address) on
*				FOR.
*	04/19/83	mas	Fixed bug in finding duplicates on the for/next
*				stack. The top of stack was not reset correctly
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"

forl(ctlvar,init,limit,step,loop)
long	*ctlvar;	/* address of control var */
long	init,limit,step; /* initial, limit, and step values */
char	*loop;		/* address of top of loop */
{
register ARRDES	*fnaptr;
register FNDES	*fndptr;
	int	i;

	/* set to GFP plus global frame size plus gosub array des */
	fnaptr = &(((struct GFRAMEA *)GFP)->FNADES);

	fndptr = (GFP->FNSP)-1;		/* point to top of stack */

	/* check for duplicates and remove it if found */
	for(i = 1; fndptr->control.l != ctlvar; ++i) {
		--fndptr;
		if ((unsigned)fndptr < (unsigned)(fnaptr->adata.j)) {
			i = 0;
			break;
		}
	}
	/* if i = 0 then no dups found, otherwise it is a count of entries */
	/* to be moved down */
	if (i != 0) {
		for (; i > 0; --i, ++fndptr) {
			*fndptr = *(fndptr+1); /* move entry down */
		}
		GFP->FNSP = --fndptr;   /* set new top of stack */
	}
		

	/* check to see if another for/next push will overflow the stack */
	if ((char *)(GFP->FNSP+1)>((char *)fnaptr->adata.j)+fnaptr->amaxsiz)
		bberr(BEFRN);

	*ctlvar = init;		/* set control variable to initial value */

	/* if init is > limit then done */
	if ((init > limit && step > 0) || (init < limit && step < 0))
		return(FALSE);

	if (step == 0)
		bberr(BEZST);	/* zero step is an error */

	(GFP->FNSP)->control.l = ctlvar; /* set control var address */
	(GFP->FNSP)->limit.lv = limit;	/* set limit */
	(GFP->FNSP)->step.lv = step;	/* set step */
	(GFP->FNSP)->loop = loop;	/* set loop address */

	++(GFP->FNSP);			/* bump stack pointer */

	return(TRUE);
}

char *nextl(PC,ctlvar)
POINTER PC;
long	*ctlvar;
{
register FNDES	*fndptr;
register ARRDES	*fnaptr;
	long	c,l,s;

	/* point to for/next stack array desc */
	fnaptr = &(((struct GFRAMEA *)GFP)->FNADES);

	/* find matching entry based on control variable address */
	fndptr = (GFP->FNSP)-1;		/* point to top of stack */
	while(fndptr->control.l != ctlvar) {
		--fndptr;
		if ((unsigned)fndptr < (unsigned)(fnaptr->adata.j)) {
			GFP->FNSP = (FNDES *)(fnaptr->adata.j); /* reset FNSP */
			bberr(BENNF);
		}
	}
	/* set new top of stack */
	GFP->FNSP = fndptr+1;		/* point to next available slot */

	c = *(fndptr->control.l);
	l = fndptr->limit.lv;
	s = fndptr->step.lv;

	if((c + s > l && s > 0) || (c + s < l && s < 0)) {
		--(GFP->FNSP);		/* clean up for/next stack */
		return(PC.B);		/* address of p-code after NEXT */
	} else {
		*(fndptr->control.l) += fndptr->step.lv; /*add step to ctl var*/
		return(fndptr->loop);	/* top of loop address */
	}
}
