/*************************************************************************
*
*
*	Name:  bwrite.c
*
*	Description:	WRITE FILE support.
*					(wrl, wrj, wrlj, wra & wrset)
*
*
*	History:
*	Date		By		Comments
*
*	03/14/83        WEB
*	03/29/83	WEB	changed wrj to wrlj, added new wrj
*	06/16/83	mas	memory ans speed squeeze
*	09/02/83	waf	Chk for EINTR error in write() calls.
*	09/02/83	waf 	** Re-write -
*					Combine code for all data writes.
*					Chk for error/ikey ret on write().
*					Optimize code.
*	10/05/83	waf		Use ioerr() to chk write() error.
*	02/21/84	waf		New ioerr() functionality - must handle return.
*						Added 'skipflag' to skip rest of var list on 
*					char device ikey.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

9/06/83		waf
  Buffer numeric writes ?

02/21/84	waf
  See ioerr() in bberr.c for a discussion of ikey's during char i/o.
  Note that, if i/o from or to a char device is ikey'ed, the results of the i/o
are undefined. In particular, output may be truncated if an ikey occurs.

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"


static	int	skipflag ;		/* if set, skip rest of Basic statement */



wrset (channel)
int	channel;
{
	register int	i;
	int		fd;

	/* chk channel */
	if ( (i = xlt2bchan(channel, &fd)) == 16 )
		bberr( BEIFN );		/* illegal file# */
	if ( i == 0 )
		bberr(BEWRM); 		/* read-only mode */

	lastfileno = channel;	/* save channel of last i/o */

	/* reset skip flag */
	skipflag = 0 ;

	}

/**  Write typed data  **/

wrl (value)		/* Write type l value */
long	value;
{
	wrdata( (char *)&value, 4, NUMERIC );
	}

wrj ( value )	/* Write type j value */
int	value;
{
	wrdata( (char *)&value, 2, NUMERIC );
	}

wrlj ( value )	/* Write type l value as a type j value */
long	value;
{
	wrj( (int)value );
	}

wra ( str )		/* Write string data */
STRDES	str;
{
	register char	*ptr;
	register int	n;

	/* null fill the string */
	ptr = str.data + str.curlth ;
	for ( n = (str.maxlth-str.curlth) ; n-- > 0 ; )
		*ptr++ = '\0' ;

	wrdata( str.data, str.maxlth, STRING );
	}

/**  Write generic data  **/

static	wrdata ( dataptr, nbytes, flag )

char	*dataptr;	/* ptr to data */
int		nbytes;		/* # bytes to be written */
int		flag;		/* STRING/NUMERIC flag */
{
	register int	n;
	char   	buf[8];


	/* chk skip flag */
	if ( skipflag )
		return ;		/* skipping rest of statement */

	/* swab numerics */
	if ( flag != STRING ) {
		swab( dataptr, buf, nbytes );
		dataptr = buf ;
		}

	n = write(ust.ftab[lastfileno].xfd, dataptr, nbytes) ;
	if ( n != nbytes ) {

		/* error */
		ioerr() ;		/* report error / chk for EINTR */
		skipflag = -1 ;	/* EINTR error - skip rest of statement */
		}
	}
