/*************************************************************************
*
*
*	Name:  binput.c
*
*	Description:	INPUT support routines.
*			inl()	- Input long variable
*			ina()	- Input string variable
*			inprm()	- Input prompt.
*
*
*	Date		By	Comments
*
*	03/01/83        MAS
*   03/10/83        WEB     added INPUT-USING & INPUT-FILE
*   04/25/83        WEB     fixed problem with missing prompts in
*				INPUT USING "",<iolist>
*	04/25/83	mas	added check for end of file and to handle
*				quoted strings in input
*	05/06/83	mas	changed so that only INPUT processes quotes
*				and so that INPUT USING would no throw away 
*				leading spaces
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	06/08/83	mas	changed to cause error if in input using
*				and inputln() is called more than once
*	06/16/83	mas	memory and speed squeeze
*	11/15/83	waf		Combined invar.c & inprm.c into this module.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


inl(lvar)					/* input numeric variable */
long	*lvar;
{
	char   *lnptr;

	if(iofl.ineof == TRUE)
		return;			/* if past end of file don't do anything */

	if (iofl.prtprm == FALSE && iofl.moredata == FALSE && iostat.ifd == 0) {
		iostat.iocount = 0;
		iocpy(" ? ",3);
		termout();
		termflush();
		} 
	else if (iofl.inusing == TRUE && iofl.inustring > 1)
		bberr(BEIIN);

	forever {
		if (iofl.moredata == TRUE) {
			lnptr = &iobuf[iostat.iopos];
			cdbl(&lnptr, lvar, 1);
			while(*lnptr == ' ')
				++lnptr;		/* skip spaces */
			if (*lnptr == '\0') {			/* EOL */
				iofl.moredata = FALSE;
				iostat.iopos = 0;
				iostat.iocount = 0;
				break;				/* got it leave function */
				} 
			else if (*lnptr == ',') {
				iofl.moredata = TRUE;
				iostat.iopos = lnptr-iobuf+1;
				break;				/* got it leave function */
				} 
			else if (iofl.inusing == TRUE || iostat.ifd != 0)
				bberr(BEIIN); 	/* error if USING or FILE */
			else {
				iofl.moredata = FALSE;
				iostat.iocount = 0;
				iocpy("\007\\ ? ",5);
				iofl.prtprm = TRUE;
				}
			}
		/* only allow one call to inputln() if in INPUT USING */
		if (iofl.inusing == TRUE) {
			if (iofl.inline == TRUE) /* already called once*/
				bberr(BEIIN);
			else
				iofl.inline = TRUE;
			}
		if (iofl.prtprm == TRUE) {
			termout();
			termflush();
			iofl.prtprm = FALSE;
			}
		iostat.iopos = 0;
		inputln();	/* get line from keyboard */
		iofl.moredata = TRUE;
		} /* end-forever */

	iofl.inustring = 0;				/* clear USING/string flag */

	return;

	} /* end-inl */


ina(svar)					/* input string variable */
STRDES   svar;
{
	char  c,lterm,buf[IOSIZE];
	register char	*lnptr;
	register int   length,i;

	if(iofl.ineof == TRUE)
		return;			/* if past end of file don't do anything */

	if (iofl.inusing == TRUE && iofl.inustring > 1)
		bberr(BEIIN);			/* error after second string */

	if (iofl.inusing == TRUE && iofl.inustring == 1) {
		*svar.data++ = iostat.ioterm;	/* move terminator to 2nd str */
		--svar.maxlth;
		updcl(&svar);			/* update current length */
		iofl.inustring++;				/* set USING/string flag */
		return;				/* exit */
		}

	/* only allow one call to inputln() if in INPUT USING */
	if (iofl.inusing == TRUE && iofl.moredata == FALSE) {
		if (iofl.inline == TRUE) /* already called once*/
			bberr(BEIIN);
		else
			iofl.inline = TRUE;
		}

	if (iofl.prtprm == FALSE && iofl.moredata == FALSE && iostat.ifd == 0) {
		iostat.iocount = 0;
		iocpy(" ? ",3);
		termout();
		termflush();
		}

	if (iofl.moredata == FALSE) {
		if (iofl.prtprm == TRUE) {
			termout();
			termflush();
			iofl.prtprm = FALSE;
			}
		iostat.iopos = 0;
		inputln();	/* get line from keyboard */
		} /* end-if */

	if(iofl.ineof == TRUE)
		return;			/* if past end of file don't do anything */

	if (iofl.inusing == FALSE) {
		for(;(c = iobuf[iostat.iopos]) == ' ' || c == '\t';++iostat.iopos)
			;			/* skip white space */
		}

	if (iobuf[iostat.iopos] == '"' && iofl.inusing == FALSE) {
		lnptr = &iobuf[iostat.iopos+1];
		lterm = '"';
		} 
	else {
		lnptr = &iobuf[iostat.iopos];
		lterm = ',';
		}

	strcpy(buf,lnptr);	/* get string from i/o buffer */

	for (i = 0; buf[i] != '\0' &&
      (buf[i] != lterm || iofl.inusing == TRUE); ++i)
		    ;					/* find appropriate end */

	buf[i] = '\0';

	if(iofl.inusing == TRUE)
		length = strlen(buf);
	else
		length = cnvangle(buf);

	for (i = 0; length > 0 && svar.maxlth > 0; ++i) {
		*svar.data++ = buf[i];
		--svar.maxlth;
		--length;
		}

	updcl(&svar);				/* update current length */

	if (iofl.inusing == TRUE) {
		iofl.moredata = FALSE;
		iostat.iopos = 0;
		iostat.iocount = 0;
		} 
	else {
		lnptr = &iobuf[iostat.iopos];
		if (*lnptr == '"' && iofl.inusing == FALSE) {
			lterm = '"';
			++lnptr;
			} 
		else
			lterm = ',';
		for(; *lnptr != lterm && *lnptr != '\0';++lnptr)
			;
		if (*lnptr == '"')
			++lnptr;
		if (*lnptr == '\0') {		/* EOL */
			iofl.moredata = FALSE;
			iostat.iopos = 0;
			iostat.iocount = 0;
			} 
		else if (*lnptr == ',') {
			iofl.moredata = TRUE;
			iostat.iopos = lnptr-iobuf+1;
			} /* end-if */
		} /* end-else-if */

	iofl.inustring++;				/* set USING/string flag */

	return;

	} /* end-ina */


inprm(string,length)		/* Input prompt */
char	*string;
int	length;
{

	if (iofl.moredata == TRUE) /* if data there then don't blow it away */
		return;

	if (iofl.prtprm == FALSE)
		iostat.iocount = 0;

	if (iostat.ofd == 1) {	/* if to terminal then do prompt */
		iocpy(string,length);
		iofl.prtprm = TRUE;
		} 
	else
		iofl.prtprm = FALSE; /* if to file then nop */

	return;
	}
