
0005 Rem - QFILESORT.bb
:
:       FILE SORT ARGUMENTS PASSED IN COMMON:
:
:               1,1     Channel # of file to be sorted
:               2,5     # of records to sort
:               6,7     Record size in bytes
:               8,11    Byte offset to 1st record
:               12,12   Sort modifiers must = 0
:               13,13   # of key fields in record must = 1
:               14,15   First byte of key
:               16,17   Last byte of key
:               18,18   Key tape must = 0
:               19-     Reserved
:
:       RETURNED IN COMMON
:
:               1,2     Error code
:                         0 = OK
:                         n = BBASIC error
:                        -n = RDOS error
:
0010 ON ERR THEN GOTO 0600
0020 DEF FND(I)=OR(I,-AND(I,SHFT(1,32)/2))
0100 DIM X$[512]                 : Common area buffer
0110 LET E=0                     : Error flag
0200 BLOCK READ X$               : Get arguments
0220 LET C%=ASC(X$[1,1])         : Channel #
0230 LET R=FND(ASC(X$[2,5]))     : # of recs
0240 LET C=ASC(X$[6,7])          : Rec size
0250 LET D=FND(ASC(X$[8,11]))    : File displacement
0260 IF ASC(X$[13,13])<>1 THEN STOP      : Only 1 key allowed!
0270 LET K%=ASC(X$[14,15])       : Beginning key column
0280 LET K0%=ASC(X$[16,17])      : Ending key column
0290 IF OR(ASC(X$[12,12]),ASC(X$[18,18])) THEN STOP 
0300 IF R<=1 THEN GOTO 0400      : Sort <= 1 record?
0310 GOSUB 9001                  : Do it.
0400 DIM X$[512]
0410 LET X$=CHR$(E,2),FILL$(0)   : Return any errors
0420 BLOCK WRITE X$
0430 STMA 2,1,E
0500 END                         : Done
:
: Error handler
:
0600 LET E=SYS(7)                : Error #
0610 STMA 8,0                    : Clear stacks
0620 GOTO 0400                   : Return to caller
:
: Filesort using "QSORT" algorithm
:
9001 DIM U9[16],L9[16],X$[C],Y$[C],Z$[C],T9$[C],T8$[C]
9010 LET U8=R
9020 LET Z%=1
9030 LET M9=1
9040 LET B8=1
9050 LET I8=B8
9060 LET J9=U8
9070 IF I8>=J9 THEN GOTO 9440
9080 LET K9=I8
9090 LET I9=(J9+I8)/2
9091 POSITION FILE[C%,(I9-Z%)*C+D]
9092 READ FILE[C%],X$
9100 LET T9$=X$
9101 POSITION FILE[C%,(I8-Z%)*C+D]
9102 READ FILE[C%],Y$
9110 IF Y$[K%,K0%]<=T9$[K%,K0%] THEN GOTO 9150
9115 POSITION FILE[C%,(I8-Z%)*C+D]
9120 WRITE FILE[C%],T9$
9125 POSITION FILE[C%,(I9-Z%)*C+D]
9130 WRITE FILE[C%],Y$
9140 LET X$=Y$
9141 LET Y$=T9$
9142 LET T9$=X$
9150 LET L9=J9
9151 POSITION FILE[C%,(J9-Z%)*C+D]
9152 READ FILE[C%],Z$
9160 IF 9160 THEN IF Z$[K%,K0%]>=T9$[K%,K0%] THEN GOTO 9270
9165 POSITION FILE[C%,(J9-Z%)*C+D]
9170 WRITE FILE[C%],T9$
9175 POSITION FILE[C%,(I9-Z%)*C+D]
9180 WRITE FILE[C%],Z$
9190 LET X$=Z$
9191 LET Z$=T9$
9192 LET T9$=X$
9196 IF I9=I8 THEN LET Y$=X$
9200 IF Y$[K%,K0%]<=T9$[K%,K0%] THEN GOTO 9270
9205 POSITION FILE[C%,(I8-Z%)*C+D]
9210 WRITE FILE[C%],T9$
9215 POSITION FILE[C%,(I9-Z%)*C+D]
9220 WRITE FILE[C%],Y$
9230 LET X$=Y$
9231 LET Y$=T9$
9232 LET T9$=X$
9240 GOTO 9270
9250 POSITION FILE[C%,(K9-Z%)*C+D]
9255 WRITE FILE[C%],T8$
9260 POSITION FILE[C%,(L9-Z%)*C+D]
9265 WRITE FILE[C%],Y$
9267 LET X$=Y$
9268 LET Y$=T8$
9270 LET L9=L9-1
9271 POSITION FILE[C%,(L9-Z%)*C+D]
9272 READ FILE[C%],X$
9280 IF X$[K%,K0%]>T9$[K%,K0%] THEN GOTO 9270
9290 LET T8$=X$
9300 LET K9=K9+1
9301 POSITION FILE[C%,(K9-Z%)*C+D]
9302 READ FILE[C%],Y$
9310 IF Y$[K%,K0%]<T9$[K%,K0%] THEN GOTO 9300
9320 IF K9<=L9 THEN GOTO 9250
9330 IF L9-I8<=J9-K9 THEN GOTO 9390
9340 LET L9[M9]=I8
9350 LET U9[M9]=L9
9360 LET I8=K9
9370 LET M9=M9+1
9380 GOTO 9480
9390 LET L9[M9]=K9
9400 LET U9[M9]=J9
9410 LET J9=L9
9420 LET M9=M9+1
9430 GOTO 9480
9440 LET M9=M9-1
9450 IF M9=0 THEN RETURN 
9460 LET I8=L9[M9]
9470 LET J9=U9[M9]
9480 IF J9-I8>=11 THEN GOTO 9080
9490 IF I8=B8 THEN GOTO 9070
9500 LET I8=I8-1
9510 LET I8=I8+1
9520 IF I8=J9 THEN GOTO 9440
9521 POSITION FILE[C%,(I8-Z%)*C+D]
9522 READ FILE[C%],X$
9525 POSITION FILE[C%,(I8+1-Z%)*C+D]
9530 READ FILE[C%],T9$
9540 IF X$[K%,K0%]<=T9$[K%,K0%] THEN GOTO 9510
9550 LET K9=I8
9560 POSITION FILE[C%,(K9-Z%)*C+D]
9562 READ FILE[C%],Z$
9564 WRITE FILE[C%],Z$
9570 LET K9=K9-1
9572 POSITION FILE[C%,(K9-Z%)*C+D]
9573 READ FILE[C%],Z$
9580 IF T9$[K%,K0%]<Z$[K%,K0%] THEN GOTO 9560
9590 WRITE FILE[C%],T9$
9600 GOTO 9510
