:   INDEXPRT - Displays an index file showing all levels of the index tree
:      with the seequential link verified against the tree links.
:      Conversion of keys is provided for crammed and integer keys for display.
:      Compound keys of multiple key types are not directly supported, although
:      string keys display any non-printing values as their ASCII value.
:
0010 Rem - INDEXPRT.bb
0110 CLOSE 
0130 DIM NFILE$[13],T$[512],X$[132],LFTABL$[26]
0135 DIM ENTRY%[10],RSTACK[10]                         :Used to be default DIM'd
0140 DIM MSTRFL$[13],SUBFIL$[10]
0142 ON ERR THEN GOTO 9500
0144 ON IKEY THEN GOTO 9550
0146 STMA 6,1
0150 INPUT "LOGICAL FILE NAME ",NFILE$                 :Get index file name
0160 LET E=0
0170 LET LFTABL$=FILL$(0)
0180 LOPEN E,FILE[1,T$],NFILE$                         :Assume a DBMS file and LOPEN it
0190 IF E THEN GOTO 0230                               :Skip if error occurred
0200 UNPACK "CL+2A10CLA",LFTABL$,CHAN,OFFSET,MSTRFL$,RSIZE%,LREC           :Set up file data
0210 IF LFTABL$[25,25]<>"I" THEN STMA 19,89            :Error if file type is not I
0220 GOTO 0330
0230 IF E<>84 THEN STMA 19,E                           :Error message if other than 76
0232 PRINT "NOT A DATA BASE FILE"
0240 LET MSTRFL$=NFILE$                                :Logical file is also physical file
0250 LET CHAN=0
0260 LET RSIZE%=512
0270 INPUT "BYTE OFFSET TO RECORD 0 [0]: ",OFFSET                :Get byte offset to record 0 in physical file
0280 IF MOD(OFFSET,512)=0 THEN GOTO 0310               :Must start on sector boundary
0290 PRINT "INDEX FILE MUST BEGIN ON A SECTOR BOUNDARY!!"
0300 GOTO 0270
0310 OPEN FILE[CHAN,6],MSTRFL$                         :Open physical file
0320 LOPEN FILE[1,CHAN],MSTRFL$,"I",RSIZE%
0330 INPUT "KEY TYPE (1-INTEGER,2-STRING,3-CRAM) ? ",KTYPE%                :Get key type
0340 LET TRO%=16                         :dummy channel #
0350 LET LSTCHN%=TRO%                    :Assume listing to terminal
0360 INPUT "LISTING GOES TO (0)TERMINAL, (1)PRINTER : ",I%
0370 IF I%=0 THEN GOTO 0410              :Skip LPT open
0380 LET LSTCHN%=2
0390 STMA 9,3,X$
0400 OPEN FILE[LSTCHN%,2],X$
:
:   Define stack ref. functions
0410 DEF FND(X)=OR(X,-AND(X,SHFT(1,32)/2))              := #of keys at level X
0415 DEF FNN(X)=ASC(BUFFER$[X*512+1,X*512+2])
0420 DEF FNP(X)=ASC(BUFFER$[X*512+3,X*512+4])           := seq. link at level X
0430 DEF FNB(X)=X*512+(ENTRY%[X]-1)*ESIZE%+5            := begin byte of current entry at level X
0440 DEF FNE(X)=X*512+ENTRY%[X]*ESIZE%+4                := ending byte of current entry at level X
0450 DEF FNX(X)=FND(ASC(BUFFER$[FNE(X)-3,FNE(X)]))      := pointer value of current entry at level X
:   Output index description from block 0 of index
0460 LET T$=""                           :Clear tmp string
0470 LET BLKDSP=OFFSET/512               :Get block offset from byte ofset
0480 POSITION FILE[CHAN,OFFSET]          :Read block 0 parameters
0490 READ FILE[CHAN],ESIZE%,KS2BLK%,BLKMAX%,NXAVL%,BLK0%,BLKFAC%,DUPKEY%
0500 LET KSIZE%=ESIZE%-4
0510 FOR X=LSTCHN% TO TRO% STEP MAX(1,TRO%-LSTCHN%)          :Output info to both LPT and TRO if LPT is output
0520   PRINT FILE[X],
0530   PRINT FILE[X],"KEY SIZE = ";KSIZE%
0540   PRINT FILE[X],"KEYS/BLOCK = ";KS2BLK%
0550   PRINT FILE[X],"MAX BLOCKS = ";BLKMAX%
0560   PRINT FILE[X],"NEXT BLOCK = ";NXAVL%
0570   PRINT FILE[X],"BLOCK ZERO = ";BLK0%
0580   PRINT FILE[X],"BLOCKING FACTOR = ";BLKFAC%*100/KS2BLK%;"%"
0590   IF DUPKEY%=0 THEN PRINT FILE[X],"NO ";
0600   PRINT FILE[X],"DUPLICATE KEYS ALLOWED"
0610   PRINT FILE[X],
0620   PRINT FILE[X],"BEGINNING KEY: ";
0630 NEXT X
:
:   Get value of beginning key
0640 IF I% THEN PRINT FILE[LSTCHN%],"BEGINNING KEY = <34>";
:                     Integer,String,Cram
0650 ON KTYPE% THEN GOTO 0660, 0710, 0750          :Vector on key type
:   Integer key initialization
0660 LET LNSIZE%=13+3*KSIZE%             :Field size for integer key
0670 INPUT USING "",X                    :Accept beginning key
0680 LET X$=CHR$(X,KSIZE%)               :Search key
0690 IF I% THEN PRINT FILE[LSTCHN%],X;"<34>"            :Log specified key
0700 GOTO 0790
:   String key initialization
0710 LET LNSIZE%=14+KSIZE%               :Field size for string key
0720 INPUT USING "",X$                   :Accept beginning key
0730 IF I% THEN PRINT FILE[LSTCHN%],X$;"<34>"           :Log key
0740 GOTO 0790
:   Cram key initialization
0750 LET LNSIZE%=14+KSIZE%*3/2           :Field size for crammed key
0760 INPUT USING "",X$                   :Accept beginning key
0770 IF I% THEN PRINT FILE[LSTCHN%],X$;"<34>"           :Log key
0780 LET X$=CRM$(X$)                     :Cram before search
:
:   Find key and determine required stack size
0790 LET RSTAKP%=-1                      :Init stack pointer
0800 LET R1=BLK0%                        :Start at top of tree
0810 LET RSTAKP%=RSTAKP%+1               :Bump pointer
0820 LET RSTACK[RSTAKP%]=R1              :Push rec # for this level
0830 POSITION FILE[CHAN,OFFSET+R1*RSIZE%]      :Read block
0840 READ FILE[CHAN],NKEYS%,PNEXT%,T$[1,508]
0850 FOR I%=1 TO (NKEYS%-1)*ESIZE%+1 STEP ESIZE%        :Scan entries for match
0860   IF PNEXT%=0 THEN IF X$[1,MIN(LEN(X$),ESIZE%-4)]<=T$[I%,I%+MIN(LEN(X$),ESIZE%-4)-1] THEN GOTO 0910
0870   IF PNEXT% THEN IF X$<=T$[I%,I%+LEN(X$)-1] THEN GOTO 0910
0880 NEXT I%
0890 IF PNEXT%=0 THEN STOP               :PANIC! error in intermediate lvel
0900 GOTO 0940                           :Key was probably deleted, use this block
0910 LET R1=FND(ASC(T$[I%+ESIZE%-4,I%+ESIZE%-1]))       :Save pointer from this entry
0920 LET ENTRY%[RSTAKP%]=I%/ESIZE%+1          :Push location of entry for this lvel
0930 IF PNEXT%=0 THEN GOTO 0810          :Intermediate level, go around again
0940 LET ENTRY%[RSTAKP%]=1               :Bottom level, begin with first entry
:
:   Allocate and initialize buffer stack
0950 DIM BUFFER$[(RSTAKP%+1)*512]        :Allocate buffer stack
0960 FOR I%=0 TO RSTAKP%                 :Re-trace path, filling stack
0970   BLOCK READ FILE[CHAN,RSTACK[I%]+BLKDSP],BUFFER$[I%*512+1,(I%+1)*512]
0980 NEXT I%
:
:   Begin main processing loop
0990 LET NDFLAG%=0                       :Clear end flag
1000 LET PRPREV%=1                       :Set flag to force printing all levels for first key
1010 LET ENTRYL=RSTAKP%                  :Set entry level to top of stack
1020 IF FNN(ENTRYL)<ENTRY%[ENTRYL] THEN GOSUB 6500           :Check for no more entries this level
1030 GOSUB 7200                          :Process current entry
1040 PRINT FILE[LSTCHN%],""
1050 IF NDFLAG%=0 THEN GOTO 1010         :More entries?
1060 CLOSE                               :Done
1070 END 
:
:   Next level 0 read procedure
6500 LET TNTRYL=ENTRYL                   :Init tmp pointer to current level
6510 LET X=FNP(TNTRYL)                   :Save seq link
6520 GOSUB 6600                          :Call read proc
6540 IF X=FNX(TNTRYL-1) THEN RETURN           :Seq link and prev level pointer match
6550 IF PRPREV% THEN RETURN              :TEST IS INVALID ON INITIAL PASS
6560 PRINT FILE[LSTCHN%],"SEQUENTIAL LINK ERROR, LINK =";X
6580 RETURN 
:   Block read procedure
6600 LET TNTRYL=TNTRYL-1                 :Pop level to get next pointer to current level
6700 IF FNN(TNTRYL)<ENTRY%[TNTRYL] THEN GOSUB 6600           :This level exhausted, try previous
6800 LET TNTRYL=TNTRYL+1                 :Push level back to current
6900 BLOCK READ FILE[CHAN,FNX(TNTRYL-1)+BLKDSP],BUFFER$[TNTRYL*512+1,(TNTRYL+1)*512]
7000 LET ENTRY%[TNTRYL]=1                :Set current entry to first
7100 RETURN 
:
:   Key entry display procedure
7200 LET TNTRYL=ENTRYL                   :Entry for bottom level
7300 GOTO 7500
7400 LET TNTRYL=TNTRYL-1                 :Entry pops stack to previous level
7500 LET T$="00",ENTRY%[TNTRYL]," "           :Put entry # for this level in print field
7600 LET T$=T$[LEN(T$)-2]
7700 LET I%=LEN(T$)+1                    :Point to next field
7720 IF FNN(TNTRYL)=0 THEN GOTO 8885          :Empty block
:                     Integer,String,Cram
7800 ON KTYPE% THEN GOTO 8500, 7810, 8000          :Vector to proc for key type
:   String key procedure
7810 LET X$=BUFFER$[FNB(TNTRYL),FNE(TNTRYL)-4]          :Get key field
7820 FOR I%=1 TO LEN(X$)                 :Scan converting specials to asc equiv
7830   IF X$[I%,I%]>=" " THEN IF X$[I%,I%]<="~" THEN GOTO 7860
7840   LET T$[LEN(T$)+1]="<",ASC(X$[I%,I%]),">"
7850   GOTO 7870
7860   LET T$[LEN(T$)+1]=X$[I%,I%]
7870 NEXT I%
7880 GOTO 8600
:   Crammed key procedure
8000 LET T$[I%]=BUFFER$[FNB(TNTRYL),FNE(TNTRYL)-4]           :Get key field
8100 LET X=LEN(T$)+1                     :Use ent of tmp for scratch
8200 LET T$[X]=UCM$(T$[I%])
8300 LET T$[I%]=T$[X]                    :Move field to proper loc
8400 GOTO 8600
:   Integer key procedure
8500 LET T$[I%]=FND(ASC(BUFFER$[FNB(TNTRYL),FNE(TNTRYL)-4]))," "
:   Pointer display procedure
8600 LET I%=LEN(T$)+1                    :point to next field
8700 LET X=FND(ASC(BUFFER$[FNE(TNTRYL)-3,FNE(TNTRYL)]))      :Put pointer in print line
8800 LET T$[I%]=" ",X," "
8885 IF LEN(T$)<LNSIZE% THEN LET T$[LEN(T$)+1,LNSIZE%]=FILL$(32)            :Pad to entry field size
8900 PRINT FILE[LSTCHN%],T$;             :Output entry, don't LF incase another level is needed
9000 IF FNN(TNTRYL) THEN IF X=-1 THEN LET NDFLAG%=1          :End of index???
9040 IF TNTRYL=0 THEN LET PRPREV%=0           :Bottom of stack, can't pop any more
9050 IF PRPREV% THEN IF ENTRY%[TNTRYL]<>1 THEN IF TNTRYL>0 THEN GOSUB 7400        :Call again for previous level
9100 IF ENTRY%[TNTRYL]=1 THEN IF TNTRYL>0 THEN GOSUB 7400         :Call again for previous level
9200 LET ENTRY%[TNTRYL]=ENTRY%[TNTRYL]+1           :Bump entry pointer for this level
9300 LET TNTRYL=TNTRYL+1                 :Push pointer back to top of stack
9400 RETURN 
9500 ON ERR THEN INT
9505 LET X$="ERROR NO. ",SYS(7)," - ",ERM$(SYS(7))
9510 PRINT @(-25);X$
9515 NEW 
9550 PRINT " INT"
9555 GOTO 9515
