/*************************************************************************
*
*
*	Name:  debvar.c
*
*	Description:  Debugger - var display & assign routines.
*
*
*	History:
*	Date		By		Comments
*
*	4/14/83		waf
*	6/27/83		mas	changed to only add maxlth char to string
*			and changed to convert angle brackets in 
*			string assignments
*	7/12/83		mas	changed to allow brackets on array assignment
*	08/29/83	waf	Show error msg if string subscripting attempted.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */
#include	"debug.h"

debvar ( )

{
	int	x,n,i;
	int	ptr,ix;
	int	varos,varix;
	char	vartype;
	int	letflg;
	int	elem,sub1,sub2;

	letflg = FALSE ;
	if ( strcmp(trun( token.str,1), "L" ) == 0 ) {
		if ( pmcall() == FALSE )  return( 0 );
		letflg = TRUE ;
		}

	/* Show or assign var */
	vartype = getvartyp();
	varix = varlookup( token.str );
	if ( varix < 0 ) return( 0 );		/* var not found */
	varos = getvaros( varix ) ;		/* variable offset in GF */
	showoa( varos );
	/** display val or assign val **/
	switch ( vartype ) {
		case 'J':
		case 'L':
				/* Numeric */
				if ( vtab[varix].numsubs == 0 ) {
					/* scaler var */
					if ( letflg ) {
						/* get const */
						gettkn(-1);
						if ( token.str[0] != '=' )
							syntax();
						gettkn( NUM );		/* const */
						putstklw( varos, token.nval );		/* store value */
						}
					else {
						lval = getstklw( varos );
						printf( "  val (dec) = %D\n", lval );	/* show value */
						}
					}
				else {
					/* array var */
					/* (assumes type L elements) */
					getades( varos );	/* get array desc */
					printf( "  data>" );
					x = adr_sos( ades.adata.l );
					showoa( x );
					if ( letflg ) {
						/* array assignment */
						gettkn(-1);
						if(token.str[0]!='('&&token.str[0]!='[')
							error( "Must have subscripts" );
						gettkn( NUM );
						n = 1 ;		/* # of subs */
						sub1 = ((int) token.nval) ;
						gettkn(-1);
						if ( token.str[0] == ',' ) {
							/* 2 subscripts */
							gettkn( NUM );
							n++ ;
							sub2 = (int) token.nval ;
							gettkn( OTHER );	/* ')' */
							}
						else
							sub2 = 0 ;
						if ( n != ades.numdim )
							error( "Wrong # of subscripts" );
						elem = sub2 + ( sub1 * (arydim2 + 1) );	/* elem offset */
						printf( "  elem# = %d\n", elem );
						x = ades.adata.l + elem ;		/* addr of elem */
						sos = adr_sos( x );
						printf( "  elem>" );
						showoa( sos );
						if(token.str[0]!=')'&&token.str[0]!=']')
							syntax();
						gettkn();		/* '=' */
						gettkn( NUM );
						putstklw( sos, token.nval );
						}
					else {
						/* show array */
						sos = adr_sos( ades.adata.l );		/* stk os of data */
						printf( "  maxsize = %d    # dims = %d\n", ades.amaxsiz,
						ades.numdim );
						printf( "  current bounds =  %d  %d", arydim1, arydim2 );
						/* show data */
						k = ades.amaxsiz / 4 ;		/* # of elements */
						for ( j=0 ; j < k ; j++ ) {
							if ( (j % 10) == 0 )
								printf( "\n%4.d >", j );
							if ( (j % 5) == 0 )  printf( "  " );
							printf( "%5.D ", getstklw( sos ) );
							sos += 4 ;
							}
						putchar( '\n' );
						}
					}
				break;

		case 'A': 	/* String */
				getsdes( varos );
				if ( letflg ) {
					gettkn(-1);
					if ( token.str[0] != '=' ) {
						if ( token.str[0] == '(' ) {
	strsub:
							error( "String subscripting not supported" );
							}
						else
							syntax();
						}
					gettkn( STRLIT );
					/* os of $ data in stk */
					sos = adr_sos( sdes.pdata );
					cnvangle(token.str);		/* convert '<nnn>'s */

					/* copy $ into stk */
					i = strlen(token.str);
					x = (i < sdes.maxlth)? i : sdes.maxlth;
					strncpy( &evalstk[sos], token.str , x);

					sdes.curlth = x;
					sdes.pcurlth = x;
					putsdes( varos );
					}
				else {
					gettkn(-1);
					if ( token.str[0] == '(' )
						goto strsub;
					printf( "  curlth = %d  maxlth = %d\n",
					sdes.curlth, sdes.maxlth );
					printf( "  data>" );
					x = adr_sos( sdes.pdata );
					showoa( x );
					printf( "  val = \"" );
					sos = adr_sos( sdes.pdata );		/* os of $data in stk */
					bptr = &evalstk[sos] ;		/* $ data ptr */
					for ( i=0 ; i < sdes.curlth ; i++ ) {
						c = *bptr++ ;
						j = (int) c & 255;
						if ( j < 32 || j > 127 )
							printf( "<%u>", j );
						else
							putchar( c );
						}
					printf( "\"\n" );
					}
				break;
			}
	}
