#define NOP	0
/* Opcodes 1 thru 9 are reserved for lead-in codes for two byte opcodes */

/* Numeric opcodes must be grouped together in order J, L, X */
#define LD0J	10
#define LD0L	11
#define LD0X	12

#define LD1J	13
#define LD1L	14
#define LD1X	15

#define LDBJ	16
#define LDBL	17
#define LDBX	18

#define LDCJ	19
#define LDCL	20
#define LDCX	21

#define LDVJ	22
#define LDVL	23
#define LDVX	24

#define LDDJ	25
#define LDDL	26
#define LDDX	27

#define SBDJ	28
#define SBDL	29
#define SBDX	30

#define SBAJ	31
#define SBAL	32
#define SBAX	33

#define SBVJ	34
#define SBVL	35
#define SBVX	36

#define LDIJ	37
#define LDIL	38
#define LDIX	39

#define LDIDJ	40
#define LDIDL	41
#define LDIDX	42

#define STIJ	43
#define STIL	44
#define STIX	45

#define STIDJ	46
#define STIDL	47
#define STIDX	48

#define ADDJ	49
#define ADDL	50
#define ADDX	51

#define SUBJ	52
#define SUBL	53
#define SUBX	54

#define MULJ	55
#define MULL	56
#define MULX	57

#define DIVJ	58
#define DIVL	59
#define DIVX	60

#define NEGJ	61
#define NEGL	62
#define NEGX	63

#define CMPJ	64
#define CMPL	65
#define CMPX	66

#define DPRJ	67
#define DPRL	68
#define DPRX	69

#define FORJ	70
#define FORL	71
#define FORX	72

#define NXTJ	73
#define NXTL	74
#define NXTX	75

#define PRA	76
#define PRJ	77
#define PRL	78
#define PRX	79

#define PRUA	80
#define PRUJ	81
#define PRUL	82
#define PRUX	83

#define INA	84
#define INJ	85
#define INL	86
#define INX	87

#define RDA	88
#define RDJ	89
#define RDL	90
#define RDX	91
#define RDLJ	92

#define WRA	93
#define WRJ	94
#define WRL	95
#define WRX	96
#define WRLJ	97

#define PAKA	98
#define PAKJ	99
#define PAKL	100
#define PAKX	101
#define PAKD	102

#define UPKA	103
#define UPKJ	104
#define UPKL	105
#define UPKX	106
#define UPKD	107

#define LDCA	-128
#define LDDA	-127
#define SBDA	-126
#define MOVS	-125
#define UPCL	-124
#define CMPA	-123

#define LDAV	-96
#define LDD	-95
#define SBD	-94
#define LDA	-93
#define SBA	-92
#define LDV	-91
#define SBV	-90

/* Order here must be same as relational operators
*/
#define LTZJ	-89
#define LEZJ	-88
#define EQZJ	-87
#define NEZJ	-86
#define GEZJ	-85
#define GTZJ	-84

#define JMP	-83
#define JMPF	-82
#define JMPT	-81

#define GOSUB	-80
#define RETSUB	-79

#define ONGO	-78
#define ONGS	-77

#define FCALL	-76
#define FRET	-75

#define BREAK	-74
#define STMTX	-73

#define FXJL	-72
#define FXJX	-71
#define FXLJ	-70
#define FXLX	-69
#define FXXJ	-68
#define FXXL	-67

#define CVLJ	-66
#define CVXJ	-65
#define CVXL	-64

#define PAKSET	-63
#define PAKEND	-62
#define UPKSET	-61
#define MAKDL	-60
#define RFORM	-59

#define PRSET	-58
#define PRCOM	-57
#define PRTAB	-56
#define PRCTL	-55
#define PRCR	-54
#define PREND	-53
#define PRUSET	-52
#define PRUEND	-51

#define INSET	-50
#define INUSET	-49
#define INPRM	-48
#define INCTL	-47
#define INCR	-46
#define INEND	-45
#define TISET	-44
#define TIUSET	-43

#define RDSET	-42
#define RDEND	-41
#define WRSET	-40
#define WREND	-39
#define DATA	-38

#define DEFFN	-37
#define RETFN	-36
#define CALLFN	-35
#define CALLFS	-34

#define CLRSTK	-33
#define DFLTBL	-32

#define ABORT	-31
#define PEND	-30

/* Functions returning numeric results
*/
#define ABSJ	258
#define ABSL	259
#define ABSX	260

#define MAXJ	261
#define MAXL	262
#define MAXX	263

#define MINJ	264
#define MINL	265
#define MINX	266

#define MODJ	267
#define MODL	268
#define MODX	269

#define SGNJ	270
#define SGNL	271
#define SGNX	272

#define SHFJ	273
#define SHFL	274
#define SHFX	275

#define SQRJ	276
#define SQRL	277
#define SQRX	278

#define RNDJ	279
#define RNDL	280
#define RNDX	281

#define VALJ	282
#define VALL	283
#define VALX	284

#define EXPJ	285
#define EXPL	286
#define EXPX	287

#define ANDJ	288
#define ANDL	289

#define ORJ	290
#define ORL	291

#define XORJ	292
#define XORL	293

#define NOTJ	294
#define NOTL	295

#define ASCL	296
#define INTX	297
#define LENJ	298
#define SYSL	299
#define GPOSL	300
#define EOFJ	301
#define POSJ	302

/* Functions returning string results
*/
#define STRJ	384
#define STRL	385
#define STRX	386
#define CHRL	387
#define CRM	388
#define ERM	389
#define FILL	390
#define TRUN	391
#define UCM	392

#define BLKRD	512
#define BLKRDD	513
#define BLKWR	514
#define BLKWRD	515
#define BYE	516
#define CHAIN	517
#define CLOSE	518
#define DEBUG	519
#define DELAY	520
#define DELETE	521
#define DELREC	522
#define DIMA	523
#define DIMJ	524
#define DIML	525
#define DIMX	526
#define GETREC	527
#define KADDL	528
#define KADDS	529
#define KDELL	530
#define KDELS	531
#define KFNDL	532
#define KFNDS	533
#define KNXTL	534
#define KNXTS	535
#define LOCKL	536
#define LOCKS	537
#define LOPNB	538
#define LOPNC	539
#define LRD	540
#define LWR	541
#define NEW	542
#define ONERR	543
#define ONINT	544
#define OPEN	545
#define Pfill1	546
#define PSAVE	547
#define PREPLACE	548
#define RENAME	549
#define RESTOR	550
#define RETERR	551
#define RETINT	552
#define RNDMZ	553
#define RSTFN	554
#define RSTGS	555
#define SBREAK	556
#define SPOS	557
#define START	558
#define STOP	559
#define SWAP	560
#define SYSTEM	561
#define TRACE	562
#define UNLOCK	563

#define STMA1	768
#define STMA2	769
#define STMA3	770
#define STMA4	771
#define STMA5	772
#define STMA6	773
#define STMA7	774
#define STMA8	775
#define STMA9	776
#define STMA10	777
#define STMA11	778
#define STMA12	779
#define STMA13	780
#define STMA14	781
#define STMA15	782
#define STMA19	783
#define STMA20	784
#define STMA21	785

#define STMB0	786
#define STMB1	787
#define STMB2	788
#define STMB3	789
#define STMB4	790
#define STMB5	791
#define STMB10	792
#define STMB11	793
#define STMB21	794
#define STMB22	795
#define STMB24	796

#define STMC0	797
#define STMC1	798
#define STMC5	799
#define STMC6	800
#define STMC7	801
#define STMC8	802
#define STMC9	803
#define STMC11	804
#define STMC17	805
#define STMC21	806
#define STMC22	807
#define STMC23	808
#define STMC24	809
#define STMC25	810
#define STMC28	811
#define STMC29	812
#define STMC34	813
#define STMC35	814
#define STMC36	815
#define STMC39	816
#define STMC40	817
#define STMC41	818
#define STMC42	819
#define STMC43	820
#define STMC44	821
#define STMC45	822
#define STMC46	823
#define STMC47	824
#define STMC52	825

#define XCAL11	826
#define XCAL15	827
#define XCAL16	828

#define STRPOS	829
#define VALUE	830
#define QADD	831
#define QSUB	832
#define QMUL	833
#define QDIV	834
#define QLOAD	835
#define QSTORE	836
#define SWHILE	837
#define SUNTIL	838
#define EXTRACT	839

/* Extracts that need to be moved sometime */
