
#include "stdio.h"

char token[133],opcode[16];
int tokenlen, termch, paren, bytearg, wordarg, const;


main()
{
   do {
   L: gettoken();
      /*
      printf("%-20s %3d 0x%2x %1o %1o %1o %1o\n",
     	 token,tokenlen,termch,bytearg,wordarg,paren,const);
      */
      if (termch==':') {			/* Label */
	 printf("%-1s:\n",token);
	 goto L;
      } else {
	 if (token[0]=='.' || token[0]==';') {	/* Comment/Macro */
	    printf("\t%1s%1c",token,termch);
	    while (!isterm(termch)) {
	       gettoken();
	       printf("%1s%1c",token,termch);
	    }
	 } else {
	    strcpy(opcode,token);
	    printf("\t%1s%1c",opcode,termch);
	    while (!isterm(termch)) {
	       gettoken();
	       printf("%1s%1c",token,termch);
	    }
	 }
      }
   } while (termch != EOF);
}
gettoken()
{
   int c;
   char *tokenptr;

   do  c=getch(); while (iswhite( c ));

   tokenptr = &token[0]; tokenlen = 0;
   paren = bytearg = wordarg = const = 0;

   while (!issep( c )) {
      *tokenptr++ = c;
      c = getch();
      tokenlen++;
   }
   *tokenptr = 0;
   termch = c;
   if (c==EOF) ungetc( c, stdin ); 
}
getch()
{
   int c;
   c = getchar();
   switch( c ) {
   case '#':	wordarg = 1; c = ' ';		break;
   case '*':	bytearg = 1; c = ' ';		break;
   case '.':	const   = 1; 			break;
   case '(':	paren   = 1; c = '[';		break;
   case ')':	paren   = 1; c = ']';		break;
   case '|':	             c = ';';		break;
   default:	             c = toupper( c );	break;
   }
   return( c );
}
toupper( c )
int c;
{
   if ( c>='a' && c<='z' ) {
      return ( c - ('a'-'A'));
   } else {
      return ( c );
   }
}
issep( c )
int c;
{
   return ( c==',' || c==':' || iswhite( c ) || isterm( c ) );
}
iswhite( c )
int c;
{
   return ( c==' ' || c=='\t' );
}
isterm( c )
int c;
{
   return ( c=='\n' || c==EOF );
}
