/*
	write  files given to /dev/tar using common character compression
*/

#include <stdio.h>

#define BUFSIZE 10240
#define TARSIZE 1147900

char	buf1[BUFSIZE],buf2[BUFSIZE*3];
long	fdlth;

main(argc,argv)
int	argc;
char	*argv[];
{
	char	*cp,file[500];
register int	i;
register FILE	*fdo,*fpi;
	FILE	*chktar();
	unsigned n,x;

	cp = argv[0];
	fdlth = TARSIZE;

	if (argc != 1) {
		fprintf(stderr,"%s: Usage - %s <filelist\n",cp,cp);
		exit(-1);
	}

	if ((fdo = fopen("/dev/tar","w")) == NULL) {
		fprintf(stderr,"%s: Can't open /dev/tar\n",cp);
		exit (-1);
	}

	while (gets(file) != NULL) {
		if ((fpi = fopen(file,"r")) == NULL) {
			fprintf(stderr,"%s: Can't open %s\n",cp,file);
			exit (-1);
		}
		x = strlen(file);
		fdo = chktar(fdo,x+sizeof(unsigned)+1);
		fwrite("N",1,1,fdo);			/* Name record */
		fwrite(&x,sizeof(unsigned),1,fdo);	/* length of name */
		fwrite(file,1,x,fdo);			/* write out name */

		while ((x = fread(buf1,1,BUFSIZE,fpi)) != 0) {
			n = cmprs(buf1,x,buf2);		/* compress it */
			/* check for room */
			fdo = chktar(fdo,n+sizeof(unsigned)+1);
			fwrite("D",1,1,fdo);		/* write out data rec */
			fwrite(&n,sizeof(unsigned),1,fdo);
			fwrite(buf2,1,n,fdo);
		}
		fdo = chktar(fdo,1);
		fwrite("F",1,1,fdo);
		fclose(fpi);
		printf("%s\n",file);
	}
	fdo = chktar(fdo,1);
	fwrite("E",1,1,fdo);
	fclose(fdo);
	exit(0);
}

FILE *chktar(fd,length)
FILE	*fd;
unsigned length;
{
	char	buf[10];
	int	fdt;

	fdlth -= length;

	if (fdlth <= 1) {
		fwrite("Z",1,1,fd);
		fdlth = TARSIZE;
		fclose(fd);
		fdt = open("/dev/tty",0);
		fprintf(stderr,"Mount next disk - press newline to continue");
		read(fdt,buf,1);
		close(fdt);
		return(fopen("/dev/tar","w"));
	}
	return(fd);
}
