#include "stdio.h"
#include "a.out.h"
#include "exe.h"

char hexdigits[] = "0123456789ABCDEF";
struct exec exec;

main(argc,argv)
int argc;
char **argv;
{
   char **arg;
   char *inname;

   inname = "a.out";
   for (arg = argv + 1; *arg != 0; arg++) {
      if (**arg != '-') inname = *arg;
   }
   if (makeout(inname) != 0)
      perror("xcom");
}

makeout(inname)
char *inname;
{
   int inchan;

   if ((inchan = open(inname,0)) == -1) return(-1);
   if (read(inchan,&exec,sizeof exec) <= 0) return(-1);
   if (exec.a_flag != 1) {
      fprintf(stderr,"xcom: Not a valid program file");
      return(-2);
   }
   switch (exec.a_magic) {
      case A_MAGIC1:
	 printf("Converting %s to .COM format\n",inname);
	 return (makecom(inchan));
      case A_MAGIC3:
	 printf("Converting %s to .EXE format\n",inname);
	 return (makeexe(inchan));
      default:
	 return (-2);
   }
}

makecom(inchan)
int inchan;
{
   int n;
   char buffer[512], *p;
   unsigned adr, size;

   size = exec.a_text + exec.a_data - 0x100;
   lseek(inchan,(long) 0x100,1);
   absbeg();
   for (adr = 0; size > 0;) {
      if (read(inchan,p = buffer,sizeof buffer) <= 0) return(-1);
      for (n = sizeof buffer; n > 0; n--)
	 if (size-- > 0) absout(adr++,*p++);
	 else break;
   }
   if (exec.a_bss != 0) {
      absout(adr+exec.a_bss-1,0);
   }
   absdump();
   return(0);
}

makeexe(inchan)
int inchan;
{
#define stksize 0x0100

   long size;
   struct exehead exehead;
   int n;
   char buffer[512], *p;
   unsigned adr;

   size = (long) exec.a_text + (long) exec.a_data;
   exehead.e_magic = 0x5a4d;
   exehead.e_last = (size + stksize) & 0xff;
   exehead.e_size = (size + stksize + 511)/512 + 1;
   exehead.e_nrel = 0;
   exehead.e_hsize = 512/16;
   exehead.e_min = 0;
   exehead.e_max = -1;
   exehead.e_stkseg = (exec.a_text+15)/16;
   exehead.e_stack = exec.a_data + stksize;
   exehead.e_check = 0;
   exehead.e_code = 0;
   exehead.e_codseg = 0;
   exehead.e_reloff = 512/16;
   exehead.e_ovlnum = 0;
   absbeg();
   for (adr = 0, p = (char *) &exehead; adr <= sizeof exehead;)
      absout(adr++,*p++);
   for (adr = 512; size > 0;) {
      if (read(inchan,p = buffer,sizeof buffer) <= 0) return(-1);
      for (n = sizeof buffer; n > 0; n--)
	 if (size-- > 0) absout(adr++,*p++);
	 else break;
   }
   absout(adr + stksize - 1,0);
   absdump();
   return(0);
}

unsigned absadr;
char absbuf[32];
int abslen;

absbeg()
{
   absadr = 0;
   abslen = 0;
}

absout(adr,j)
unsigned adr;
int j;
{
   if (abslen == 32 || adr != absadr+abslen) absdump();
   if (abslen == 0) absadr = adr;
   absbuf[abslen++] = j;
}

absdump()
{
   char *p;
   int cksum;

   if (abslen == 0) return;
   putchar(1);
   puthex(absadr>>8); puthex(absadr);
   puthex(abslen);
   for (p = absbuf, cksum = 0; abslen > 0; p++, abslen--) {
      puthex(*p);
      cksum += (*p) & 0xFF;
   }
   puthex(-cksum);
   putchar('\n');
}

puthex(h)
int h;
{
   putchar(hexdigits[(h>>4)&0xF]);
   putchar(hexdigits[h&0xF]);
}
