/*************************************************************************
*
*
*	Name:  sform.h
*
*	Description:  SForm routines include file.
*
*
*	History:
*	Date		By		Comments
*
*	03/01/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  This file should be included with any pgm that uses the 'sform'
	(screen format and i/o) package.
	  The object library 'sform.o' should be bound in with the user's pgm.

*/


/* Define environment */
#define		SF_ALTOS	1		/* Altos system (with DG terminal) */
#define		SF_PC		0		/* IBM PC (with BIOS interface) */



/************************/
/*    Constants         */
/************************/


/** Completion codes **/

/* One of the codes below will be returned to the user after completion
   of the sfwinio() or sffldio() call. */

/* System completion codes.
   These codes are used primarily internally, but could be returned
   to the user by some fn's in some situations. */
#define		SF_OK		0		/* No Problem							*/
#define		SF_ERROR	(-1)	/* General error indicator				*/
#define		SF_EDPROT	(-2)	/* Tried to edit a protected field		*/
#define		SF_RETRY	(-3)	/* Request by low level fn to try again */

/* User Errors.
   These codes define various error codes which could be returned by calls
   to the sform modules. Note that all error codes are < 0. */
/* General */
#define		SF_EWOPN	(-100)	/* Error while trying to open window.	*/
#define		SF_EWCLS	(-101)	/* Error while trying to close window.	*/
#define		SF_EBADW	(-102)	/* Bad window desc paramaters.			*/
#define		SF_EBADF	(-103)	/* Bad field desc parameters.			*/

/* Standard SForm function codes.
   Note that the 'standard' sform fn key characters are defined in the
   'fnkeys.c' module, but can be re-defined by the user.
   Codes marked with a '*' can be returned by the sform routines.
   NOTE - The sequence defined below must not be altered.
		  It is used to logically group the functions.	*/
#define		SF_NXTFLD	260		/** Next Field			*/
#define		SF_PRVFLD	261		/** Previous Field		*/
#define		SF_NXTGRP	262		/*  Next Group			*/
#define		SF_PRVGRP	263		/*  Previous Group		*/
#define		SF_NXTWIN	270		/** Next Window			*/
#define		SF_PRVWIN	271		/** Previous Window		*/
#define		SF_NXTENM	280		/*  Next enumerator		*/
#define		SF_PRVENM	281		/*  Previous enumerator	*/
#define		SF_CLRFLD	290		/*  Clear/delete field	*/
#define		SF_FLDFMT	294		/*  Show field format	*/
#define		SF_CLRERR	299		/*  Clear error			*/
#define		SF_ABORT	300		/** Abort				*/
#define		SF_FINISH	301		/** Exit the updated window */
#define		SF_HELP		320		/*  User help routine	*/
#define		SF_RSTWIN	330		/** Reset all fields	*/

/* Function key codes.
   If the user hits a keyboard function key, and that key is not
   defined (in fnkeys.h) to represent an sform function, one of 
   the codes below is returned to the user pgm. */
#define		SF_F1		400		/* Fn Key # 1			*/
#define		SF_F2		401		/* Fn Key # 2			*/
#define		SF_F3		402		/* Fn Key # 3			*/
#define		SF_F4		403		/* Fn Key # 4			*/
#define		SF_F5		404		/* Fn Key # 5			*/
#define		SF_F6		405		/* Fn Key # 6			*/
#define		SF_F7		406		/* Fn Key # 7			*/
#define		SF_F8		407		/* Fn Key # 8			*/
#define		SF_F9		408		/* Fn Key # 9			*/
#define		SF_F10		409		/* Fn Key # 10			*/
#define		SF_F11		410		/* Fn Key # 11			*/
#define		SF_SF1		420		/* Shifted Fn Key # 1	*/
#define		SF_SF2		421		/* Shifted Fn Key # 2	*/
#define		SF_SF3		422		/* Shifted Fn Key # 3	*/
#define		SF_SF4		423		/* Shifted Fn Key # 4	*/
#define		SF_SF5		424		/* Shifted Fn Key # 5	*/
#define		SF_SF6		425		/* Shifted Fn Key # 6	*/
#define		SF_SF7		426		/* Shifted Fn Key # 7	*/
#define		SF_SF8		427		/* Shifted Fn Key # 8	*/
#define		SF_SF9		428		/* Shifted Fn Key # 9	*/
#define		SF_SF10		429		/* Shifted Fn Key # 10	*/
#define		SF_SF11		430		/* Shifted Fn Key # 11	*/

/* End of completion codes */


/* Window I/O entry modes.
   One of these codes is included in every sfwinio() or sffldio()
   call to define the action to be taken. */
#define		SF_DISPLAY	0		/* Display fields				*/
#define		SF_INPUT	1		/* Input fields					*/
#define		SF_EDIT		2		/* Display and Input fields		*/
#define		SF_LABELS	3		/* Display label fields only	*/


/* Screen size parameters.
   Note that rows & cols are 0 based.
   Note that bottom row is normally reserved for error messages. */
#define	SF_MAXCOL	79			/* Largest legal col # */
#if	SF_ALTOS
#define	SF_ERRROW	23			/* Error msg row (last line) */
#define	SF_MAXROW	SF_ERRROW	/* Largest legal row # */
#endif
#if SF_PC
#define	SF_ERRROW	24			/* Error msg row (25th line) */
#define	SF_MAXROW	SF_ERRROW	/* Largest legal row # */
#endif


/* Define the field format characters.
   This character will be displayed in the field when the 'Show format'
   function is selected. */
#define	SF_FALPHA	$	/* alpha / alpha-numeric / string	*/
#define	SF_FINT		I	/* integer field					*/
#define	SF_FLONG	L	/* long integer field				*/
#define	SF_FENUM	E	/* enumerator field					*/



/***************************************************************************/
/* Define (temporarily (???)) display characteristic word values */
#define		SF_INATROS	SF_ATREV	/* Default offset for input display.
			This value is used to highlight the current input field */
#define		SF_ATNORM	1		/* 'Normal' display characteristics */
#define		SF_ATDIM	(1<<1)	/* Intensity:	1 = Dim / 0 = Normal */
#define		SF_ATBLNK	(1<<2)	/* Blinking:	1 = Blink */
#define		SF_ATUNDLN	(1<<3)	/* Underline: 	1 = Underline */
#define		SF_ATREV	(1<<7)	/* Reverse video */
/***************************************************************************/

/************************/
/*    Structures        */
/************************/



/**  I/O Data descriptors.

   These structures include all the information necessary for the display
   and editing of a field of each type. Each descriptor includes the address
   of a dedicated 'sf_tfldio' function. There is a tight correspondence
   between the 'sf_tfldio' function and the i/o data descriptor structure
   used by that function. There must be a data descriptor for each distinct
   'type' of data field. The data 'type' is implicitly defined by the 
   sf_fldio function and the data descriptor structure used by the field.

   The data descriptors defined below are considered to be the 'system standard'
   descriptors. These descriptors correspond to the sf_fldio
   functions which are supplied to handle the 'standard' data types. If the
   user defines his/her own field type, s/he must define a new data descriptor
   and a new sf_tfldio function for that field.


   NOTE - ALL data descriptors must have the following format -		*/

	struct SF_IODATA {
		int		(*sf_fldfn)() ;		/* field i/o function ptr */
		unsigned sf_datr ;			/* field display attribute word */
		unsigned sf_flags ;			/* bit flags */
		/** type specific data goes here **/
		} ;

/* the sform functions will assume that the first fields of any data
   descriptor will follow the above template. Fields specific to the
   given data type can follow these defined fields.
*/

/* Bit mask definitions.
   These mask values are used by the standard data descriptors.
   Masks are used instead of 'c' bit-fields, as some versions of 'c' may not
   support bit-fields.
   The comments describe the meaning when the bit is set or reset.
*/

/* numeric */
#define	SF_UNSGN	1		/* 0 = signed numeric field.
							   1 = unsigned numeric field. */
#define	SF_ZFILL	(1<<1)	/* 1 = zero fill numeric field display. */

/* string */
#define	SF_ALPHA	(1<<2)	/* 1 = only alphabetic chars allowed. */
#define	SF_NUM		(1<<3)	/* 1 = only numeric chars allowed. */
#define	SF_ANUM	(SF_ALPHA | SF_NUM)	/* 1 = only alpha-numeric chars allowed. */
#define	SF_SPCHR	(1<<4)	/* 1 = Special (user defined) character set.
								   sf_spchr is ptr to null term'ed char list. */
/* Note - Control chars are never legal data chars.
		  Non-alphanumeric chars allowed only if ANUM = 0. */
#define	SF_UCASE	(1<<5)	/* 1 = upper case input only.
							   0 = lower case input allowed. */
#define	SF_BFILL	(1<<6)	/* 1 = blank fill return string data.
							   0 = null fill return string data. */

/* general */
#define	SF_PROTFLD	(1<<7)	/* 1 = protected field (display only) */
#define	SF_LABFLD	(1<<8)	/* 1 = label (string literal) field */
#define	SF_NOECHO	(1<<9)	/* 1 = don't echo input. */
#define	SF_AUTOUNP	(1<<10)	/* 1 = auto unpend when full field input. */
#define	SF_RJUST	(1<<11)	/* 1 = right justify field display. */
#define	SF_LJUST	(1<<12)	/* 1 = left justify field display. */
#define	SF_CJUST	(1<<13)	/* 1 = center justify field display. */

/* Short Integer data descriptor.
   This i/o desc is used for 2 byte (1 'word') integer data.
*/

struct SF_IFDATA {		/* integer field data */

	int		(*sf_ifldio)() ;	/* function for integer i/o */
	unsigned sf_idatr ;			/* display attribute word */
	unsigned sf_iflags ;		/* numeric flags */
	unsigned sf_iradix ;		/* numeric base.
								   Default = 10 (decimal) */
	short	sf_ilbnd, sf_iubnd; /* range */
	} ;



/* Long Integer data descriptor.
   This i/o desc is used for 4 byte (2 'word') integer data.
*/

struct SF_LFDATA {		/* long integer field data */

	int		(*sf_lfldio)() ;	/* function for long integer i/o */
	unsigned sf_ldatr ;			/* display attribute word */
	unsigned sf_lflags ;		/* flags */
	unsigned sf_lradix ;		/* numeric base.
								   Default = 10 (decimal) */
	long	sf_llbnd, sf_lubnd ; /* range */
	} ;



/* String data descriptor.
   This i/o desc is used for string data.
*/

struct SF_SFDATA {		/* string field data */

	int		(*sf_sfldio)() ;	/* function for string i/o */
	unsigned sf_sdatr ;			/* display attribute word */
	unsigned sf_sflags ;		/* flags */
	} ;



/* Literal data descriptor.
   This i/o desc is used for 'literal' fields.
   These fields are used for labels, prompts, headings, borders, etc.
*/

struct	SF_LBFDATA {	/* label (string literal) field data */

	int		(*sf_slfldio)() ;	/* function for label display */
	unsigned sf_sldatr ;		/* display attribute word */
	unsigned sf_slflags ;		/* flags */
	} ;


/* Enumeration data descriptor.
   This i/o desc is used for 'enumeration' type integer data.
   The enumeration string is defined as per 'c' conventions,
   including initializers.
*/

struct	SF_EFDATA {		/* enumeration field data */

	int		(*sf_efldio)() ;	/* function for enumeration i/o */
	unsigned sf_edatr ;		/* display attribute word */
	unsigned sf_eflags ;		/* flags */
	char	*sf_enmstr ;		/* enumerator string */
	} ;

/** Binary Data descriptor.

   This structure is currently used as a template for the binary data
   storage. It could be used as a data descriptor.
*/

union	SF_BINDATA {

	char	sf_cdata ;		/* char */
	short	sf_idata ;		/* int */
	long	sf_ldata ;		/* long */
	float	sf_fdata ;		/* float */
	double	sf_ddata ;		/* double */
	char	sf_sdata[1] ;	/* string (template) */

	} ;

/** Field descriptor.

   This structure defines a field, where a field is a single display item.
   One of these structures must be composed for each unique field within a
   window.
*/

struct	SF_FIELD {

	int		sf_row, sf_col; /* Absolute Row & Col numbers on the screen */
	int		sf_width ;		/* width of field (# chars) */
	struct SF_IODATA *sf_iodata ;
							/* This structure defines the type of the data
							   in the field, and contains information for
							   displaying and inputing the field and the
							   address of the function which handles display
							   and input. */
	union SF_BINDATA *sf_bindata ;
							/* fld_io() uses the information in this structure
							   to find the current data and to store the new
							   data.  This is normally the address of the binary
							   data, but could be the address of a data
							   descriptor. */

	} ;


/** Group link entry.

	  The 'group link list' is composed of SF_GRPLINK entries. It is used to
	define 'groups' of fields within a given window. Each entry contains
	links (field #'s) to the previous group and the next group correspond-
	ing to a given field. There is an entry in the group link list
	coresponding to each entry in the Field List.
	  A link entry of (-1) denotes the end of the list (e.g. first and
	last fields in the window).
	  NOTE that the links are field numbers, not addresses.

	  The grouping information is used to make selection of fields more
	efficient.
*/

struct	SF_GRPLINK {

	int		sf_prvgrp ;		/* field # of first field in previous group */
	int		sf_nxtgrp ;		/* field # of first field in next group */
	} ;


/** Window descriptor.

   This structure defines a 'window', which is a section of the crt
   screen space. The window can be, and often will be, the entire
   screen space. A window contains one or more 'fields', which are
   fully defined by a SF_FIELD structure.
*/


struct	SF_WINDOW {

	int	sf_urow, sf_lrow ;	/* The starting and ending (upper & lower) rows
							   for this window. Rows are numbered starting
							   at '0'. */
	int	sf_lcol, sf_rcol ;	/* The starting and ending (left & right) columns
							   for this window. Cols are numbered starting
							   at '0'. */
	unsigned sf_wdatr ;		/* Display attribute word for this window.
							   This allows 'painting' of the window. */
	struct SF_GRPLINK (*sf_grplist)[] ;
							/* A ptr to an array of group links.
							   This optional array is used to define 
							   'groups'. There is an entry in this array
							   corresponding to each entry in the
							   sf_fldlist array, with links to the 'next
							   group' and 'previous group'. If field
							   grouping will not be defined, use SF_NULL */
	struct SF_FIELD (*sf_fldlist)[] ;
							/* Field desc array address.
							   There is a field desc structure in this list
							   for each field in the window.
							   NOTE that a 'sf_nullfld' field desc structure
							   MUST terminate the list.
							   This entry must be a ptr to allow initializers
							   to dynamically define the array length. */

	} ;

/********************************/
/*	System Macros & Globals		*/
/********************************/


/* Define a 'null' ptr.
   This macro can be used to define 'no group link list', etc. */
#define		SF_NULL		0	/* Null ptr */


/* End of field.
   This macro must be used to terminate the field desc list in each
   window desc. It defines the data in a 'Null Field'. */
#define	SF_ENDFLD \
	{ -1, -1, -1, SF_NULL, SF_NULL }


/* Cast macros.
   These macros can be used to 'cast' various entries in the window
   data definition module. */
/* Field List cast. Used to define the field list ptr in the window desc. */
#define	SF_FLPCAST	(struct SF_FIELD (*)[])
/* Group List cast. Used to define the group list ptr in the window desc. */
#define	SF_GLPCAST	(struct SF_GRPLINK (*)[])
/* IO Data struct ptr. Defines the SF_IODATA ptr in the fld desc list */
#define	SF_IDPCAST	(struct SF_IODATA *)
/* Binary Data struct ptr. Defines the SF_BINDATA ptr in the fld desc list */
#define	SF_BDPCAST	(struct SF_BINDATA *)


/* Declare 'standard' i/o functions.
   These fn's implement i/o for the 'basic' data types.
   The user must provide his/her own routines to support 'extended' types. */
extern	sfintio() ;		/* Integer (2 byte) i/o		*/
extern	sfstrio() ;		/* String i/o				*/
extern	sfenmio() ;		/* Enumerator i/o			*/
extern	sflabio() ;		/* Label (prompt) i/o		*/


/** Global user variables **/
extern	unsigned sf_inatros ;	/* Input display attribute offset	*/
