		/**  OPUS Screen Definition   **/

/*
06/01/84	waf		Comment out 'Vol Serial' fld in xfer parms window.


To Do -
*/

#include	"/sform/sform.h"
#include	"/sform/csmmacs.h"
#include	"DEFINES.H"
#include	"EXTERN.H"
#include	"menu.h"



/* Define graphics chars */
#if	SF_PC
#define		HBAR	'\315'	/* horizontal bar		*/
#define		VBAR	'\272'	/* vertical bar			*/
#define		LTEE	'\271'	/* left (pointing) tee	*/
#define		RTEE	'\314'	/* right (pointing) tee	*/
#define		DTEE	'\313'	/* down (pointing) tee	*/
#define		UTEE	'\312'	/* up (pointing) tee	*/
#define		CROSS	'\316'	/* crossing lines		*/
#define		URCRNR	'\273'	/* upper right corner	*/
#define		LRCRNR	'\274'	/* lower right corner	*/
#define		ULCRNR	'\311'	/* upper left corner	*/
#define		LLCRNR	'\310'	/* lower left corner	*/
#endif
#if	SF_ALTOS
#define		HBAR	'-'	/* horizontal bar		*/
#define		VBAR	'|'	/* vertical bar			*/
#define		LTEE	'|'	/* left (pointing) tee	*/
#define		RTEE	'|'	/* right (pointing) tee	*/
#define		DTEE	'-'	/* down (pointing) tee	*/
#define		UTEE	'-'	/* up (pointing) tee	*/
#define		CROSS	'-'	/* crossing lines		*/
#define		URCRNR	'-'	/* upper right corner	*/
#define		LRCRNR	'-'	/* lower right corner	*/
#define		ULCRNR	'-'	/* upper left corner	*/
#define		LLCRNR	'-'	/* lower left corner	*/
#endif

/*********************
**	Screen Data		**
*********************/


/** Screen local data **/

static	char	dashes[]	= {
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR
	} ;							/* Dashed line			*/

static	char	vbar[]		= {
	VBAR
	} ;							/* Vertical bar			*/

static	char	dtee[]		= {
	DTEE
	} ;							/* (Down pointing) tee	*/

/* Fn keys */
static	char	fkbtop[]	= {
	ULCRNR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	DTEE,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	URCRNR
	} ;			/* top line */
static	char	fkbsep[]	= {
	RTEE,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	CROSS,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	LTEE
	} ;			/* separator */
static	char	fkbdata[]	= {
	VBAR,
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	VBAR,
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	VBAR
	} ;			/* data line */
static	char	fkbbot[]	= {
	LLCRNR,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	UTEE,
	HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,HBAR,
	LRCRNR
	} ;			/* bottom line */


/* Other locals */
char	dummystr[]	= "****" ;		/* dummy header */

/*************************
**	Field Descriptors	**
*************************/


/* Underlined header */
static	struct SF_LBFDATA	uhdrfd	= {
	sflabio,		/* i/o fn		*/
	(SF_ATDIM | SF_ATUNDLN), /* display attr */
	(SF_LABFLD | SF_CJUST)	/* flags */
	} ;

/* Non-Underlined header */
static	struct SF_LBFDATA	hdrfd	= {
	sflabio,		/* i/o fn		*/
	SF_ATDIM, 		/* display attr */
	(SF_LABFLD | SF_CJUST)	/* flags */
	} ;

/* Label field desc */
static	struct SF_LBFDATA	lblfd	= {
	sflabio,		/* i/o fn		*/
	SF_ATDIM,		/* display attr	*/
	(SF_LABFLD | SF_RJUST)	/* flags */
	} ;

/* String data field desc */
static	struct SF_SFDATA	strfd	= {
	sfstrio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE)	/* flags */
		/* NOTE - MUST be null filled */
	} ;

/* Int data field desc */
static	struct SF_IFDATA	intfd	= {
	sfintio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	SF_LJUST,		/* flags		*/
	10,				/* radix		*/
	-32768,32767	/* range		*/
	} ;

/* Unsigned data field desc */
static	struct SF_IFDATA	unsfd	= {
	sfintio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UNSGN),	/* flags */
	10,				/* radix		*/
	0,65535			/* range		*/
	} ;

/* Enum data field descs */
/* Yes / No */
static	struct SF_EFDATA	ynfd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags		*/
	"NO,YES"		/* enum string	*/
	} ;
/* Xfer mode */
static	struct SF_EFDATA	xmefd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	SF_LJUST,		/* flags		*/
	"TEXT,BINARY"	/* enum string	*/
	} ;
/* U/L case */
static	struct SF_EFDATA	ulefd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags		*/
	"CAPS,ASIS"		/* enum string	*/
	} ;
/* Space units */
static	struct SF_EFDATA	suefd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags		*/
	"TRKS,BLKS,CYLS" /* enum string	*/
	} ;
/* Record format - 1st enum */
static	struct SF_EFDATA	rf1efd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags */
	"FIXED,VARIABLE" /* enum string	*/
	} ;
/* Record format - 2nd enum */
static	struct SF_EFDATA	rf2efd	= {
	sfenmio,		/* i/o fn		*/
	SF_ATNORM,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags */
	"BLOCKED,UNBLKED"		/* enum string	*/
	} ;

/* Fn key data */
struct SF_SFDATA	fkdfd	= {
	sfstrio,		/* i/o fn		*/
	SF_ATREV,		/* display attr */
	(SF_LJUST | SF_UCASE),	/* flags */
	} ;

/*************************
**	Field Desc Lists	**
*************************/


/** Menu window 'frame' **/
/* This window clears the screen & defines headers and borders */
struct SF_FIELD	hdrflst[]	= {

/* Header line 1 */
FLENT(0,0,NCOL,&hdrfd,dummystr),

/* Header line 2 */
FLENT(1,0,NCOL,&hdrfd,dummystr),

/* Horizontal line between headers & filenames */
FLENT(WFDSH1,0,NCOL,&lblfd,dashes),

/* Horizontal line between filenames & bottom */
FLENT(WFDSH2,0,NCOL,&lblfd,dashes),

/** Fn Keys window **/
/* header */
FLENT(12,0,FKBSIZ,&hdrfd,"Function Keys"),
/* top of box */
FLENT(13,0,FKBSIZ,&lblfd,fkbtop),
/* 1 & 2 */
/* boxes */
FLENT(14,0,FKBSIZ,&lblfd,fkbdata),
/* numbers */
FLENT(14,FKNL1,FKLSIZ,&lblfd,"1 "),
FLENT(14,FKNL2,FKLSIZ,&lblfd,"2 "),
/* sep line */
FLENT(15,0,FKBSIZ,&lblfd,fkbsep),
/* 3 & 4 */
/* boxes */
FLENT(16,0,FKBSIZ,&lblfd,fkbdata),
/* numbers */
FLENT(16,FKNL1,FKLSIZ,&lblfd,"3 "),
FLENT(16,FKNL2,FKLSIZ,&lblfd,"4 "),
/* sep line */
FLENT(17,0,FKBSIZ,&lblfd,fkbsep),
/* 5 & 6 */
/* boxes */
FLENT(18,0,FKBSIZ,&lblfd,fkbdata),
/* numbers */
FLENT(18,FKNL1,FKLSIZ,&lblfd,"5 "),
FLENT(18,FKNL2,FKLSIZ,&lblfd,"6 "),
/* sep line */
FLENT(19,0,FKBSIZ,&lblfd,fkbsep),
/* 7 & 8 */
/* boxes */
FLENT(20,0,FKBSIZ,&lblfd,fkbdata),
/* numbers */
FLENT(20,FKNL1,FKLSIZ,&lblfd,"7 "),
FLENT(20,FKNL2,FKLSIZ,&lblfd,"8 "),
/* sep line */
FLENT(21,0,FKBSIZ,&lblfd,fkbsep),
/* 9 & 10 */
/* boxes */
FLENT(22,0,FKBSIZ,&lblfd,fkbdata),
/* numbers */
FLENT(22,FKNL1,FKLSIZ,&lblfd,"9 "),
FLENT(22,FKNL2,FKLSIZ,&lblfd,"0 "),
/* bottom */
FLENT(23,0,FKBSIZ,&lblfd,fkbbot),

/* Vertical line between fnkeys & xfer parms */
FLENT(WFDSH2,WFHFX,1,&lblfd,dtee),
FLENT(WFDSH2+1,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+2,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+3,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+4,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+5,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+6,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+7,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+8,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+9,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+10,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+11,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+12,WFHFX,1,&lblfd,vbar),
FLENT(WFDSH2+13,WFHFX,1,&lblfd,vbar),

	SF_ENDFLD
	} ;


/** Filename window **/
struct SF_FIELD	fnamflst[]	= {

/* PC filename label */
FLENT(FNSROW,0,15,&lblfd,"PC filename:"),
/* PC filename data */
FLENT(FNSROW,16,PCFNSIZ,&strfd,dummystr),

	SF_ENDFLD
	} ;


/** Data set name window **/
struct SF_FIELD dnamflst[]	= {

/* Data set label */
FLENT(FNSROW+2,0,15,&lblfd,"Data set name:"),
/* Data set data */
FLENT(FNSROW+2,16,DSNSIZ,&strfd,dummystr),

	SF_ENDFLD
	} ;


/** Transfer type window **/
struct SF_FIELD	xftflst[]	= {

/* label */
FLENT(FNSROW+4,0,15,&lblfd,"Transfer type:"),
/* data */
FLENT(FNSROW+4,16,XFTSIZ,&strfd,xftbuf),

	SF_ENDFLD
	} ;


/** Record Cnt window **/
struct SF_FIELD	rcntflst[]	= {

/* label */
FLENT(FNSROW+4,55,NCOL-55,&lblfd," "),
/* data */
FLENT(FNSROW+4,70,8,&unsfd,&reccnt),

	SF_ENDFLD
	} ;


/** Fn key labels window **/
struct SF_FIELD fnkflst[]	= {

FLENT(14,FKD1,FKDSIZ,&fkdfd,fkdata[1]),
FLENT(14,FKD2,FKDSIZ,&fkdfd,fkdata[2]),
FLENT(16,FKD1,FKDSIZ,&fkdfd,fkdata[3]),
FLENT(16,FKD2,FKDSIZ,&fkdfd,fkdata[4]),
FLENT(18,FKD1,FKDSIZ,&fkdfd,fkdata[5]),
FLENT(18,FKD2,FKDSIZ,&fkdfd,fkdata[6]),
FLENT(20,FKD1,FKDSIZ,&fkdfd,fkdata[7]),
FLENT(20,FKD2,FKDSIZ,&fkdfd,fkdata[8]),
FLENT(22,FKD1,FKDSIZ,&fkdfd,fkdata[9]),
FLENT(22,FKD2,FKDSIZ,&fkdfd,fkdata[10]),

	SF_ENDFLD
	} ;


/** Transfer params window **/
struct SF_FIELD	xfpflst[]	= {

/* header */
FLENT(11,TP1LBL,(SF_MAXCOL-TP1LBL),&hdrfd,"Transfer Parameters"),

	/* Col 1 */
/* Block size */
/* label */
FLENT(12,TP1LBL,TP1LSIZ,&lblfd,"Block size:"),
/* data */
FLENT(12,TP1DATA, 5,&unsfd,&x_blk_size),

/* Record size */
/* label */
FLENT(13,TP1LBL,TP1LSIZ,&lblfd,"Record size:"),
/* data */
FLENT(13,TP1DATA,5,&unsfd,&x_rec_size),

/* Record format */
/* label */
FLENT(14,TP1LBL,TP1LSIZ,&lblfd,"Record format:"),
/* data 1 */
FLENT(14,TP1DATA,8,&rf1efd,&recfmt1),
/* data 2 */
FLENT(15,TP1DATA,8,&rf2efd,&recfmt2),

/* Line numbers */
/* header */
FLENT(17,TP1LBL,TP1LSIZ,&lblfd,"Line numbers -"),
/* Pos label */
FLENT(18,TP1LBL,TP1LSIZ,&lblfd,"Position:"),
/* Pos data */
FLENT(18,TP1DATA,5,&unsfd,&x_num_pos),
/* Len label */
FLENT(19,TP1LBL,TP1LSIZ,&lblfd,"Length:"),
/* Len data */
FLENT(19,TP1DATA,1,&unsfd,&x_num_len),

/* Code table */
/* label */
FLENT(21,TP1LBL,TP1LSIZ,&lblfd,"Code table:"),
/* data */
FLENT(21,TP1DATA,8,&strfd,x_code_name),

	/* Col 2 */
/* Transfer mode */
/* label */
FLENT(12,TP2LBL,TP2LSIZ,&lblfd,"Transfer mode:"),
/* data */
FLENT(12,TP2DATA,6,&xmefd,&x_xfer_mode),

/* Expand Tabs */
/* label */
FLENT(13,TP2LBL,TP2LSIZ,&lblfd,"Expands TABs:"),
/* data */
FLENT(13,TP2DATA,3,&ynfd,&x_exp_tabs),

/* Truncate spaces */
/* label */
FLENT(14,TP2LBL,TP2LSIZ,&lblfd,"Truncate spaces:"),
/* data */
FLENT(14,TP2DATA,3,&ynfd,&x_trunc_spaces),

/* U/L case */
/* label */
FLENT(15,TP2LBL,TP2LSIZ,&lblfd,"U/L case:"),
/* data */
FLENT(15,TP2DATA,4,&ulefd,&x_ul_case),

/* Vol serial */
/* label */
/* FLENT(17,TP2LBL,TP2LSIZ,&lblfd,"Volume serial:"), */
/* data */
/* FLENT(17,TP2DATA,6,&strfd,x_vol_ser), */

/* Space Units */
/* label */
FLENT(18,TP2LBL,TP2LSIZ,&lblfd,"Space Units:"),
/* data */
FLENT(18,TP2DATA,4,&suefd,&x_space_unit),

/* Primary Qty */
/* label */
FLENT(19,TP2LBL,TP2LSIZ,&lblfd,"Primary qty:"),
/* data */
FLENT(19,TP2DATA,4,&unsfd,&x_pri_quan),

/* Secondary Qty */
/* label */
FLENT(20,TP2LBL,TP2LSIZ,&lblfd,"Secondary qty:"),
/* data */
FLENT(20,TP2DATA,4,&unsfd,&x_sec_quan),

/* Dir blks */
/* label */
FLENT(21,TP2LBL,TP2LSIZ,&lblfd,"Directory blocks:"),
/* data */
FLENT(21,TP2DATA,4,&unsfd,&x_dir_blks),

	SF_ENDFLD
	} ;

/*********************
**	Define Groups	**
*********************/

/*********************
**	Define Windows	**
*********************/


/* MAIN window.
   This window is used to clear the screen and show the window frame.
*/
struct SF_WINDOW	mainwin = {
	0,SF_MAXROW,0,SF_MAXCOL,		/* window size = whole screen */
	SF_ATNORM,						/* display attr */
	(struct SF_GRPLINK (*)[]) 0,	/* grouping info */
	(struct SF_FIELD (*)[]) hdrflst		/* fld desc list */
	} ;


/* Name windows.
   This window contains the filename and data set name.
*/
/* Filename */
struct SF_WINDOW	fnamwin	= {
	FNSROW,FNSROW,0,SF_MAXCOL,
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST fnamflst 
	} ;
/* Data set name */
struct SF_WINDOW	dnamwin	= {
	FNSROW+2,FNSROW+2,0,SF_MAXCOL,
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST dnamflst 
	} ;


/* XFER TYPE window.
   This window contains the Transfer Type information.
*/
struct SF_WINDOW	xftwin = {
	FNSROW+4,FNSROW+4,0,26,		/* window size */
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST xftflst
	} ;


/* RCNT window.
   This window contains the Record Count display.
*/
struct SF_WINDOW	rcntwin = {
	FNSROW+4,FNSROW+4,55,SF_MAXCOL,		/* window size */
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST rcntflst
	} ;


/* FNKEY window.
   This window contains the function key labels.
*/
struct SF_WINDOW	fnkeywin = {
	9,22,0,22,		/* window size */
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST fnkflst
	} ;


/* XFER PARAMS window.
   This window displays the transfer parameters.
*/
struct SF_WINDOW	xfpwin = {
	WFDSH2+1,22,TP1LBL,SF_MAXCOL,
	SF_ATNORM,
	SF_GLPCAST 0,
	SF_FLPCAST xfpflst
	} ;
