/*************************************************************************
*
*
*	Name:  pdump.c
*
*	Description:  Dump a p-code file.
*
*
*	History:
*	Date		By		Comments
*
*				mas
*	11/22/83	waf		Dump header + p-code + tables.
*	12/08/83	waf		Allow starting & ending tpc args.
*	03/06/84	waf		Fix chksum computation (include last word).
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983 by Technical Analysis Corporation.
*
*************************************************************************




/*  Notes -

  The file argument must be the full filename (e.g. no default extensions).
  This pgm can not handle pgm libraries.

  **> The pcstr() fn is NOT completed. Add code as unimplemented instr's are
		found.

12/8/83		waf
  If a starting tpc arg is given in the command line, the header display is
skipped, and opcodes are dumped starting at that tpc. An optional ending tpc
arg can be included in the cmd line.

*/


#include	"/bb/include/ptype.h"
#include	"/bb/include/pextern.h"
#include	"/bb/include/optable.h"


main (argc,argv)
int argc;
char *argv[];
{
	int	i,fd;
	struct phead pch;
	char	buf[PATHSIZE],cram[4];
	unsigned *uptr,chk;
	char	codbuf[16];
	unsigned	codecnt;
	unsigned	tpc;
	int			strttpc,endtpc;


	/** Set up **/
	if (argc < 2) {
		printf("Usage: %s pcodefile [[start tpc] [end tpc]]\n",argv[0]);
		exit(-1);
		}

	/* open file */
	if ((fd = open(argv[1],0)) < 0) {
		printf("pdump: Can't open %s.\n",argv[1]);
		exit(-1);
		}

	if (read(fd,(char *)&pch,sizeof(pch)) < 0) {
		printf("pdump: Can't read pcode header.\n");
		exit(-1);
		}

	i = pch.magic ;
	if ( i != NORMPGM && i != OVLYPGM && i != BASEPGM ) {
		printf( "pdump: Not a bb pgm!" );
		exit(-1);
		}

	if (read(fd,buf,PATHSIZE) < 0) {
		printf("pdump: Can't read program name.\n");
		exit(-1);
		}

	/** chk for starting tpc arg **/
	strttpc = endtpc = -1 ;		/* assume not */
	if ( argc > 2 ) {

		/* get start tpc */
		i = sscanf(argv[2], "%d", &strttpc) ;
		if ( i <= 0 || strttpc < 0 ) {
			puts("pdump: bad starting tpc");
			exit(-1) ;
			}
		if ( argc > 3 ) {

			/* get end tpc */
			i = sscanf(argv[3], "%d", &endtpc) ;
			if ( i <= 0 || endtpc < 0 ) {
				puts("pdump: bad ending tpc.") ;
				exit(-1) ;
				}
			}
		}
	
#ifdef	dbug
	printf("start,end = %u %u\n", strttpc, endtpc) ;
#endif

	/** Show header **/

	if ( strttpc > 0 )
		goto showpc ;		/* starting arg in cmd line - skip header display */

	puts( "> Header -" );

	for (i=0; i<4; ++i)  
		cram[i] = pch.cram[i];

	if (buf[0] != '\0')
		printf("Dump for : %s\n",buf);

	if ( pch.magic == NORMPGM )
		printf( "Stand Alone bb pgm.\n\n" );
	else if ( pch.magic == OVLYPGM )
		printf( "Overlay bb pgm.\n\n" );
	else if ( pch.magic == BASEPGM )
		printf( "Base bb pgm.\n\n" );

	printf("magic    : %-5u\t",pch.magic);
	printf("totsiz   : %-5u\n",pch.totsiz);

	printf("\ncodsiz   : %-5u\t",pch.codsiz);
	printf("ltabsiz  : %-5u\n",pch.ltabsiz);
	printf("symsiz   : %-5u\t",pch.symsiz);
	printf("stksiz   : %-5u\n",pch.stksiz);
	printf("ustsiz   : %-5u\t",pch.ustsiz);
	printf("maxsiz   : %-5u\n",pch.maxsiz);

	puts("\nInterface section -");
	printf("iltsiz   : %-5u\t",pch.iltsiz);
	printf("bcdsiz   : %-5u\n",pch.bcdsiz);
	printf("bvrsiz   : %-5u\t",pch.bvrsiz);
	printf("icksum   : %-5u\n",pch.icksum);
	printf("bcksum   : %-5u\t",pch.bcksum);
	printf("basnam   : %-s\n",pch.basnam);

	printf("\nlasterrno: %-5d\t",pch.lasterrno);
	printf("begmem   : %-5x\n",pch.begmem);
	printf("pclast   : %-5x\t",pch.pclast);
	printf("pcerr    : %-5x\n",pch.pcerr);
	printf("lastfilno: %-5d\t",pch.lastfileno);
	printf("randseed : %-5u\n",pch.randseed);
	printf("timeleft : %-5u\t",pch.timeleft);
	printf("cram     : <%c><%c><%c><%c>\n",cram[0],cram[1],cram[2],cram[3]);

	printf("\npc       : %-5x\t",pch.pc.B);
	printf("fp       : %-5x\n",pch.fp.B);
	printf("bfp      : %-5x\t",pch.bfp.B);
	printf("gfp      : %-5x\n",pch.gfp.B);
	printf("sp       : %-5x\n",pch.sp.B);

	printf("\nrevision : %u.%u\n",(pch.revision>>8)&0x00ff,pch.revision&0x00ff);
	printf("pcstmtx  : %-5x\n",pch.pcstmtx.sxflag);

	puts("\nDebugger flags -");
	printf("derror   : %-5u\t",pch.derror);
	printf("dikey    : %-5u\n",pch.dikey);
	printf("dbreak   : %-5u\t",pch.dbreak);
	printf("dincbs   : %-5u\n",pch.dincbs);

	puts("\nDebugger return data -");
	printf("dcontin  : %-5u\t",pch.dcontin);
	printf("dabort   : %-5u\n",pch.dabort);
	printf("dabortp  : %-5u\t",pch.dabortp);
	printf("dpmdump  : %-5u\n",pch.dpmdump);

	puts("\nCompiler flags -");
	printf("compdeb  : %-5u\t",pch.compdeb);
	printf("runonly  : %-5u\n",pch.runonly);
	printf("noltab   : %-5u\n",pch.noltab);

	printf("\nchksum   : %-5u\n",pch.chksum);

	/* compute chksum */
	chk = 0 ;
	for ( uptr = (unsigned *)&pch ; uptr < &pch.chksum ; )
		    chk -= *uptr++ ;
	printf( "computed chksum = %u\n", chk );

	/** Show p-code **/
	/* Note - very bad buffering scheme */

	puts( "\f> P-code -" );

showpc:
	printf( "%4s  %4s  %-8s\n", "tpc","code", "instr" );

	/* chk for user supplied start & end */
	if ( strttpc > 0 )
		tpc = (unsigned) strttpc ;
	else
		tpc = 0 ;		/* start at 0 */
	if ( endtpc > 0 )
		codecnt = (unsigned) endtpc ;
	else
		codecnt = pch.codsiz - 1 ;

	/* dump instr's */
	while ( tpc <= codecnt ) {
		
		/* read in next few bytes */
		lseek( fd, (long)(tpc+512), 0 );	/* set pos */
		read( fd, codbuf, 8 );		/* read 'some' bytes */

		/* show instr */
		i = dumppc( codbuf, tpc );

		/* update ptrs */
		tpc += i ;
		}



	exit( 0 );
	}

dumppc ( pc, tpc )

/* Given PC = ptr to 1st byte of op-code, show instr & i-ops.

  Ret -
	Ret val	= # of bytes in instr.
*/

POINTER	pc;
unsigned tpc;		/* current tpc (for addr's) */
{
	register int	i;
	register POINTER	PC;
	register struct optab *opp;
	int		iopcnt;		/* # of i-ops in pcode */
	int		code;		/* p-code value */
	long	lval;
	char	buf[16];
	int		opcnt;
	int		codcnt;
	unsigned insadr;

   PC = pc ;
   insadr = tpc ;		/* instr addr */

   /* get code */
	code = *PC.B++ ;	/* 1st byte */
	if ( (unsigned)code < 10 ) {
		/* 2 byte p-code */
		code &= 255 ;
		code = (code << 8) + *PC.B++ ;
		codcnt = 2 ;
		tpc += 2 ;
		}
	else {
		/* 1 byte p-code */
		codcnt = 1 ;
		tpc++ ;
		}

	
	/** get opcode str & i-op count **/
	iopcnt = 0 ;
	for (opp = optab ; opp->opval != code ; opp++)  {

		if ( opp->opname == (char *)0 ) {

			/* not found */
			showinst( insadr, code, "???" );
			putchar('\n') ;
			return( 1 );
			}

		else if ( strcmp( opp->opname, "%nops" ) == 0 ) {

			/* change i-op count */
			iopcnt = opp->opval ;
			}
		}

	/* Show instr */
	showinst( insadr, code, opp->opname );


	/** Show i-ops **/

	/* chk for addr i-op */
	if ( iopcnt == -1 ) {
		i = *PC.J ;		/* offset */
		showadr( i, tpc );
		iopcnt = 2 ;
		}

	/* chk for special case */
	else if ( iopcnt == -2 ) {
		iopcnt = 0 ;
		switch ( code ) {

			case	ONGO:
			case	ONGS:	 /* show arg list */
				i = *PC.B++ ;		/* arg count */
				iopcnt = 1 ;
				while ( i-- != 0 ) {
					iopcnt++ ;
					/* >> show vectors */
					}
				break;

			case	LDCA:		/* show str lit */
				i = *PC.B ;		/* char cnt */
				/* >> show str */
				iopcnt = i + 1 ;
				break;
			}
		}

	else if ( iopcnt != 0 ) {

		/* show n i-ops */
		switch ( iopcnt ) {
			case 1:
				lval = (long)(*PC.B & 255);
				break;
			case 2:
				lval = (long)(*PC.J & 65535);
				break;
			case 4:
				lval = (long)*PC.L ;
				break;
			}
		printf( "%D", lval );
		}

	putchar( '\n' );

	opcnt = iopcnt + codcnt ;	/* # bytes in instr */
	if ( opcnt <= 0 )
		opcnt = 1;		/* can't have 0 */

	return( opcnt );
	}

showadr( offset, tpc )

/* Show given offset as value & as addr.
   Format =  <addr>  (<offset>)
   Note - assumes tpc is tpc of instr.
*/

int		offset;
unsigned tpc;
{

	printf( "%-6u (%d)", tpc+offset, offset );
	}


showinst ( tpc, code, str )

/* Show instr (without i-ops) */

unsigned tpc;
int		code;
char	*str;
{

	printf( "%4u  %4d  %-6s ", tpc, code, str );
	}
