:! SVAL - Convert a string to a number with auto-scaling
:# DESCRIPTION
:     SVAL converts a string in X$ to a number in X.  It will convert
:     signed or unsigned numbers with or without a decimal point.
:     The input variable Z contains the location of the implied
:     decimal point. The value of X is scaled by the appropriate
:     power of 10 to cause the keyed decimal location to correspond
:     to the desired location.  A negative Z causes the special case
:     of a number with no decimal point not to be scaled, while a
:     positive Z treats no decimal the same as a decimal to the right
:     of the least significant digit. The variable Y% will be
:     returned with the location of the conversion terminating
:     character or zero if terminated by end of string.  Y% may be
:     positive or negative.  A positive Y% indicates that termination
:     occurred with a space or comma and that X$ has been shifted
:     such that the Y%+1 character is now the first character. This
:     facilitates processing a list of numbers. A negative Y% will be
:     returned for any other terminating character without
:     modifying X$.
:
:> CALLING SEQUENCE
:     X$ - String to be converted
:     Z  - Desired scale for decimal location  (+ or -)
:          >0 - scale with nn~~n  same as nn~n.
:          <0 - no scaling occurs for nn~~n (adding machine mode)
:     GOSUB 7680
:     X  - Value of X$
:     Y% - Ending position upon conversion termination
:          >0 - conversion ended with space or comma
:          =0 - conversion ended from end of string
:          <0 - conversion ended from non-digit, space or comma
:
:$ STORAGE USED
:     Z% - Decimal location returned from VALUE statement
::
7680 REM \ SVAL - SCALED VALUE
7682 UNPACK "UUU","<0>",X,Y%,Z%     :Initialize vars before VALUE
7684 VALUE X,X$,Y%,Z%               :Value of X$
7686 IF Z<=0 THEN IF Z%<0 THEN GOTO 7694   :Don't process X if
:             no decimal keyed and no scale required
7688 LET Z%=ABS(Z)-MAX(Z%,0)        :Relative scale value
7690 IF Z%<0 THEN LET X=X/10^(-Z%)  :Too many decimal places
7692 IF Z%>0 THEN LET X=X*10^Z%     :Too few decimal places
7694 IF Y%>0 THEN LET X$=X$[Y%+1]   :New X$ for list processing
7696 RETURN
7698 REM END SVAL
