/*************************************************************************
*
*
*	Name:  xcall16.c
*
*	Description:  XCALL 16  statement.
*
*
*	History:
*	Date		By		Comments
*
*	4/19/83	waf
*	04/20/83	mas		changed to use STRDES instead of 
*					pointer to STRDES
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */
#include	"/bb/include/ptype.h"


xcall16 ( strdes, trancode )

STRDES	strdes;
int	trancode;

	{
	int	nbytes;
	char	*ptr;
	register char	c;
	register int	i;

	if ( trancode > 6 || trancode < 0 )  return ;

	nbytes = strdes.curlth ;		/* # bytes in $ */
	ptr = strdes.data ;				/* byte ptr */

	/** do transformation **/
	for ( i = 0 ; i < nbytes ; i++, ptr++ )
		{
		c = *ptr ;		/* next char */
		switch	(trancode)
			{

			case 0 :		/** lower to upper **/
				if ( c >= 'a' && c <= 'z' )
					c -= 32 ;		/* convert */
				break;

			case 1 :		/** upper to lower **/
				if ( c >= 'A' && c <= 'Z' )
					c += 32 ;		/* convert */
				break;

			case 2 :		/** parity to space **/
				if ( (c & 0x80) != 0 )
					c = ' ' ;		/* convert */
				break ;

			case 3 :		/** no parity to space **/
				if ( (c & 0x80) == 0 )
					c = ' ' ;		/* convert */
				break;

			case 4 :		/** clear parity **/
				c &= 0x7f ;
				break;

			case 5 :		/** set parity **/
				c |= 0x80 ;
				break;

			case 6 :		/** non-parity to space / clear parity **/
				if ( (c & 0x80) == 0 )
					c = ' ' ;		/* non-parity to space */
				else
					c &= 0x7f ;		/* clear parity */
				break;

			}	/* end switch */

		*ptr = c ;		/* put converted char back */
		}

	}
