/*************************************************************************
*
*
*	Name:  upka, upkl and upkd
*
*	Description:  unpack from a string variable
*
*
*	History:
*	Date		By		Comments
*
*	04/07/83	WEB
*	06/22/83	mas		memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/

#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"

upka(dest, xpbuf)				/* unpack alphanumeric */
STRDES dest;
PAKDES *xpbuf;
{
   register PAKDES *pbuf;
   int length;
   register char fmtchar, *tptr;

   pbuf = xpbuf;

   if (pbuf->pkfmtptr >= pbuf->pkfmtend)
      bberr(BEEOD);			/* error if nothing left in format */

   fmtchar = *pbuf->pkfmtptr++;		/* save and move over format */

   if (fmtchar != 'A' && fmtchar != 'S')
      bberr(BERDT);			/* illegal format error */

   if ((length = getlength(pbuf)) == -1)
      length = 1;			/* default is 1 for A and S */

   tptr = pbuf->pkstrptr;		/* save pointer */

   pbuf->pkstrptr += length;		/* update pointer */

   if (pbuf->pkstrptr > pbuf->pkstrend)
      bberr(BESSZ);			/* error if past end */

   while (length > 0 && dest.maxlth > 0 && (*tptr != '\0' || fmtchar == 'S')) {
      *dest.data++ = *tptr++;		/* move the data */
      --dest.maxlth;
      --length;
   }

   updcl(&dest);			/* update destination string */

   chkpos(pbuf);			/* check for @ and + */

} /* end-upka */

upkl(valaddr, xpbuf)			/* unpack numeric */
long *valaddr;
PAKDES *xpbuf;
{
   register PAKDES *pbuf;
   register int i, j, k, prec;
   char signbyte, *tptr;

   pbuf = xpbuf;

   if (pbuf->pkfmtptr >= pbuf->pkfmtend)
      bberr(BEEOD);			/* error if nothing left in format */

   prec = getprec(*pbuf->pkfmtptr);	/* get precision of format */

   if (pbuf->pkstrptr+prec > pbuf->pkstrend)
      bberr(BESSZ);			/* error if length exceeds max. */

   if (*pbuf->pkfmtptr == 'U') {

      pbuf->pkfmtptr++;			/* move over format specifier */
      if ((i = getlength(pbuf)) == -1)
	 i = 0;				/* default is bit 0 */
      if (i > 7)
	 bberr(BEIFS);			/* maximum is bit 7 (1 byte) */
      *valaddr = ((*pbuf->pkstrptr & (1 << i)) == 0) ? 0L : 1L;

   } else {

      tptr = (char *) valaddr;		/* make a pointer to char */
					/* set sign-extend byte */
      if (((unsigned) (*(pbuf->pkstrptr))&0200) != 0 &&
	    *pbuf->pkfmtptr >= 'I' && *pbuf->pkfmtptr <= 'L')
	 signbyte = '\377';
      else
	 signbyte = '\000';
					/* move data */
      for (i = 0, j = 3, k = 0; i <= 3; i++, j--)
	 *(tptr+i) = (j < prec) ? *(pbuf->pkstrptr+(k++)) : signbyte;
      swab(tptr, tptr, 4);		/* swap bytes */
      pbuf->pkstrptr += prec;		/* update pointer */
      pbuf->pkfmtptr++;			/* move over format specifier */

   }

   chkpos(pbuf);			/* check for @ and + */

} /* end-upkl */

upkd(array, element, xpbuf)		/* unpack array */
ARRDES *array;
NPTR   element;
PAKDES *xpbuf;
{
   register PAKDES *pbuf;
   register int i, j, k, e, prec, count;
   char fmtchar, signbyte, *tptr, *arrayend;
   long temp;

   pbuf = xpbuf;

   if (pbuf->pkfmtptr >= pbuf->pkfmtend)
      bberr(BEEOD);			/* error if nothing left in format */

   fmtchar = *pbuf->pkfmtptr++;		/* save and move over format */

   prec = getprec(fmtchar);		/* get precision of format */

   arrayend = (char *) array->adata.j + array->amaxsiz;

   if (fmtchar == 'U') {

      if ((char *) element.j >= arrayend)
	 bberr(BESUB);			/* error if past end of array */
      if ((i = getlength(pbuf)) == -1)
	 i = 0;				/* default is bit 0 */
      if (i > 7)
	 bberr(BEIFS);			/* maximum is bit 7 (1 byte) */
      temp = ((*pbuf->pkstrptr & (1 << i)) == 0) ? 0L : 1L;
      switch (array->type) {		/* store the array element */
	 case 0: *element.j = (int) temp; break;
	 case 1: *element.l = temp; break;
      }

   } else {

      if (*pbuf->pkfmtptr == '*') {	/* process repeat count */
	 pbuf->pkfmtptr++;
	 if ((count = getlength(pbuf)) == -1)
	    count = 1;			/* '*' alone gets default of 1 */
      } else
	 count = 1;			/* default repeat count is 1 */
      for (e = 0; e < count; e++) {
	 if ((char *) element.j >= arrayend)
	    bberr(BESUB);		/* error if past end of array */
	 if (pbuf->pkstrptr+prec > pbuf->pkstrend)
	    bberr(BESSZ);		/* error if length exceeds max. */
	 tptr = (char *) &temp;		/* make a pointer to char */
					/* set sign-extend byte */
	 if (((unsigned) (*(pbuf->pkstrptr))&0200) != 0 &&
	       fmtchar >= 'I' && fmtchar <= 'L')
	    signbyte = '\377';
	 else
	    signbyte = '\000';
					/* move data to temp */
	 for (i = 0, j = 3, k = 0; i <= 3; i++, j--)
	    *(tptr+i) = (j < prec) ? *(pbuf->pkstrptr+(k++)) : signbyte;
	 swab(tptr, tptr, 4);		/* swap bytes */
	 switch (array->type) {		/* store the array element */
	    case 0: *element.j++ = (int) temp; break;
	    case 1: *element.l++ = temp; break;
	 }
	 pbuf->pkstrptr += prec;	/* update pointer */
      } /* end-for */

   }

   chkpos(pbuf);			/* check for @ and + */

} /* end-upkd */

getprec(fmtchar)
char fmtchar;
{
   switch (fmtchar) {			/* determine number of bytes */

      case  'I':
      case  'J':
      case  'K':
      case  'L':
	 return((int) (fmtchar - 'H'));

      case  'B':
      case  'C':
      case  'D':
	 return((int) (fmtchar - 'A'));

      case  'U':
	 return(1);

      default:
	 bberr(BERDT);			/* illegal format error */
      
   } /* end-switch */

} /* end-getprec */
