/*************************************************************************
*
*
*	Name:  terminit.c
*
*	Description:  Initializes terminal to no echo, cbreak mode
*
*
*	History:
*	Date		By	Comments
*
*	03/30/83	mas
*	10/18/83	waf	Flag re-directed input.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

10/18/83	waf
  The 'isatty()' call is used to find if the input is from a file (e.g. input
	was redirected) or from a character device (e.g. terminal input).
  The bit flag 'gflags.bitflag.inredir' was added to flag redirected i/o.
	That is, if input is redirected when 'bb' is invoked, gflags.bitflag.inredir
	is set. If input is from the terminal, the gflags.bitflag.inredir flag is
	reset.
  This flag is used primarily to tell if the input is from a terminal or from
	a file. For example, STMA 8,4 has to know this so that the rdchk() call
	is only made if input is from a terminal.

  NOTE that the ioctl() call is not made if input is from a file, thus the
	values in 'newmode' and 'oldmode' are defined only if input is from
	the terminal.
*/



#include <stdio.h>
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"


terminit()
{
	/* chk for redirected input */
	if ( isatty(0) == 0 ) {

		/** re-directed input **/
		gflags.bitflag.inredir = 1 ;	/* flag redirected input */
		}
	
	else {

		/** terminal input **/
		gflags.bitflag.inredir = 0 ;	/* flag terminal input */

		/* save original characteristics */
		ioctl(0,TIOCGETP,&oldmode);
		ioctl(0,TIOCGETC,&oldchar);
		ioctl(0,TIOCGETP,&newmode);

		/* change some characteristics */
		newmode.sg_flags |= CBREAK;
		newmode.sg_flags &= ~ECHO;
		ioctl(0,TIOCSETP,&newmode);
		}

	/** initialize iostatus structure **/
	iost.status  = 0;
	iostat.iocount = iostat.iopos = 0;
	iostat.ioterm  = '\0';
	iostat.ifd     = 0;	/* set to input from stdin */
	iostat.ofd     = 1;	/* set to output to stdin */

	iobuf [0] = '\0';
	termcount  = 0;
	termbuf[0] = '\0';
	}


termreset()		/** reset term characteristics **/
{
	if ( gflags.bitflag.inredir != 1 ) {	/* if term input */
		ioctl(0,TIOCSETP,&oldmode);
		ioctl(0,TIOCSETC,&oldchar);
		}
	}
