/*************************************************************************
*
*
*	Name:  subcalc.c
*
*	Description:  calculates the address of an array element
*			given the array descriptor, and the element
*			subscripts
*
*
*	History:
*	Date		By	Comments
*
*	03/02/83	mas
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"


unsigned subcalc(ardes,elem)
ARRDES	*ardes;
int	*elem;
{

register unsigned u1,utot,elsize;
	int	i,j,t;

	if(ardes->adata.j == (int *)0)
		bberr(BEDIM);

	for (i = u1 = 0; i < ardes->numdim; ++i) {
		if (elem[i] > ardes->bound[i])
			bberr(BESUB);
		for (j = i+1, utot = 1; j < ardes->numdim; ++j)
			utot *= ardes->bound[j]+1;
		u1 += elem[i] * utot;
	}

	t = ardes->type;
	elsize = (t == 0) ? sizeof(int):(t == 1)? sizeof(long):sizeof(float);

	return (u1 * elsize);
}
