/*************************************************************************
*
*
*	Name:  strfunc.c
*
*	Description:  String functions: chr, asc, and fill
*
*
*	History:
*	Date		By	Comments
*
*	03/30/83	web
*	05/16/83	mas	added register variables where possible
*	05/24/83	WEB	fixed a problem with TRUN$(-,1) returning
*				a space
*	05/27/83	WEB	added register variables to fill to 
*				improve performance
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"

chrl(str, value, numchar)
STRDES *str;
long value;
int numchar;
{
   register int i;
   STRDES stmp;
   char tmp[4];

   if (numchar < 1 || numchar > 4)	/* use 1 if number is out of range */
      numchar = 1;

   stmp.data = tmp;			/* build a local STRDES */
   stmp.curlth = numchar;
   stmp.maxlth = 0;

   for (i = numchar-1; i >= 0; --i)  {	/* build a string version w/ shifts */
      tmp[i] = (unsigned) value&0377;
      value = value>>8;
   }
   
   movdd(&stmp, str);			/* move temporary to destination */

} /* end-chrl */

long ascl(str)
STRDES str;
{
   register int i;
   register long tmp;

   if (str.curlth < 4)
      i = 0;
   else
      i = str.curlth - 4;

   for (tmp = 0; i < str.curlth; i++)
      tmp = (tmp<<8) + (i < 0 ? 0 : (unsigned) str.data[i]);

   return(tmp);

} /* end-ascl */

fill(str, value, numchar)
STRDES *str;
int value;
int numchar;
{
   register char *cp;
   register unsigned length;

   if (numchar < 1)			/* do nothing if count < 1 */
      numchar = 0;

   value &= 0377;

   cp = str->data;
   length = str->maxlth;

   while (numchar > 0 && length != 0) {
      *cp++ = value;
      numchar--;
      length--;
   }

   str->data = cp;
   str->maxlth = length;

} /* end-fill */

trun(dest, str, flag)
STRDES *dest, str;
int flag;
{
   register char *ptr, *endptr;

   ptr = str.data;
   endptr = ptr+str.curlth-1;

   if (flag)
      while ((*endptr == '\0' || *endptr == ' ') && endptr >= ptr)
	 endptr--;

   while (ptr <= endptr && *ptr != '\0'
		        && *ptr != '\n'
                        && *ptr != '\r'
		        && *ptr != '\f')
      ptr++;
   
   if (ptr > str.data) {
      str.curlth = ptr-str.data;
      movdd(&str, dest);
   }

} /* end-trun */
