/*************************************************************************
*
*
*	Name:  ptrace.c
*
*	Description:  Prints the line number of the current statement
*
*
*	History:
*	Date		By	Comments
*
*	04/08/83	mas
*	04/18/83	mas	changed to default to stderr 
*	05/12/83	mas	changed to call cnvlin()
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

extern long pctoline();

static unsigned trcnt = 0;

ptrace()
{
	char	nbuf[32];

	if (tracefd == -1) {
		tracefd = 2;	/* reset to stderr */
		trcnt = 0;
		return;
	}

	if (trcnt > 9) {
		write(tracefd,"\n",1);
		trcnt = 0;
	}

	nbuf[0] = '[';
	cnvlin(pclast,&nbuf[1]);
	strcat(nbuf,"] ");
	write(tracefd,nbuf,strlen(nbuf));

	++trcnt;
	return;
}
