/*************************************************************************
*
*
*	Name:  print control
*
*	Description:  terminal control functions ( @(x,y) )
*
*
*	History:
*	Date		By	Comments
*
*	02/26/83	WEB
*	05/16/83	WEB	restructure item -19 for global defaults
*	05/24/83	WEB	fixed a problem with secondary ikey
*	06/01/83	mas	fixed problem where arg2 == 0 and arg1 > 0
*				wasn't positioning to col 1
*	06/16/83	mas	memory and speed squeeze
*       09/06/83        cba     changed number of @(-xx) functions allowed.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -	this module handles the terminal control functions ( @(...) )
		for both input (inctl) and print (prctl). The terminal
		dependent code is contained in the mudule crts.c and is
		initially supplied with a driver for terminal type 6 only.
		all other type appear to be "glass teletypes" with only a
		minimal driver supplied.

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"


extern CRTCTRL *crtctrl[];		/* terminal control structures */
extern char *(*crtattrib[])[0];		/* terminal attribute structures */
extern int (*posncurs[])();		/* cursor position functions */


prctl(arg1, arg2)				/* print terminal control */
int arg1, arg2;
{
   char buf[IOSIZE];
register int n;

   if ((n = termctl(arg1, arg2, buf)) > 0)
      iocpy(buf, n);				/* move to i/o buffer */

} /* end-prctl */

inctl(arg1, arg2)				/* input terminal control */
int arg1, arg2;
{
   char buf[IOSIZE];
register int n;

   if ((n = termctl(arg1, arg2, buf)) > 0)
      inprm(buf, n);				/* move to prompt buffer */

} /* end-inctl */

termctl(arg1, arg2, buf)
int arg1, arg2;
char buf[];
{
   int n, flag;
register char c, *p;
   CRTCTRL *ustptr;

   if (arg1 > 0 && arg2 >= 0){			/* cursor position operation */

      if (arg2 == 0)				/* if col 0 then col = 1 */
	arg2 = 1;

      n = (*posncurs[ust.termtype])(arg1, arg2, buf);

   } else if (arg1 >= -67 && arg1 <= -20) {	/* alter terminal attributes */

      n = 0;					/* set count (length) to 0 */

      arg1 = (-arg1) - 20;			/* set subscript */

      p = (*crtattrib[ust.termtype])[arg1];	/* set pointer to attributes */

      while ((c = *p++) != '\0' && c != '\377') /* move to buffer */
	 buf[n++] = c;

    } else {					/* terminal control operation */
      
      n = 0;					/* most return nothing */

      switch (arg1) {

	 case -1:				/* line cancel character */
	    ust.lcan = arg2&0377;
	    break;

	 case -2:   				/* character delete echo */
	    ust.dele = arg2&0377;
	    break;

	 case -3:   				/* character delete character */
	    ust.del = arg2&0377;
	    break;

	 case -4:  				/* primary unpend character */
	    ust.unpend1 = arg2&0377;
	    break;

	 case -5:   				/* secondary unpend character */
	    ust.unpend2 = arg2&0377;
	    break;

	 case -6:   				/* primary IKEY character */
	    ust.ikey1 = arg2&0377;
	    setik1();
	    break;

	 case -7:   				/* secondary IKEY character */
	    ust.ikey2 = arg2&0377;
	    break;

	 case -8:   				/* page width */
	    ust.pagewidth = arg2;
	    break;

	 case -9:   				/* tab size for print zones */
	    ust.tabsiz = arg2;
	    break;

	 case -10:   				/* input maximum */
	    ust.inputmax = arg2;
	    break;

	 case -12:   				/* line cancel echo #1 */
	    ust.lcane1 = arg2&0377;
	    break;

	 case -13:   				/* line cancel echo #2 */
	    ust.lcane2 = arg2&0377;
	    break;

	 case -14:   				/* pad character */
	    ust.pad = arg2&0377;
	    break;

	 case -15:   				/* pad count */
	    ust.padcnt = arg2;
	    break;

	 /* case 16 & case 17 are undefined */

	 case -18:				/* sub-modes like STMA 6 & 7 */
	    if (arg2 < 0) {
	       flag = 0;			/* clear if negative */
	       arg2 = (-arg2);
	    } else
	       flag = 1;			/* otherwise set */
	    
	    switch (arg2) {			/* select sub-mode */

		case 0:
		  ust.noecho = flag;		/* no echo */
		  break;

		case 1:
		  ust.lower = flag;		/* allow lower case */
		  break;

		case 2:
		  ust.ctlchar = flag;		/* allow control characters */
		  break;

		case 3:
		  ust.nocolumn = flag;		/* disable column counter */
		  break;

		case 4:
		  ust.nomsgs = flag;		/* no messages allowed */
		  break;

		case 5:
		  ust.noikey = flag;		/* disallow interrupts */
		  break;

		/* case 6 does not apply */

		case 7:
		  ust.noecho = flag;		/* no echo (same as 0) */
		  break;

		case 8:
		  ust.xfrcrlf = flag;		/* NAS bit (flip CR & NL) */
		  break;

	    } /* end-switch */
	    break;

	    case -19:				/* reset -1 thru -15 */
	       ustptr = (CRTCTRL *) &ust;	/* copy first 9 directly */
	       *ustptr = *crtctrl[ust.termtype];
	       ust.lcan = deflcan;		/* set the rest from defaults */
	       ust.del = defdel;
	       ust.unpend1 = defunp1;
	       ust.unpend2 = defunp2;
	       ust.ikey1 = defik1;
	       ust.ikey2 = defik2;
	       setik1();			/* reset primary interrupt */
	       break;

	    default:				/* do nothing for others */
	       n = 0;

      } /* end-switch */

   } /* end-if */

   return(n);					/* return length of buffer */

} /* end-termctl */
