/*************************************************************************
*
*
*	Name:  movs.c
*
*	Description: String descriptor move routines
*
*
*	History:
*	Date		By	Comments
*
*	03/30/83	mas
*	04/08/83	waf	Added movbdz()  (allow '\0' to be moved).
*	04/18/83	waf	Added stsb().
*	05/16/83	mas	added register variables where possible
*	09/16/83	waf	Optimized code.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */


/*  Notes -
	movbd - Move from buffer to string descriptor.
	movbdz - Same as movbd(), but allows '\0' to be moved.
	movdb - Move from string descriptor to buffer.
	movdd - Move from string descriptor to string descriptor.
			NOTE - src string descriptor not updated.
	updcl - Update descriptor current length.
	stsb  - Move one byte to string descriptor.

9/30/83		waf
  *> Note - movbdz() should be used instead of movbd() whenever possible.
  movbdz() is much faster.

*/


#include "/bb/include/ptype.h"

movbd (buffer,length,strdesc)
char	*buffer;		/* source string address */
int	length;				/* length to move */
STRDES	*strdesc;		/* address of the string descriptor */
{
	register int	l;
	register char	*dptr;
	char	c;
	int		tmp;

	/* get # bytes */
	if ( (l=strdesc->maxlth) > length )
		l = length ;

	/* move them */
	tmp = l ;
	dptr = strdesc->data ;	/* dst ptr */
	while ( l && (c = *buffer) != '\0' ) {
		*dptr++ = c ;
		buffer++ ;
		l-- ;
		}
	l = tmp - l ;		/* # bytes actually moved */

	/* update str desc params */
	strdesc->maxlth -= l ;
	strdesc->data = dptr ;

	/* return # bytes moved */
	return( l );
	}


movbdz (buffer,length,strdesc)
char	*buffer;		/* source string address */
int	length;				/* length to move */
STRDES	*strdesc;		/* address of the string descriptor */
{
	register int	l;
	register STRDES	*rsp;

	rsp = strdesc ;		/* use reg var */

	/* get # bytes to move */
	if ( (l=rsp->maxlth) > length )
		l = length ;

	/* move 'l' bytes */
	movs( buffer, rsp->data, l );

	/* update str desc params */
	rsp->maxlth -= l ;
	rsp->data += l ;

	/* return # bytes moved */
	return( l );
	}


movdb (strdesc,buffer,length)
STRDES	*strdesc;		/* address of the source string descriptor */
char	*buffer;		/* destination string address */
int	length;				/* length to move */
{
	register int	l;
	register STRDES	*rsp;

	rsp = strdesc ;		/* use reg var */

	/* get # bytes to move */
	if ( (l=rsp->curlth) > length )
		l = length ;

	/* move them */
	movs( rsp->data, buffer, l );
	*(buffer + l) = '\0';		/* term the string */

	/* update strdesc params */
	rsp->data += l ;
	rsp->curlth -= l ;

	/* return # bytes moved */
	return( l );
	}


movdd (sdesc,ddesc)
STRDES	*sdesc;			/* address of the source string descriptor */
STRDES	*ddesc;			/* address of the dest string descriptor */
{
	register int	l;
	register STRDES	*rsp;

	rsp = ddesc ;		/* use reg var */

	/* get # bytes to move */
	if ( (l=sdesc->curlth) > rsp->maxlth )
		l = rsp->maxlth ;

	/* move them */
	movs( sdesc->data, rsp->data, l );

	/* update dest str params
	   (src str params NOT updated) */
	rsp->data += l ;
	rsp->maxlth -= l ;

	/* return # bytes moved */
	return( l );
	}

updcl (strdesc)
STRDES	*strdesc;
{
	register PSTRPTR psptr;
	register int	tempj;

	psptr = (PSTRPTR)strdesc->pardes;
	tempj = strdesc->data - psptr->pdata;
	if (strdesc->maxlth != 0 || psptr->pcurlth <= tempj)
		psptr->pcurlth = tempj;
	if (psptr->pcurlth < psptr->pmaxsiz)
		psptr->pdata[psptr->pcurlth] = '\0';
	}

stsb ( strdes, c )
STRDES	*strdes;
char	c;
{
	if ( strdes->maxlth-- == 0 ) {
		strdes->maxlth++ ;
		return( FALSE );
		}
	*strdes->data++ = c ;
	return( TRUE );
	}
