/*************************************************************************
*
*
*	Name:  stmc21 (.LINK) and stmc35 (.UNLINK)
*
*	Description:  install & remove pseudo-links
*
*
*	History:
*	Date		By		Comments
*
*	04/22/83        WEB
*	04/29/83        WEB		changed pseudo-links to ".lk"
*	6/24/83 	mas		changed to use registers where possible
*	07/13/83	mas		changed to truncate spaces from end
*					of name
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


	"links" as defined by stmc21 and stmc35 are pseudo-links
	handled by Business BASIC for purposes of logical file 
	opening. These pseudo-links are actually Xenix files con-
	taining the name of the resolution file. No support for
	these pseud-links exists outside of that provided by the 
	Business BASIC system except for utilitioes written exp-
	ressely for that purpose. These are REQUIRED for the log-
	ical file open (LOPEN) to work.


*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"
#include <sys/types.h>
#include <sys/stat.h>

extern int errno;


stmc21(err, linknam, reslnam)		/* .LINK */
NUMDES	err;
STRDES	linknam, reslnam;
{
   char tmp[PATHSIZE+1];
   register int e, l, fd;
   struct stat stats;

   if (linknam.curlth <= 0 || reslnam.curlth <= 0) {
      putvj(&err, -ERFNM);		/* error if names are null */
      return;	
   }

   e = movdb(&linknam, tmp, 128);	/* copy link-name */

   spscan(tmp);				/* remove trailing junk */

   strcat(tmp, ".lk");			/* make it a pseudo-link */

   if ((e = stat(tmp, &stats)) >= 0 )
      e = ERCRE;			/* error if it already exists */
   else if ((fd = creat(tmp, 0666)) < 0)
      e = errxlt(errno);		/* error if can't create it */
   else {
      l = movdb(&reslnam, tmp, 128);	/* copy resolution-name */
      tmp[l++] = '\n';			/* set terminator to new-line */
      if (write(fd, tmp, l) < 0)
	 e = errxlt(errno);		/* error if can't write to it */
      else
	 e = NOERC;			/* no error */
      close(fd);
   }

   putvj(&err, -e);			/* set error for return */

} /* end-stmc21 */

stmc35(err, linknam)			/* .UNLINK */
NUMDES err;
STRDES linknam;
{
   char tmp[PATHSIZE+1];
   register int e;

   if (linknam.curlth <= 0) {
      putvj(&err, -ERFNM);		/* error if name is null */
      return;	
   }

   e = movdb(&linknam, tmp, 128);	/* copy link-name */

   spscan(tmp);				/* remover trailing junk */

   strcat(tmp, ".lk");			/* make it a pseudo-link */

   if (e = unlink(tmp))			/* remove it */
      e = errxlt(errno);		/* translate if error */
   else
      e = NOERC;			/* no error */
  
   putvj(&err, -e);			/* change sign and return error code */

} /* end-stmc35 */
