/*************************************************************************
*
*
*	Name:  lwr & lrd
*
*	Description:  logical file read and write
*
*
*	History:
*	Date		By		Comments
*
*	03/15/83        WEB
*	04/27/83        WEB		fixed a problem with not lrd &
*					lwr the proper length
*	05/11/83        WEB		fixed a problem with lrd not
*					detecting end-of-file
*	06/16/83	mas		memory and speed squeeze
*	06/29/83        WEB		fixed a problem with lrd not setting
*					curlth properly
*	07/05/83        WEB		fixed a problem with lwr clobbering
*					memory when the record string was too
*					small
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"

extern long lseek();

lrd(lfileno, recno, record)
int	lfileno;
long	recno;
STRDES record;
{
   register int n;
   unsigned reclth;
   long l;
   LFTENT lfent;
   register LFTENT *lfptr;
   struct frec *ftr;

   if ((lfptr = flftbl(lfileno, &lfent)) == (LFTENT *) 0)
      bberr(BELSE);			/* logical file number out of bounds */

   if (lfptr->lfiletype != 'L' && lfptr->lfiletype != 'D')
      bberr(BEIFT);			/* wrong type */

   if (record.maxlth < lfptr->lreclen)
      bberr(BESSZ);			/* record too small */

   if (recno > lfptr->lastrecno || recno < 0L ||
	      (lfptr->lfiletype == 'L' && recno == 0L))
      bberr(BEIRN);			/* record number out of bounds */

   lastfileno = lfptr->channel;		/* set last file accessed */

   ftr = &ust.ftab[lastfileno];		/* get pointer for last file */

			
   ftr->opmode &= ~EOF_FS;		/* clear end-of-file */

   l = recno*((long) lfptr->lreclen)+lfptr->start;

   if (lseek(ftr->xfd, l, 0) < 0L)
      bberr(ERSCP);			/* error if couldn't position */

   reclth = lfptr->lreclen;

   do {					/* read the record */
      n = read(ftr->xfd, record.data, reclth);
      reclth -= n;
      record.maxlth -= n;
      record.data  += n;
   } while (n != 0 && reclth != 0);

   updcl(&record);

   if (n == 0)				/* error if get EOF */
      bberr(EREOF);

} /* end-lrd */

lwr(lfileno, recno, record)
int	lfileno;
long	recno;
STRDES	record;
{
   LFTENT lfent;
   register LFTENT *lfptr;
   struct frec *ftr;
   register int n, count;
   char buf[128];
   long l;

   if ((lfptr = flftbl(lfileno, &lfent)) == (LFTENT *) 0)
      bberr(BELSE);			/* logical file number out of bounds */

   if (lfptr->lfiletype != 'L' && lfptr->lfiletype != 'D')
      bberr(BEIFT);			/* wrong type */

   if (record.curlth > lfptr->lreclen)
      bberr(BESSZ);			/* record too big */

   if (recno > lfptr->lastrecno || recno < 0L ||
	      (lfptr->lfiletype == 'L' && recno == 0L))
      bberr(BEIRN);			/* record number out of bounds */

   lastfileno = lfptr->channel;		/* set last file accessed */

   ftr = &ust.ftab[lastfileno];		/* get pointer for last file */
			
   l = recno*((long) lfptr->lreclen)+lfptr->start;

   if (lseek(ftr->xfd, l, 0) < 0L)
      bberr(ERSCP);			/* error if couldn't position */

   n = write(ftr->xfd, record.data, record.curlth);

   if (n != record.curlth)
      bberr(ERSPC);				/* error if wrong count */

   if ((count = lfptr->lreclen - n) == 0)
      return;					/* done if all written */

   for (n = 0; n < 128; n++)
      *(buf+n) = '\0';

   while (count > 0) {				/* fill rest with nulls */
      n = (count > 128) ? 128 : count;
      count -= n;
      if (write(ftr->xfd, buf, n) != n)
	 bberr(ERSPC);
   }

} /* end-lwr */
