/*************************************************************************
*
*
*	Name:  getterm.c
*
*	Description:  set default terminal type ('defterm') based on
*		      $TERM from the environment
*
*
*	History:
*	Date		By		Comments
*
*	05/16/83	WEB
*	6/24/83 	mas		changed to use registers where possible
*	01/03/84	WAF		Change defunp values when CRMOD set.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

This module sets the default terminal type by referencing the chkterm functions
in crts.c in a manner similar to prctl.c.


02/03/84	waf
  There is some question as to the default values for primary & secondary
unpend chars. Originally, CRMOD was used to determine the default values;
the primary unpend was \r if set, \n if not. This was changed so that
the primary unpend is \n irregardless of the CRMOD setting. 
  Note that Xenix requires a \n to unpend a line. In order to use the CR key
to unpend in Xenix, CRMOD must be set (via 'stty -nl'). If CRMOD is set,
the '\r' character will never occur (\r is mapped to \n). Therefore, the
user will probably have CRMOD set or reset depending upon which key (\n or \r)
s/he would normally hit to unpend a line in Xenix. This is the argument for
making '\n' the primary unpend.

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

extern char *getenv();				/* get environment */
extern int (*chkterm[])();			/* terminal typing functions */
extern CRTCTRL *crtctrl[];			/* terminal dependent tables */

getterm()					/* get terminal type */
{
	register char     *termid;
	register int term, f;


	/* get term type */
	defterm = 0;					/* assume type 0 */
	termid = getenv("TERM");			/* get $TERM from environment */
	for (term = 0; term < 10; term++)	{	/* try each terminal type */
		f = (*chkterm[term])(termid);
		if (f == TRUE) {
			defterm = term;			/* success, set default */
			break;					/*    and exit for-loop */
			}
		}

	/* erase & kill */
	deflcan = oldmode.sg_kill;
	defdel = oldmode.sg_erase;

	/* ikeys */
	defik1 = oldchar.t_intrc;
	defik2 = (*crtctrl[defterm]).cikey2;	

	/* primary & secondary unpends.
	   At present, primary & secondary are \n & \r, irregardless of the
	   CRMOD setting. The test for CRMOD is thus currently redundant. */
	if ((oldmode.sg_flags & CRMOD) == CRMOD) {
		defunp1 = '\n';
		defunp2 = '\r';
		} 
	else {
		defunp1 = '\n';
		defunp2 = '\r';
		}

	} /* end-getterm */

