|*************************************************************************
|
|
|	Name:  bstrncmp
|
|	Description:  string compare of non-null-terminated strings
|
|
|	History:
|	Date		By		Comments
|
|	03/22/83	WEB
|	06/16/83	mas		squeeze memory and speed
|	10/21/83	waf		Converted to asm language routine.
|	11/3/83		waf		Fixed bug comparing last char (converted to words).
|
|
|
|  This document contains confidential/proprietary information.
|
|  Copyright (c) 1983 by Digital Communications Assoc.
|
|************************************************************************
| BB/Xenix Runtime Module */




|*  Notes -
|
|	 bstrncmp(s1, s2, n) returns:
|
|        	< 0 	iff 	s1 < s2
|        	= 0 	iff 	s1 = s2
|        	> 0 	iff 	s1 > s2
|
| 10/21/83	waf
|  The value returned is '0' if the strings are equal,
|	otherwise the value returned is ( c1 - c2 ) where c1 and c2 are the first
|	characters in str1 and str2, respectively, which differ.
|

| bstrncmp (ptr1, ptr2, count)
| char	*ptr1, *ptr2;
| int	count;

	.text
	.globl	_bstrncmp

_bstrncmp:
	mov		bx,sp
	push	si
	push	di

	|> /* chk for count <= 0 */
	|> if ( maxlen <= 0 )
	|>		return( 0 );
	mov		cx,6(bx)	| #bytes
	sub		ax,ax		| ret '0' if <= 0
	cmp		cx,*0
	jle		csxit

	|> /* compare strings */
	|> while ( --count>0 && (*ptr1&255) == (*ptr2&255) )
	|>		ptr1++ ; ptr2++ ;
	mov		si,2(bx)	| *str1
	mov		di,4(bx)	| *str2
	cld					| inc ptrs
	repz
	| cmpsb				| cmp while not eos and chars equal
	  .byte	/a6			  | (as doesn't recognize cmpsb (?)

	|> /* get difference between last chars (or 0 if str's equal) */
	|> return( (*ptr1&255) - (*ptr2&255) );
	movb	al,-1(si)
	and		ax,*255		| ax = last char in str1
	movb	bl,-1(di)
	and		bx,*255		| bx = last char in str2
	sub		ax,bx		| str1 - str2 (diff between last chars)

csxit:
	pop		di
	pop		si
	| RTYP 0
	ret
