/*************************************************************************
*
*
*	Name:  bread.c
*
*	Description:  READ FILE support modules.
*					( rda(), rdj(), rdset() ).
*
*
*	History:
*	Date		By		Comments
*
*	03/14/83	WEB
*	03/29/83	WEB		changed rdj to rdlj, added new rdj
*	04/01/83	mas		added DATA read
*	06/16/83	mas		squeeze memory and speed
*	09/08/83	waf		** Re-write -
*					Combine and optimize code.
*					Chk for error and ikey on read() calls.
*	10/05/83	waf		Use ioerr() fn for read() error chk.
*	10/31/83	waf		gread() fix - getndata()/getadata() based on flag. 
*	02/21/84	waf		New ioerr() functionality - must handle return.
*					Added code to abort on errors.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

02/21/84	waf
  See ioerr() in bberr.c for a discussion of ikey's during char i/o.
  Note that, if i/o from or to a char device is ikey'ed, the results of the i/o
are undefined. In particular, the string data may be corrupted (but the len
parameters will not be).

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"


static	int	skipflag ;		/* if set, skip rest of Basic statement */



rdset (channel)
int	channel;
{
	register int	i;
	int	fd;

	/* chk channel */
	if ( (i = xlt2bchan(channel, &fd)) != 16 ) {

		/* chk file permission & status */
		if ( i == 1 )
			bberr(BEWRM); 				/* write-only mode */
		if ( (ust.ftab[channel].opmode & EOF_FS) != 0 )
			bberr(EREOF);				/* error to read past EOF */
		}

	lastfileno = channel;			/* save channel of last i/o */

	/* reset skip flag */
	skipflag = 0 ;

	}


		/**  Read numeric  **/

rdl (valaddr)		/* read type l value */
long	*valaddr;
{
	gread(valaddr,NUMERIC,4);
	}

rdj (valaddr)		/* read type j value */
int	*valaddr;
{
	gread(valaddr,NUMERIC,2);
	}

rdlj (valaddr)		/* read type j value & sign extend to type l */
long	*valaddr;
{
	int	  ival;

	gread(&ival,NUMERIC,2);			/* read as 2 bytes */
	*valaddr = (long) ival;			/* convert to 4 bytes */
	}


		/**  Read String  **/

rda ( strdes )
STRDES	strdes;
{
	gread( &strdes, STRING, 0 );	/* use dummy count */
	}


static	gread ( dptr, flag, num )		/** Generic read function **/

char	*dptr;		/* # data buffer / $ data desc */
int		flag;		/* type of data */
int		num;		/* # bytes to read */
{
	register int	n;
	register STRDES	*sdptr;
	struct frec *ftr;
	char   buf[8];


	/* chk skip flag */
	if ( skipflag )
		return ;	/* skipping rest of statement */

	/* chk Data read */
	if (lastfileno == 16) {
		if ( flag == STRING )
			getadata( dptr );
		else
			getndata( dptr,(num==2)? 0:1 );
		return;
		}

	/* set up for file read */
	ftr = &ust.ftab[lastfileno];			/* get pointer for last file */
	if ((ftr->opmode & EOF_FS) != 0)
		return;		/* prev. arg hit EOF, skip rest of args in arg list */

	/* do it */
	if ( flag == STRING ) {

		/** read string data **/
		sdptr = (STRDES *)dptr ;	/* dptr is ptr to str desc */
		if ( sdptr->maxlth != 0 ) {		/* if dst str not already full */
			do {						/* read the file */
				n = read(ftr->xfd, sdptr->data, sdptr->maxlth);
				sdptr->maxlth -= n;
				sdptr->data  += n;
				} 
				while (n > 0 && sdptr->maxlth != 0);	/* until done */
			/* If no error, update parent str */
			if ( n >= 0 )
				updcl(sdptr);
			}
		}
	else {

		/** read numeric data **/
		n = read(ftr->xfd, buf, num);
		/* If no error, update nvar */
		if ( n > 0 )
			swab( buf, dptr, num );		/* swap bytes to BB format */
		}

	/* Chk read results */
	if ( n == 0 ) {

		/* end of file */
		ftr->opmode |= EOF_FS;			/* set EOF */
		}

	else if ( n < 0 ) {
	
		/* read error */
		ioerr() ;		/* report error / chk for EINTR */
		skipflag = -1 ; /* EINTR error - skip rest of statement */
		}

	}
