/*************************************************************************
*
*
*	Name:  pdefine.h
*
*	Description:  Global defines for the bbasic p-machine
*
*
*	History:
*	Date		By		Comments
*
*	02/01/83	mas
*	07/15/83	waf		Added target system definition and system dependent
*					definitions.
*	09/09/83	waf		Added MAXFD to define max # files open simultaneously.
*	09/13/83	waf		Increment MAXFD to 50 files (for cdbc sys).
*	09/30/83	waf		Added movs() and movw() macros.
*	10/04/83	waf		Added type flags.
*	10/25/83	waf		Changed MAXFD to SYSCHANS and added BBCHANS.
*					Note - # of file table entries extended to 32.
*	10/28/83	waf		Added chkchan(), chkfchan(), & chanloop() macros.
*	11/16/83	waf		Added LCKTBLSIZ.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

09/30/83	waf
  movs() and movw() macros invoke blkmovb() & blkmovw(), respectively.
  This may need to be changed to allow checking for data area overlap (blkmov
  functions do not check for overlap of the two data buffer areas).


.SH*/


/**  Define target system environment  **/

#define	BB_X86	 1
			/* Xenix operating system running on an 8086 CPU.
				This is the original system, designed for the Altos. */

#define	BB_PC	0
			/* IBM Personal Computer (or equiv), running MSDOS. */

			/* Note - no distintion made between 8086 & 8088 cpu's. */


#define	CDBC	1
			/* Version specially configured for Control Data */




/**  Define system constants & parameters  **/

#define  TRUE		1
#define  FALSE		0
#define  IOSIZE 	133		/* I/O Line buffer size   */
#define  TERMSIZE 256		/* terminal output buffer */
#define  INFINITY 32767		/* infinite length for strings */
#define  PATHSIZE 128		/* maximum pathname of a file */
#define  PRMAXLEVEL 9		/* maximum nesting of () in print-using */
#define  MAXDEPTH 10		/* link depth limit */
#define  LFT_NOLOCK 1		/* no-LOCK flag in LFTABL$ */
#define  LFT_EOPEN  2		/* exclusive-OPEN flag in LFTABL$ */

#define	 BBCHANS	32		/* Maximum legal BB channel number.
						This allows BBCHANS file channels + 1 console channel.
						Thus, the legal channel #'s are 0 - BBCHAN,
						with '16' defined as the console */

#define  JOBMAX 	200		/* maximum number of "jobs" allowed */
#define  IDLE 		(-1)	/* inactive job flag */
#define	 LCKTBLSIZ	32		/* # entries in lock table */

/* Define file open modes */
#define  RD_FM		00400		/* file open in read mode */
#define  WR_FM		01000		/* file open in write mode */
#define  RW_FM   	01400		/* file open in read/write mode */
#define  EX_FM		02000		/* file open in exclusive mode */
#define  SH_FM		04000		/* file open in shared mode */
#define  SEQ_FM		010000		/* sequential file mode (no position allowed) */
#define  CHAR_FM	020000  	/* character i/o only, eg. pipes */

#define  EOF_FS	0100000	/* EOF file status this channel */


/** Define system specific constants **/

#if	BB_X86				/* define const's specific to BB on Xenix */
#define  SYSCHANS	50	/* Max # files open simultaneously */
#endif

#if	BB_PC					/* define const's specific to BB on the PC */
#define  MDNOERR	0		/* 'No error' flag returned from MSDOS sys calls */
#define  SYSCHANS	??
#endif


/** Define variable types **/
#define  typeUNDF (-1)
#define  typeJ	0
#define  typeL	1
#define  typeX	2
#define  typeA	3


/** Define global 'abbreviations' **/
#define  iofl iostat.iou.iof
#define  iost iostat.iou
#define  stxfl stmtx.stxf
#define  stxst stmtx

/** Define 'type flags'.
	Note - Always compare against the '0' flag for efficient code. **/
#define	STRING		0
#define	NUMERIC		1


/*** Define global macros ***/


/* chk if ptr points to variable */
#define  isvar(p)		(((p)->ndata.j==(int *)0)?FALSE:TRUE)


/* loop forever */
#define  forever		for(;;)


/* move/fill string/word data */
#define  movs(S,D,L)	blkmovb(S,D,L)
#define  movw(S,D,L)	blkmovw(S,D,L)
#define  fills(D,C,V)	blkfilb(D,C,V)
#define  fillw(D,C,V)	blkfilw(D,C,V)


/* Chk for legal BB channel number.
These macros should be used inside 'if' stmts. */
#define	badchan(C)		(unsigned)C > BBCHANS
	/* when console (16) is legal */
#define badfchan(C)		(unsigned)C > BBCHANS || C == 16
	/* when console (16) is not legal */

/* Loop through channel table, using index into table. */
#define	chanloop(I)		for ( I=0 ; I <= BBCHANS ; I++ )
	/* NOTE - include
		if ( I == 16 )
			continue;
	to skip console channel, if necessary. */
