/*************************************************************************
*
*
*	Name:  debshow.c
*
*	Description:  Debugger - display subroutines.
*
*
*	History:
*	Date		By		Comments
*
*	4/29/83		waf	
*	5/04/83		waf		numstr() - show unsigned decimal vals.
*	5/04/83		waf		showchar() - chk ranges.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> Files in showstats().


.SH */
#include	"debug.h"
#include	"/bb/include/opcodes.h"


showbase ( )

/* show current base */
{

	switch ( base )
		{
	case 8:	
		printf( "(oct)" );
		break;
	case 10:	
		printf( "(dec)" );
		break;
	case 16:	
		printf( "(hex)" );
		}
	}



showchar ( c )

/* show a character */

char	c;			/* char to be shown */
{
	int	u;

	putchar( '\'' );
	u = (int) c & 0x7f ;
	if ( u > 0 && u < 27 ) {
		/* control char */
		putchar( '^' );
		putchar( u + 64 );
		}
	else if ( u >= 32 && u < 97 )
		putchar( (char) u );
	putchar( '\'' );
	}


showptrs ( )

/*  show ptrs & file info  */
{

#define	showfstat( H, F, V )	printf( "  %25.s %5.s = ", H,\
	( ( F == pmfd )? "(.pm)" : "(.bp)") ); \
		showlnum( V ); \
		putchar( '\n' );

#define	showstat( H, V )	printf( "  %25.s = ", H );\
		shownum( V ); \
		putchar( '\n' );

	printf( "\n/* file ptrs */\n" );
	showstat( ".pm file desc.", pmfd );
	showstat( ".bp file desc.", bpfd );
	showfstat( "header start", pmfd, headfp );
	showfstat( "pcode start", pmfd, pcdfp );
	if ( ltfd != -1 )
	    showfstat( "line table start", ltfd, ltfp );
	showfstat( "global frame start", pmfd, gffp );
	showfstat( "eval stk start", pmfd, estkfp );
	showfstat( "ust start", pmfd, ustfp );
	if ( stfd != -1 )
	    showfstat( "symtbl start", stfd, symfp );

	printf( "\n/* memory ptrs */\n" );
	showstat( "memory starting addr", pmhead.begmem );
	showstat( "pcode base addr", pcodbase );
	showstat( "global frame base addr", gfbase );
	showstat( "pc", pmhead.pc.B );
	showstat( "gfp", pmhead.gfp.B );
	showstat( "sp", pmhead.sp.B );

	printf( "\n/* other stats */\n" );
	showstat( "pcode size", pmhead.codsiz );
	showstat( "eval stk size", pmhead.stksiz );
	}
/* 
.SH */


showoa ( os )

/* given offset, show offset and addr */

int	os;
{
	int	adr;

	adr = os_adr( os );
	printf( "  offset = %6.s   address = %6.s\n",
	numstr( os ), numstr( adr ) );
	}


showao ( adr )

/* given addr, show offset and addr */

unsigned	adr;
{
	int	os;

	if ( adr <= 32767 ) {
		os = adr_os( adr );
		printf( "  offset = %6.s   address = %6.s\n",
		numstr( os ), numstr( adr ) );
		}
	else
		printf( "  address = %6.s\n", numstr( adr ) );
	}


/* 
.SH */


showso ( os )

/* Given offset, show stmt# and offset */

int	os;
{
	lshwso( 0, os );
	}


showlo ( ltptr, os )

/* version of showso() for line table dump. */

int	ltptr, os;
{
	lshwso( -1, ltptr );
	}



lshwso( flag, val )

int	flag, val;

{
	int	stmt;
	int	os;

	if ( flag < 0 ) {
		os = linetbl[val].pcoffset ;		/* val is line table index */
		stmt = lt_stmt( val );	/* get stmt# for this lt entry */
		}
	else {
		os = val ;		/* val is offset */
		stmt = os_stmt( val );		/* get stmt# for this offset */
		}

	if ( stmt == 32767 )
	    printf( "  %-7.s", "<end>" );
	else
		printf( "  %-7.s", stmtstr );

	printf( "%7.s", numstr(os) );

	/* show break point info */
	if ( flag < 0 ) {
		if ( getpcode(os) == BREAK )
		    printf( "   <B" );	/* flag break point set */
		if ( stmt == curstmt && os == curos )
		    printf( "   <BP" );		/* flag current stmt */
		}

	putchar( '\n' );
	}


sohead ()

/* show header for stmt# & offset display */

{

	printf( "  stmt#      os\n" );
	}

/* 
.SH */

char	*numstr( val )

/* return $ which is 'val' in current base */

int	val;
{
	return( nstr( 0, (long) val ) );
	}

char	*lnumstr( val )

/* version of numstr() for long values */

long	val;
{
	return( nstr( 0, val ) );
	}


nstr( flag, val )

int	flag;		/* 0 = int / 1 = long */
long	val;
{
	int	ix;
	char	*ptr;

	/* inc str buffer ptr */
	nstrptr++ ;
	if ( nstrptr >= nstrents )  nstrptr = 0 ;
	ix = nstrptr * nstrsiz ;
	ptr = &numstrbuf[ix] ;		/* next buffer slot */

	/* put str of value in buffer */
	switch ( base ) {
		case 8:
			if ( flag == 0 )
				sprintf( ptr, "%o_", (int) val );
			else
				sprintf( ptr, "%O_", val );
			break;
		case 10:
			if ( flag == 0 )
				sprintf( ptr, "%u_", (int) val );
			else
				sprintf( ptr, "%U_", val );
			break;
		case 16:
			if ( flag == 0 )
				sprintf( ptr, "%x_", (int) val );
			else
				sprintf( ptr, "%X_", val );
			break;
		}

	return( ptr );
	}



shownum ( n )

/* show type int number in current base */

int	n;
{

	printf( "%5s", numstr( n ) );
	}



showlnum ( n )

/* show type long number in current base */

long	n;
{

	printf( "%5s", lnumstr( n ) );
	}

