/*************************************************************************
*
*
*	Name:		lex.c
*
*	Description:	Lexical scanner
*
*	History:
*	Date		By	Comments
*
*	11/10/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "stdio.h"
#include "tokens.h"
#include "symbols.h"

char	*symptr;

struct kwtab {
   char *kwname;
   int  kwval;
} kwtab[];

/* Scan input and return token and symbol and value
*/
gettoken()
{
   int c, i;

   symptr = &symbol[0];
LOOP:
   c = toupper(geti());
   if (c == ' ' || c == '\t') goto LOOP;
   *symptr++ = c; symlen = 1;
   if (isletter(c)) {
      get_ident();
      if (token == TGO) {
	 gettoken();
	 if (token == TTO) token = TGOTO;
	 else if (token == TSUB) token = TGOSUB;
	 else token = BADCH;
      } else if (token == TEND) {
	 gettoken();
	 if (token == TIF) token = TENDIF;
	 else if (token == EOLN) {
	    token = TEND;
	 } else token = BADCH;
      }
   } else if (isdigit(c)) get_num(c);
   else if (i = cindex("><=",c)) get_relop(i);
   else if (c == '"') get_slit();
   else if (c == '%') get_ident();
   else if (i = cindex("+-*/^()[]@;,\\",c)) {
      token = i-1+PLUS;
   } else if (c == '\n' || c == ':') {
      ungeti(c);
      token = EOLN;
   } else
      token = BADCH;
   *symptr = '\0';
   if (token != NUMLIT) value = symlen;
/*
   printf("%8d%8ld  %s\n",token,value,symbol);
*/
   return(token);
}

get_ident()
{
   int c;
   char *p1, *p2;
   struct kwtab *kp;

   while (isletter(c=toupper(geti())) || isdigit(c)) {
      *symptr++ = c; symlen++;
   }
   if (c == '$') {
      *symptr++ = c; symlen++;
      token = STRVAR;
      symtype = SSTRING;
   } else if (c == '%') {
      *symptr++ = c; symlen++;
      token = NUMVAR;
      symtype = SSINGLE;
   } else {
      ungeti(c);
      token = NUMVAR;
      symtype = SDEFAULT;
      if (symlen == 1) symtype = SLETTER;
      else if (symlen == 3 && strncmp(symbol,"FN",2)==0) {
	 token = FNCNAM;
	 symtype = symbol[2] - 'A';
      }
   }
   *symptr = '\0';
   for (kp=kwtab ; (p2 = kp->kwname); kp++) {
      p1 = symbol;
      while (*p1 == *p2++)
	 if (*p1++ == '\0') {
	    token = kp->kwval;
	    return;
	 }
   }
}

get_num(c)
int c;
{
   value = c-'0';
   while (isdigit(c=geti())) {
      value = value*10 + c-'0';
      *symptr++ = c; symlen++;
   }
   ungeti(c);
   token = NUMLIT;
}

get_relop(i)
int i;
{
   int c, j;
   c = geti();
   if (j = cindex("><=",c)) {
      *symptr++ = c; symlen++;
      i += j*3;
   } else {
      ungeti(c);
   }
   switch (i) {
case 1:
      token = GREATER;
      break;
case 2:
      token = LESS;
      break;
case 3:
      token = EQUALS;
      break;
case 5:
case 7:
      token = NOTEQ;
      break;
case 6:
case 10:
      token = GTREQ;
      break;
case 9:
case 11:
      token = LESSEQ;
      break;
default:
      token = BADCH;
      break;
   }
}

get_slit()
{
   int c, svlen, value;
   char *svptr=0;

   symptr--; symlen--;
   while ((c=geti()) != '"' && c != '\n') {
      if (svptr != 0) {
	 if (c == '>') {
	    if (value != -1) {
	       symptr = svptr;
	       symlen = svlen;
	       c = value;
	    }
	    svptr = 0;
	 } else if (isdigit(c)) {
	    if (value == -1) value = 0;
	    value = value*10 + c - '0';
	    if (value > 255) svptr = 0;
	 } else {
	    svptr = 0;
	 }
      }
      if (c == '<') {
	 svptr = symptr;
	 svlen = symlen;
	 value = -1;
      }
      *symptr++ = c; symlen++;
   }
   if (c != '"') ungeti(c);
   token=STRLIT;
}

get_rlit()
{
   int c;

   symptr = &symbol[0]; symlen = 0;
   while ((c=geti()) == ' ');
   while (c != '\n') {
      *symptr++ = c; symlen++; c = geti();
   }
   ungeti(c);
   token = STRLIT;
}

/* Return relative offset of charater c in string s or zero
*/
cindex(s,c)
char *s, c;
{
   int i;
   
   for (i=1 ; *s != '\0' ; i++) 
      if (*s++ == c) return(i);
   return (0);
}

toupper(c)
int c;
{
   if (c >= 'a' && c <= 'z') {
      return (c-'a'+'A'); 
   } else {
      return (c);
   }
}

isletter(c)
int c;
{
   return (c >= 'A' && c <= 'Z');
}

isdigit(c)
int c;
{
   return (c >= '0' && c <= '9') ; 
}
