/*************************************************************************
*
*
*	Name:		labels.c
*
*	Description:	Label manipulation routines
*
*	History:
*	Date		By	Comments
*
*	11/30/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "stdio.h"
#include "opcodes.h"
unsigned pcoffset;

struct LABEL {
   unsigned lpc;
   unsigned lval;
   int ltype;
} label[3000];

struct PATCH {
   unsigned ppc;
   unsigned pval;
   int ptype;
} patch[2000];

struct ENTEXT {
   unsigned epc;
   unsigned eval;
   int etype;
} entext[500];

struct LABEL *nxtlabel;
struct PATCH *nxtpatch;
struct ENTEXT *nxtentext;

#define lmask	000377
#define labs    000000
#define limp	000001
#define lrem	000002
#define ldata	000003
#define lrform	000004
#define lbase	004000
#define lentry	010000
#define lextrn	020000
#define ldef	040000

unsigned pc, nolabpc;
char pcname[];
FILE *pcout;
int	gswp, gswz;
extern	errcnt;

initlabel()
{
   nxtlabel = &label[0];
   nxtpatch = &patch[0];
   nxtentext = &entext[0];
}

makelabel(stmtno,stype)
int stmtno, stype;
{
   nxtlabel->lpc = pc;
   nxtlabel->lval = stmtno;
   nxtlabel->ltype = stype;
   if (nxtlabel++ >= &label[3000]) panic("More than 3000 statements");
}

addlabel(l)
struct LABEL *l;
{
   if (gswz) printf("Add label:  %6d  %6d  %6o\n",l->lpc,l->lval,l->ltype);
   *nxtlabel++ = *l;
   if (nxtlabel >= &label[3000]) panic("More than 3000 statements");
}

addpatch(p)
struct PATCH *p;
{
   if (gswz) printf("Add patch:  %6d  %6d  %6o\n",p->ppc,p->pval,p->ptype);
   *nxtpatch++ = *p;
   if (nxtpatch >= &patch[2000]) panic("More than 2000 backpatchs");
}

addentext(e)
struct ENTEXT *e;
{
   if (gswz) printf("Add entext:  %6d  %6d  %6o\n",e->epc,e->eval,e->etype);
   *nxtentext++ = *e;
   if (nxtentext >= &entext[500]) panic("More than 500 entry/externals");
}

jmppatch(spc,dpc)
unsigned spc, dpc;
{
   struct PATCH p;
   p.ptype = labs | ldef;
   p.ppc = spc;
   p.pval = dpc-spc;
   addpatch(&p);
}

labref(op,value,type)
int op, value, type;
{
   struct PATCH p;
   p.ptype = type;
   p.pval = value;
   p.ppc = genJMP(op,-1);
   addpatch(&p);
}
 
resolve()
{
   int found;
   unsigned npc;
   struct LABEL *l;
   struct PATCH *p;
   struct ENTEXT *e;

   for (p = &patch; p < nxtpatch; p++) {
      if ((p->ptype & ldef) == 0) {
	 found = 0;
	 for (l = &label; l < nxtlabel; l++)
	    if ((p->pval == l->lval) && ((l->ltype & lbase) == 0)) {
	       found = 1;
	       break;
	    }
	 if (found == 0) 
	    for (l = &entext; l < nxtentext; l++) {
	       if (p->pval == l->lval) {
		  if ((l->ltype & lmask) == labs)
		     l->ltype |= p->ptype & lmask;
		  found = 1;
		  break;
	       }
	    }
	 if (found != 0) {
	    if ((p->ptype & lentry) != 0)
	       p->ptype |= (l->ltype & lmask);
	    switch (p->ptype & lmask) {
	    case lrem:
	    case limp:
	       if ((l->ltype & (lextrn | lentry)) != 0) {
		  if (((l->ltype & lmask) != limp) && ((l->ltype & lmask) != lrem)) {
		     fprintf(stderr,"Entry/external statement %d may not be branched to.\n",l->lval);
		     errcnt++;
		  }
	       }
	       npc = l->lpc;
	       break;
	    case lrform:
	       if ((l->ltype & (lextrn | lentry)) == 0)
		  if ((l->ltype & lmask) == lrform) 
		     npc = l->lpc+4;
		  else {
		     fprintf(stderr,"Referenced statement %d is not an RFORM statement.\n",l->lval);
		     errcnt++;
		  }
	       else {
		  if ((l->ltype & lmask) == lrform) 
		     npc = l->lpc;
		  else {
		     fprintf(stderr,"Entry/external statement %d is not an RFORM statement.\n",l->lval);
		     errcnt++;
		  }
	       }
	       break;
	    case ldata:
	       if ((l->ltype & (lextrn | lentry)) == 0) {
		  found = 0;
		  for (;l < nxtlabel; l++)
		     if ((l->ltype & lmask) == ldata) {
			found = 1;
			break;
		     }
		  if (found != 0)
		     npc = l->lpc+4;
		  else {
		     fprintf(stderr,"Referenced statement %d is not a DATA statement.\n",l->lval);
		     errcnt++;
		  }
	       } else {
		  if ((l->ltype & lmask) == ldata)
		     npc = l->lpc;
		  else {
		     fprintf(stderr,"Entry/external statement %d is not a DATA statement.\n",l->lval);
		     errcnt++;
		  }
	       }
	       break;
	    default:
	       synerr("Unknown statement resolution");
	       fprintf(stderr,"Referenced statement %d is messed up.\n",l->lval);
	       errcnt++;
	       break;
	    }
	    p->pval = npc - p->ppc;
	    p->ptype |= ldef;
	 } else {
	    fprintf(stderr,"Referenced label %d not found.\n",p->pval);
	    errcnt++;
	 }
      } /* end if */
      if ((p->ptype & ldef) != 0) {
	 if (gswz) printf("Patch:  %6d  %6d  %6o\n",p->ppc,p->pval,p->ptype);
	 fseek(pcout,(long) p->ppc - pcoffset + 512,0);
	 fwrite(&p->pval,sizeof (int),1,pcout);
      }
   } /* end for */
   if (errcnt != 0 && !gswp) unlink(pcname);
}

dumpext()
{
   struct LABEL *l;
   struct ENTEXT *e;

   for (e = &entext[0]; e < nxtentext; e++) {
      if ((e->etype & lextrn) != 0) {
	 e->epc = pc;
	 genJMP(JMP,6);
      } else if ((e->etype & lentry) != 0) {
	 for (l = &label; l < nxtlabel; l++) {
	    if (e->eval == l->lval)
	       e->etype |= (l->ltype & lmask);
	 }
      }
   }
}

dumpent()
{
   struct ENTEXT *e;

   for (e = &entext[0]; e < nxtentext; e++) {
      if ((e->etype & lextrn) != 0) {
	 labref(JMP,e->eval,e->etype);
      }
   }
}
