/*************************************************************************
*
*
*   Name:  chkpath.c
*
*   Description:  does search of current directory, then /bb/syslib
*   	      then use BBPATH in environ for further searching
*
*
*   History:
*   Date		By	Comments
*
*   12/08/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */



/*  Notes -

*/


static char *bbpath;

chkpath(name1,name2)
char   *name1, *name2;
{
   char	buf[128], name3[128], *cptr;
   register int i,e;

/* Remove leading # or % */
   if (*name1 == '#' || *name1 == '%') name1++;

/* Add ".bp" if not already there */
   strcpy(name3,name1);
   if (rindex(name3,'.') == 0)
      strcat(name3,".bp");
   strcpy(name2,name3);

/* try current directory */
   if (access(name2,0) == 0)
   	return(0);

/* try /bb/syslib directory */
   strcpy(name2,"/bb/syslib/");
   strcat(name2,name3);
   if (access(name2,0) == 0)
   	return(0);
   
/* try BBPATH */
   bbpath = getenv("BBPATH");
   if (bbpath == (char *)0 || strlen(bbpath) == 0) {
   	strcpy(name2,name3);
   	return(0);
   }

   strncpy(buf,bbpath,128);

   for(i=0; buf[i] == ':'; ++i)
   	;

   for(; i < 128; ++i) {
   	cptr = &buf[i];
   	for (; buf[i] != ':' && buf[i] != '\0' && i < 128; ++i) 
   		;
   	buf[i] = '\0';
   	strcpy(name2,cptr); /* put in dir name */
   	strcat(name2,"/");
   	strcat(name2,name3);
   	if (access(name2,0) == 0)
   		return(0);
   }

   strcpy(name2,name3);

   return(0);
}
