: "
  CDC-114 XENIX R1.0

  10/8/82
  
  dial-in will add or delete dial in ports.

"
:                    disable XENIX interrupt signal
trap "continue" 2

clear.sh
echo -n "
ADD/DELETE DIAL-IN PORTS

Add or delete dial-in ports (a or d)? "
read flag

:                    exit if it is not a or d
if test "$flag" != "a" -a "$flag" != "d"
       then
            echo -n "
Dial-in port will not be added/deleted. 
Press NEW LINE or RETURN to continue. "
            read nline
            exit
fi
echo -n "
Enter port number (2, 3, 4, 5, 6, 7 or 8)? "
read port

:                    exit if port number is not between 1 and 8
if test "$port" -gt "8" -o "$port" -lt "2"
       then
            echo -n "
Port number should between 2 and 8.
Dial-in port will not be added/deleted.
Press NEW LINE or RETURN to continue. "
            read nline
            exit
fi


:                    add dial-in port ... update /etc/ttys and /etc/con.file
if test "$flag" = "a"
       then
:                    check if port is serial printer port before change to dial_in
            junk=`sed -n -e "/02tty$port/p" /etc/ttys`
            if test -z "$junk"
            then
                 : okay
           else
                echo -n "Port $port is a serial printer port.
You have to delete the serial printer before add dial-in on port $port.
Press NEW LINE or RETURN to continue. "
                read nl
                exit
            fi


:                    check if port is spooled device port
            sed -n -e "/lp/p" /etc/con.file |awk 'BEGIN {FS=":"}
{print $1 >"templp"}'
            spool_lp=`cat templp`
            rm templp
            if test "$spool_lp" = "$port"
            then
                 echo -n "
Spooling device is on port $port.
You have to delete the spooling device before add dial-in on port $port.
Press NEW LINE or RETURN to continue. "
                 read nl
                 exit
            fi
            sed -e "s/[012][012]tty$port/10tty$port/" /etc/ttys >tempttys
            ed /etc/con.file >/dev/null <<!
/tty$port/
c
$port:tty$port (dial-in)::110-1200
.
w
q
!
            mv tempttys /etc/ttys
            kill -2 1
            echo -n "
Dial-in port $port is added.
Press NEW LINE or RETURN to continue. "
            read nline
            exit
       else

:                    delete dial-in port ... update /etc/ttys and /etc/con.file
            if test "$flag" = "d"
            then

:                    check if port is dial-in port before delete
                 junk=`sed -n -e "/10tty$port/p" /etc/ttys`
                 if test -z "$junk"
                 then
                      echo -n "
Port $port is not a dial-in port. 
Dial-in port is not deleted.
Press NEW LINE or RETURN to continue. "
                      read nline
                      exit
                 fi
                 sed -e "s/10tty$port/12tty$port/" /etc/ttys >tempttys
                 ed /etc/con.file >/dev/null <<!
/tty$port/
c
$port:tty$port:CDC722:9600
.
w
q
!
                 mv tempttys /etc/ttys
                 kill -2 1
                 echo -n "
Dial-in port is deleted. 
Press NEW LINE or RETURN to continue. "
                 read nline
                 exit
            fi
fi
