h44476
s 00009/00002/00105
d D 1.2 84/11/09 06:01:52 dock 2 1
c added ifdeffing for AUTOP and MODTAB
e
s 00107/00000/00000
d D 1.1 84/11/01 22:37:37 dock 1 0
c date and time created 84/11/01 22:37:37 by dock
e
u
U
t
T
I 1
/* monaddr.c -- C source to create RAMmonaddr.m
 * copyright (c) 1984  American Information Systems Corporation
 *
 *	Daniel Steinberg
 *	July, 1984
 *
 *	This file is compiled to produce assembly language output that
 *	is editted (thru abs.sed) to become RAMmonaddr.m in which the
 *	initialized values below are turned into assembler .set directives.
 *	RAMmonaddr.m is included by all .S files that reference the Absolute-
 *	Addressed RAM area.  For example:
 *
 *		Makesym(defmod)
 *
 *	will generate:
 *
 *			.align 4
 *		_A_defmod:
 *			.double 256
 *
 *	which will be converted by abs.sed into:
 *
 *		.setn	A_defmod,256
 *
 *	NOTE:
 *	Non-fatal warnings will be generated by the c-compiler when symbols
 *	for array locations are compiled.
 */

#include "monflags.h"

/* Define macros to make symbol definitions */

#define Makesym(x) unsigned A_/**/x = (unsigned)&x;
#define Makeval(x,v) unsigned A_/**/x = (unsigned)(v);


/* Define symbols for the low-memory RAM */
Makeval(zeroramstart,ZERORAMSTART)
Makeval(zramend,ZRAMEND)
Makeval(zeroramend,ZERORAMEND)
Makeval(zeroramsize,ZERORAMEND-ZERORAMSTART)
Makeval(zeroramgrains,(ZERORAMEND-ZERORAMSTART)/GRAIN)


/* Locate all Absolute-Addressed RAM symbols in monflags.h */

unsigned A_state = (unsigned)&intmod + MOD_SB;	/* Interrupt Dispatch State */

Makesym(emergency)		/* Emergency Register Dump */
Makesym(defmod)			/* Default Module Table Entry */
Makesym(intmod)			/* Interrupt Module Table Entry */
Makesym(mondispatch)		/* Monitor Trap Dispatch Table */
Makesym(viosdispatch)		/* VIOS Trap Dispatch Table */
Makesym(oskdispatch)		/* OS Kernel Trap Dispatch Table */
Makesym(osudispatch)		/* OS User Trap Dispatch Table */

Makesym(membitmap)		/* Memory Bitmap */
Makesym(reset_addr)		/* address of soft reset code */
Makesym(memsize)		/* #bytes of good RAM */
Makesym(cataddr)		/* current catch frame address */
Makesym(lasthrown)		/* last thrown error */

Makesym(brktab)			/* breakpoint table */
I 2

#ifdef AUTOP
E 2
Makesym(autobuf)		/* auto-print buffer */
I 2
Makesym(autoptr)		/* pointer to auto-print buffer */
#endif

E 2
Makesym(symtab)			/* symbol table */

Makesym(tmpclrbr)		/* last cleared breakpoint */
Makesym(tempbrk)		/* Address for temporary breakpoint */
D 2
Makesym(autoptr)		/* pointer to auto-print buffer */
E 2
Makesym(symstart)		/* address of 1st symbol table entry */

Makesym(cflags)	       		/* control flags for debugger */
Makesym(stepcnt)		/* Single Step count */
Makesym(procnt)			/* Proceed count */
Makesym(svbrka)			/* Saved break address */
Makesym(savpsr)			/* Global ptr to saved psr */
Makesym(instr_len)		/* Length of instruction at dot */
Makesym(curaddr)		/* current address */
Makesym(curbase)		/* current output base */
Makesym(cursize)		/* current output size */

Makesym(debug_user_state)	/* TRUE: monitor traps User-State bpt */
Makesym(initflag)		/* TRUE: RAM-Monitor initialized */

Makesym(acontext)		/* size(b,w,d) of displayed object */
Makesym(ibuf)
I 2

#ifdef MODTAB
E 2
Makesym(lastmod)		/* last module (for error checking) */
D 2
Makesym(firsthex)
E 2
I 2
#endif

E 2
Makesym(opcxpd)
Makesym(context)
Makesym(instr)
Makesym(istart)
Makesym(ilen)
Makesym(mapping)
Makesym(inbuf)
Makesym(lastinp)
Makesym(lastcmd)

#ifdef DEBUG_MONITOR /************ Monitor Debugging *************************/
Makesym(debug_monstack)		/* debug stack */
Makesym(recursive)		/* Recursive trap flag */
#endif /* DEBUG_MONITOR ********** Monitor Debugging *************************/

Makesym(monstack)		/* RAM-Monitor stack */
Makesym(viosstack)		/* VIOS stack */

E 1
