/*  vios3200.h -- Header file for AIS NS-32032 VIOS compilations
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef VIOS3200
#define VIOS3200


#define WORDSIZE 32	/* Number of bits in a word */

#define UARTSTR "tty"		/* Device name string for on-board uarts */
#define UARTSTRL 3		/* uart string length */

#define HOSTMEM "hostmem"	/* Device name string for host memory */
#define HOSTMEML 7		/* Host memory string length */

/* Define special routines */
#define brkvios(a)	asm(BPT)
#define errpri(a,b)	printf(a,b)

#ifdef DEBUG_ERROR_MSGS /******************************************************/
#define error(a,b)	{printf(a,b); brkvios();}
#else  /* DEBUG_ERROR_MSGS ****************************************************/
#define error(a,b)	{brkvios();}
#endif /* DEBUG_ERROR_MSGS ****************************************************/

#define DIS_INTS   if (!(Intstate) && (Intdepth++ == 0))  dis_ints()
#define ENA_INTS   if (!(Intstate) && (Intdepth != 0) && (--Intdepth == 0)) \
			ena_ints()

#define ints_disabled()	(NOT ints_enabled())


/* Define AIS run-time extension routines */
extern int catch();		/* Catch thrown errors */
extern int uncatch();		/* Exit a catch block */
extern int throw();		/* Throw an error */
extern int rethrow();		/* Rethrow the most recent error */

#endif
