/*  handlers.h -- Declare VIOS external i/o request handlers
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef HANDLERS
#define HANDLERS

#include "viostypes.h"


/* Define the PKT_STATE values */

/* Packets on Vqueue: */
#define NEW_STATE	 0	/* I/O packet not yet initiated */
#define VIO_RUN_STATE	 1	/* processing Virtual I/O request */
#define DONE_STATE	 2	/* I/O done -- completion not done yet */

#define VIO_REQUEUED	 3	/* I/O packet already requeued */


/* Packets on Wqueue: */
#define VIO_WAIT_STATE	-1	/* return to VIO handler when IOCOUNT <- 0 */
#define DONE_WAIT_STATE	-2	/* process I/O completion when IOCOUNT<- 0 */
#define ALL_WAIT_STATE	-3	/* return to VIO handler when pool is freed */
#define CNT_WAIT_STATE	-4	/* return to VIO when IOCOUNT-- */
#define SYS_WAIT_STATE	-5	/* VIO waiting for Hyper_exec */
#define COMP_WAIT_STATE	-6	/* continue when IO_Completion goes TRUE */
#define	TMO_WAIT_STATE	-7	/* continue when timeout goes to zero */
#define	TICK_WAIT_STATE	-8	/* continue on the next clock interrupt */

    /* VIOS<->Host Wait States */
#define HCNCT_WAIT_STATE -16	/* proceed when host is connected */
#define HCMD_WAIT_STATE  -17	/* proceed when host can accept a cmd */
#define HACK_WAIT_STATE  -18	/* proceed when host acknowledges a cmd */
#define HSTAT_WAIT_STATE -19	/* proceed when host returns status */
#define HLCK_WAIT_STATE  -20	/* proceed when host data-page is locked */
#define HRSRC_WAIT_STATE -21	/* proceed when host resource available */


/* Packets on Pqueue: */
#define PIO_WAIT_STATE	-32	/* VIO waiting for device to be available */
#define PINP_WAIT_STATE	-33	/* VIO waiting for device input to be free */
#define POUT_WAIT_STATE	-34	/* VIO waiting for device output to be free */


/* Declare handler and configuration routines */
/* aisdispat.c */
extern PKT_STATE ais_dispatcher();	/* On-board device dispatcher */

/* aistty.c */				/* On-board UART Terminal Driver */
extern PKT_STATE tty_dispatcher();	/* UART device dispatcher */
extern PKT_STATE tty_create();
extern PKT_STATE tty_remove();
extern PKT_STATE tty_read();
extern PKT_STATE tty_write();
extern PKT_STATE tty_control();

/* auxhandlr.c */
extern PKT_STATE aux_handler();		/* Dispatch AUX_FUNCTION requests */
extern PKT_STATE timer_handler();	/* Set one-shot and periodic timers */

/* blkaddr.c */
extern PKT_STATE blka_dispatcher();	/* Dispatch class-dependent routines */

/* bufaddr.c */
extern PKT_STATE bufa_dispatcher();	/* Dispatch class-dependent routines */

/* clock.c */
extern PKT_STATE tick_handler();	/* Clock dispatcher */
extern PKT_STATE sec_handler();		/* Second wakeup ctr */
extern PKT_STATE min_handler();		/* Minute wakeup ctr */

/* devhandlr.c */
extern PKT_STATE vdevice_handler();	/* Device control for virtual devices */
extern PKT_STATE pdevice_handler();	/* Device ctrl for physical devices */

/* hostmem.c */				/* Host Memory Driver */
extern PKT_STATE hmem_dispatcher();	/* Host memory dispatcher */
extern PKT_STATE hmem_create();
extern PKT_STATE hmem_read();
extern PKT_STATE hmem_write();

/* hstdispat.c */
extern PKT_STATE host_dispatcher();	/* Host device dispatcher */

/* hstdriver.c */
extern PKT_STATE host_create();
extern PKT_STATE host_remove();
extern PKT_STATE host_read();
extern PKT_STATE host_write();
extern PKT_STATE host_control();

/* infhandlr.c */
extern PKT_STATE vinfo_handler();	/* Information request processing */
extern PKT_STATE dev_information();	/* Device information processing */

/* inihandlr.c */
extern PKT_STATE init_request();	/* Initial request processing */

/* pcthandlr.c */
extern PKT_STATE pctrl_handler();	/* Physical device control */
extern PKT_STATE pcre_handler();	/* Create physicl device */
extern PKT_STATE prem_handler();	/* Remove physical device */

/* rdwrtsubs.c */
extern PKT_STATE q2device();		/* queue i/o packet to device */
extern PKT_STATE v2p_output();		/* convert virtual output to physical */
extern PKT_STATE v2p_input();		/* convert virtual input to physical */
extern PKT_STATE done_handler();	/* finish i/o requests */

/* recseq.c */
extern PKT_STATE recs_dispatcher();	/* Dispatch class-dependent routines */

/* vcthandlr.c */
extern PKT_STATE vctrl_handler();	/* VIOS control request handler */
extern PKT_STATE cre_handler();		/* Create Virtual Device handler */
extern PKT_STATE rem_handler();		/* Remove Virtual Device handler */
extern PKT_STATE ass_handler();		/* Assign Virtual Device units */

/* vrdhandlr.c */
extern PKT_STATE vrd_handler();		/* VIOS Read request handler */
extern PKT_STATE vrdcomp_handler();	/* VIOS Read Completion handler */
extern PKT_STATE rdbuf_handler();	/* Buffered read completion */

/* vwthandlr.c */
extern PKT_STATE vwrt_handler();	/* VIOS Write request handler */

/* vioinit.c */
extern IMP_MODULE **i_imp();		/* init implementation modules */
extern CLASS_MODULE **i_cm();		/* init class handling modules */
extern OSD_PTR i_os();			/* init operating system descriptors */

#endif
