/* pregs.c -- display registers of cpu, mmu, icu, fpu
 * copyright (c) 1984  American Information Systems Corporation
 *	Dock Williams
 *	December, 1984
 *
 */

#include "monitor.h"
#include "3200config.h"



rcpu()
{
    register int t;

#define C(x) (env->x)
 
    printf("      r0       r1       r2       r3       r4       r5       r6       r7\n%8x %8x %8x %8x %8x %8x %8x %8x\n",
	C(r0), C(r1), C(r2), C(r3), C(r4), C(r5), C(r6), C(r7));


    printf("      pc       fp      sp1      sp0       sb  intbase      mod psr\n%8x %8x %8x %8x %8x %8x     %4x %4x",
	C(pc), C(fp), C(sp1), C(sp0), C(sb), C(intbase), C(mod), t = C(psr));


    OUTCHR('(');
    if (t & PSR_I) OUTCHR('I');
    if (t & PSR_P) OUTCHR('P');
    if (t & PSR_S) OUTCHR('S');
    if (t & PSR_U) OUTCHR('U');
    if (t & PSR_N) OUTCHR('N');
    if (t & PSR_Z) OUTCHR('Z');
    if (t & PSR_F) OUTCHR('F');
    if (t & PSR_L) OUTCHR('L');
    if (t & PSR_T) OUTCHR('T');
    if (t & PSR_C) OUTCHR('C');
    printf(")\n");
}



rmmu()
{
#ifdef MMU /********************** MMU Available ***********************/
    register int t;

#define M(x) (env->mmu.x)

    printf("MSR:  %8x  ( ", t = env->msr);
    if(t & MSR_NT) printf("NT ");
    if(t & MSR_UT) printf("UT ");
    if(t & MSR_FT) printf("FT ");
    if(t & MSR_UB) printf("UB ");
    if(t & MSR_BEN) printf("BEN ");
    if(t & MSR_BN) printf("BN ");
    if(t & MSR_BD) printf("BD ");
    if(t & MSR_ED) printf("ED ");
    if(t & MSR_TU) printf("TU ");
    if(t & MSR_TS) printf("TS ");
    if(t & MSR_DS) printf("DS ");
    if(t & MSR_AO) printf("AO ");
    OUTCHR(')');

    printf(" EST=%x BST=%x\n",(t>>10)&0x07,(t>>13)&0x07);


    printf("PTB0: %8x   PTB1: %8x   EIA:  %8x\nBCNT: %8x   BPR0: %8x   BPR1: %8x\n",
	M(ptb0), M(ptb1), M(eia), M(bcnt), M(bpr0), M(bpr1));


    printf("SC0:  %4x   PF0:  %8x   SC1:  %4x   PF1:  %8x\n",
	M(sc) & 0x0000ffff, M(pf0), (M(sc) >> 16) & 0x0000ffff, M(pf1));

#endif /************************** MMU Available ***********************/
}



rfpu()
{
#ifdef FPU /********************** FPU Available ***********************/
    register int t;

#define F(x) (env->fpu.x)

    printf("FSR:  %8x  (", t = F(fsr));
    if(t &0x08) printf(" UEN ");
    if(t &0x10) printf(" UF ");
    if(t &0x20) printf(" IEN ");
    if(t &0x40) printf(" IF ");
    printf(")  TT=%1d  RM=%1d\n",(t & 0x07),(t & 0x018)>>7 );

    printf("      f0       f1       f2       f3       f4       f5       f6       f7\n%8x %8x %8x %8x %8x %8x %8x %8x\n",
	F(f0), F(f1), F(f2), F(f3), F(f4), F(f5), F(f6), F(f7));

#endif /************************** FPU Available ***********************/
}
