h27568
s 00018/00010/00205
d D 1.5 85/06/03 18:23:38 dock 5 4
c allowed more than one temporary breakpoint 
c printing of breakpoint name added
e
s 00003/00000/00212
d D 1.4 85/02/13 00:30:25 dock 4 3
c 
e
s 00001/00002/00211
d D 1.3 84/11/30 22:17:24 dock 3 2
c used bzero to clear autoprint buffer
e
s 00035/00324/00178
d D 1.2 84/11/09 05:45:36 dock 2 1
c took a lot of code out and produced cmdproc.c
e
s 00502/00000/00000
d D 1.1 84/11/01 22:38:02 dock 1 0
c date and time created 84/11/01 22:38:02 by dock
e
u
U
t
T
I 1
D 5
/* rammonitor.c -- main routine for dispatching of monitor commands
E 5
I 5

/*
 * %M%: version %I% of %H%
 *
 * main routine for entry and initialization of monitor
E 5
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  October, 1984
 *
 */

#define DEFINITIONS
#include "monitor.h"

#include "3200config.h"



rammonitor (envptr)
    INTSTACK *envptr;		/* pointer to saved environment on stack */
/*
 * rammonitor (envptr) -- main routine for monitor
 *	return:	(int)		cflags
 *
 * check all incoming status
 * return quietly in the correct cases
 * otherwise, enter debugging mode and
 * wait for commands
 * 9/4/83	dgw	created
 */
{
D 2
    register int	argc;		/* argument count for command */
    register char	cmd;		/* current monitor command */
E 2
    register struct initsym *p;		/* pointer to initsym */
D 2
    register char	*cp;		/* character pointer */
    register int	i;		/* temporary counter */
    int	val;				/* value for a symbol */
    int arg0,arg1,arg2,arg3;		/* converted argument values */

E 2
I 2
    register int i;			/* temporary counter */
E 2
    char	input[MAXINP];		/* input character buffer */
D 2
    char	*argv[MAXARG];		/* argument vectors */
E 2
I 2
    char cmd;				/* current monitor command */
    int arg0;				/* converted argument values */
E 2

    env = envptr;			/* make environment ptr global */
    savpsr = (short*) (&env->psr);	/* point to saved psr */

D 2
    if ((env->id == MON_INIT) || (initflag == 0))	/* startup init */
	{
E 2
I 2
    if ((env->id == MON_INIT) || (initflag == 0)) {	/* startup init */

E 2
 	/* clear counts and flags */
D 5
	ibuf = (char *)0;
D 2
	acontext = curaddr = cflags = stepcnt = procnt = 0 ;
E 2
I 2
	acontext = 0;
E 5
	curaddr = 0;
	cflags = 0;
	stepcnt = 0;
	procnt = 0 ;
E 2
	curbase = 'x';
	cursize = 4;

	clrbrk(0,'*');			/* clear breakpoint table */
I 2
	init_sym();			/* clear symbol table */

#ifdef AUTOP
E 2
D 3
	for(i=0;i<MAXINP;i++)		/* clear autoprint buffer */
	    autobuf[i] = '\0';
E 3
I 3
	bzero(autobuf,MAXINP);		/* clear autoprint buffer */
E 3
	autoptr = autobuf;		/* initialize autoprint pointer */
I 2
#endif

#ifdef MODTAB
E 2
	lastmod = (unsigned)ZERORAMEND;	/* size of mod table for disasm */
I 2
	asym("lastmod", &os_loadbase, S_HIDE|S_PHYS);
#endif
E 2

D 2
	init_sym();			/* clear symbol table */
E 2

	/* add default defined symbols */
	asym("_etext", &etext, S_HIDE|S_PHYS);
	asym("_edata", &edata, S_HIDE|S_PHYS);
	asym("icu", INTCTLR, S_HIDE|S_PHYS);
	asym("rtc", TODCLK, S_HIDE|S_PHYS);
	asym("rom", ROMSTART, S_HIDE|S_PHYS);
D 2
	/* asym("lastmod", &os_loadbase, S_HIDE|S_PHYS); */
E 2
	asym("bitmap", membitmap, S_HIDE|S_PHYS);
	asym("reset", reset_addr, S_HIDE|S_PHYS);

	initflag = -1;		/* initialization done but no copyright */

	if (env->id == MON_INIT)	/* if init only */
D 2
	    return;				/* return from initialization */
	} /*if-MON_INIT*/
E 2
I 2
	    return;			/* return from initialization */
    } /*if-MON_INIT*/
E 2

    if (env->id >= 0) brkinit();	/* take out all breakpoints */
D 2
    if (initflag <= 0)	/* Monitor initialized, but no copyright yet */
	{
	initflag = 1;	/* do this exactly once */
	prdname(0);		/* print startup message */
	}
E 2
I 2
    if (initflag <= 0) {	/* Monitor initialized, but no copyright yet */
	initflag = 1;			/* do this exactly once */
	prdname(0);			/* print startup message */
    }
E 2

    switch (env->id) {
    case 0: printf("nvi"); break;
    case 1: 
	if(cflags & CF_MMUBRK) {
	    if(env->msr & MSR_ERC2) printf("mmu-brk ");
	} else printf("nmi"); break;
    case 2: printf("abt"); break;
    case 3: printf("fpu"); break;
    case 4: printf("ill"); break;
    case 5: printf("svc"); break;
    case 6: printf("dvz"); break;
    case 7: printf("flg"); break;
I 2

E 2
    case 8: 
D 5
	if ( procnt && visbrkset(env->pc) ) {
E 5
I 5
	if ( procnt && visbrkset(env->pc, B_NORM) ) {
E 5
#ifdef DEBUG1
	    printf(" procnt=%x\n",procnt);
#endif
D 5
	    clrbrk(env->pc,'t');	/* clear brkpnt temporarily */
E 5
I 5
	    clrbrk(env->pc,B_REPL);	/* clear brkpnt temporarily */
E 5
	    svbrka = (char *)env->pc;	/* save breakpoint address */
	    cflags |= (CF_BRKPRO | CF_BRKREP);	/* signify we are proceeding */
	    procnt--;			/* proceed and replace breakpnt */

	    /* if we are proceeding we can't be single stepping */
	    /* so its ok to write stepcnt */
	    stepcnt = 1;		/* step past breakpoint */
	    env->psr |= PSR_T;		/* set trace bit in psr */
	    return;			/* now 'step around' the breakpoint */
	}
D 5
	if(stepcnt > 1) printf("stepcnt=%x   ",stepcnt);
	if(tempbrk == env->pc) {
	    clrbrk(env->pc,'s');
E 5
I 5
	if (stepcnt > 1) printf("stepcnt=%x   ",stepcnt);
	if ( visbrkset(env->pc, B_TEMP) ) {
		/* if the second argument is not a ascii digit or B_REPL */
		/* the breakpoint is really cleared, as in this case */
		clrbrk(env->pc,'s');	
E 5
	}
	printf("bpt");
	break;
I 2

E 2
    case 9:				 /* single step entry id */
	stepcnt--;
	if(cflags & CF_BRKREP) {
D 5
		vsetbrk(svbrka);		/* we have replaced the brk */
E 5
I 5
		vsetbrk(svbrka, "", B_NORM);/* we have replaced the brk */
E 5
		cflags &= ~CF_BRKREP;	/* check if we should proceed */
		if(cflags & CF_BRKPRO) {
		    env->psr &= ~PSR_T;	/* reset the trace bit in the psr */
		    return;		/* since we have stepped through */
		}			/* the breakpoint now */
	}
I 5
	if ( visbrkset(env->pc, B_TEMP) ) {
	    clrbrk(env->pc,'s');
	}
E 5
	if(stepcnt > 0) {
#ifdef DEBUG1
	    printf("stepcnt=%x\n",stepcnt);
#endif
	    env->psr |= PSR_T;		/* set the trace bit in the psr */
	    return;
	}
	printf("trc");
	break;
I 2

E 2
    case 10: printf("und"); break;
I 2

E 2
    case 11: printf("(reserved)"); break;

    case MON_START:		/* direct startup */
	break;

    default:
	if ( (env->id < 16) || (env->id > 31) )
	    printf("RAM-Monitor entry: %x\n", env->id);
	else
	    printf("bad int vector: %d.\n", (env->id - 16));
	break;
    }

    if (env->id >= 0) {
	printf(": %6x   ",env->pc);
D 5
	vdisasm(env->pc, &arg0, 1);	/* display instruction */
E 5
I 5
	arg0 = vdisasm(env->pc, 1);	/* display instruction */
	prbrkname(env->pc);
E 5
	OUTCHR('\n');
    }

#ifdef DEBUG1
    printf("Adding stack symbols:\n");
#endif

    asym("r0",&env->r0, S_HIDE|S_SHIDE|S_PHYS);
    asym("r1",&env->r1, S_HIDE|S_SHIDE|S_PHYS);
    asym("r2",&env->r2, S_HIDE|S_SHIDE|S_PHYS);
    asym("r3",&env->r3, S_HIDE|S_SHIDE|S_PHYS);
    asym("r4",&env->r4, S_HIDE|S_SHIDE|S_PHYS);
    asym("r5",&env->r5, S_HIDE|S_SHIDE|S_PHYS);
    asym("r6",&env->r6, S_HIDE|S_SHIDE|S_PHYS);
    asym("r7",&env->r7, S_HIDE|S_SHIDE|S_PHYS);
    asym("sb",&env->sb, S_HIDE|S_SHIDE|S_PHYS);
    asym("intbase",&env->intbase, S_HIDE|S_SHIDE|S_PHYS);
    asym("sp1",&env->sp1, S_HIDE|S_SHIDE|S_PHYS);
    asym("sp0",&env->sp0, S_HIDE|S_SHIDE|S_PHYS);
    asym("sp",&env->sp0, S_HIDE|S_SHIDE|S_PHYS);
    asym("fp",&env->fp, S_HIDE|S_SHIDE|S_PHYS);
    asym("psr",&env->psr, S_HIDE|S_SHIDE|S_PHYS);
    asym("ps",&env->psr, S_HIDE|S_SHIDE|S_PHYS);
    asym("mod",&env->mod, S_HIDE|S_SHIDE|S_PHYS);
    asym("pc",&env->pc, S_HIDE|S_SHIDE|S_PHYS);
    asym("id",&env->id, S_HIDE|S_PHYS);

    for(;;){
	cflags &= ~CF_ESCHIT;

#ifdef DEBUG_MONITOR /******** DEBUG_MONITOR ***************************/
	if(recursive) OUTCHR('D');
#endif /********************** DEBUG_MONITOR ***************************/

	printf("M> ");			/* print prompt */
I 2

E 2
	cmd = getinput(input,MAXINP,0);	/* get input from console */

I 4
	if (mapping == 0)
		mapping = (cflags & CF_PHYS) ? PHYS : getmap();

E 4
D 2
	 /* if this is not an autoprint string call mkargv */
	 /* otherwise pass a raw string for autoprinting */
	if (*input != ';')  
	    argc = mkargv(input,argv);	/* count arguments */
					/* form vectors  */
E 2
I 2
	if ( cmdproc( cmd, input ) )	/* execute a monitor command */
		return;			/* go execute a program */
E 2

D 2
	switch(cmd) {
	case '\0':			/* exceptional cases? */
	    continue;
	case '#':			/* delete a symbol */
	    dsym(argv[0]);
	    continue;
	case '+':			/* add a symbol */
	    if ( !conv(argv[1],&val) ) continue;
	    asym(argv[0],val,0);	/* don't hide it */
	    continue;
	case '$':			/* change open base */
	    switch (*argv[0]) {
		case 'd':
		case 'o':
		case 'x':
		case 'h':
		case 'c':
		case 'u':
		    curbase = *argv[0];
		    break;
		default:
		    goto argcerr;
	    }
	    OUTCHR('\n');
	    continue;
	case '/':			/* display and change double */
	case '\\':			/* display and change word */
	case '\`':			/* display and change byte */
	    setcursize(cmd);
	    open(argv);
	    continue;
	case '=':
		if (argc != 1) goto argcerr;
		else {
		    if( !conv(argv[0],&val) ) continue;
		    dprint(&val, curbase, cursize);
		    OUTCHR('\n');
		}
		continue;
	case '?':			/* print command synopsis */
	    if (argc > 1) synop(argv);
	    else {
		argv[0][0]= '?';
		argv[0][1] = '\0';
		synop(argv);
	    }
	    continue;
	case 'a':
	    if (*input == ';') {	/* set autoprint string */
		for(i=1;(input[i] != ';') && (i<MAXINP);i++)
		    autobuf[i-1] = input[i];
		autobuf[i-1] = '\0';
		autoptr = &autobuf[i-1];
		cflags |= CF_AUTOP;
	    } else if (argc==1) {	/* print current autoprint string */
		for(i=0; autobuf[i] != '\0'; i++) prtsee(autobuf[i]);
		OUTCHR('\n');
	    } else if (argc==2) {
		if (*argv[0] == 'e') autoptr = autobuf;
	    } else goto argcerr;
	    continue;
	case 'b':			/* breakpoints */
	    brkpnt(argc,argv);
	    continue;
	case 'c':			/* compare blocks of memory */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) compare(arg0,arg1,arg2);
	    continue;
	case 'd':			/* display chunks */
	    if (argc != 3) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) ) display(arg0,arg1);
	    continue;
	case 'e':			/* enable bits in cflags */
	    cp = argv[0];
	    while(*cp) {
		switch (*cp++) {
		case 'u': debug_user_state = '\001';break;
		case 'p': cflags |= CF_PHYS;break;
		case 's': cflags |= CF_SYMP;break;
		case 'h': cflags |= CF_PHIDE;break;
		case 'm': cflags |= CF_MMUBRK;break;
		case 'a': 
		    for(i=0;(i<MAXINP && autobuf[i] != '\0');i++);
		    autoptr = &autobuf[i];
		    cflags |= CF_AUTOP;
		    break;
		case '-':
		    while(*cp) {
			switch (*cp++) {	
			case 'u': debug_user_state = '\0';break;
			case 'p': cflags &= ~CF_PHYS;break;
			case 's': cflags &= ~CF_SYMP;break;
			case 'h': cflags &= ~CF_PHIDE;break;
			case 't': cflags &= ~CF_TRACE;break;
			case 'a': cflags &= ~CF_AUTOP; break;
			case 'm': cflags &= ~CF_MMUBRK;break;
			case '*': cflags = 0;break;
			}
		    }
		}
	    }
	    continue;
	case 'g':			/* go */
	    if(argc == 1) {
#ifdef DEBUG1
		printf("current pc = %x",env->pc);
#endif
	    } else {
		if ( !conv(argv[0],&env->pc) ) continue;
#ifdef DEBUG1
		printf("new pc = %x",env->pc);
#endif
	    }
	    env->psr &= ~(PSR_I | PSR_P);	/* reset pending trace & ints */
	    env->msr = 0;		/* disable mapping */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
	    	cflags |= (CF_BRKREP | CF_BRKPRO);  /* replace and proceed */
		env->psr |= PSR_T;
		stepcnt = 1;
	    } else env->psr &= ~PSR_T;
	    if (vmembyte(env->pc) == BRKCODE) env->pc++;
	    cflags &= ~CF_SSTEP;	/* reset single step flag */
	    stepcnt = procnt = 0;
	    return;
	case 'l':			/* list symbols */
	    if (argc != 2) goto argcerr;
	    else lsym(argv[0]);
	    continue;
	case 'm':			/* move a block of memory */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) move(arg0,arg1,arg2);
	    continue;
	case 'i':			/* image loader */
	    dload();
	    continue;
	case 'p':			/* proceed through breakpoints */
	    if(argc > 2) goto argcerr;
	    env->psr &= ~PSR_P;		/* reset trace trap pending */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
	    	cflags |= (CF_BRKREP | CF_BRKPRO);  /* replace and proceed */
		env->psr |= PSR_T;
		stepcnt = 1;
	    } else env->psr &= ~PSR_T;	
	    if (vmembyte(env->pc) == BRKCODE) env->pc++;
	    cflags &= ~CF_SSTEP;	/* reset single step flag */
	    if (argc == 1) {	
		procnt = 0;
		return;
	    } else if (argc == 2) {
		if ( !conv(argv[0],&procnt) ) continue;
		return;	
	    } else goto argcerr;
	case 'x':
	    ramless_monitor();
	    continue;
	case 'r':			/* print registers */
	    if(argc == 1) rcpu();
	    else if (argc == 2) 
		switch(*argv[0]) {
		case 'c':	rcpu(); break;
		case 'm':	rmmu(); break;
		case 'f':	rfpu(); break;
		default:	break;
		}
	    continue;
	case 's':
	case ',':			/* single step */
	case '<':			/* step over calls */
	    if(argc>2) goto argcerr;
	    cflags |= CF_SSTEP;		/* set single step flag */
	    if(visbrkset(env->pc)) {	/* check for a breakpoint */
		svbrka = (char *)env->pc;	/* set at the current address */
		clrbrk(env->pc,'t');	/* step around it, if there */
		cflags |= CF_BRKREP;	/* replace breakpoint */
		cflags &= ~CF_BRKPRO;	/* but dont proceed */
	    }

	    if (vmembyte(env->pc) == BRKCODE) env->pc++;

	    if (    (vmembyte(env->pc) == CXPCODE)
		 || (vmembyte(env->pc) == BSRCODE)
		 || ((vmembyte(env->pc) == JSRCODE)
		     && ((vmembyte((env->pc)+1) & 0x07) == JSR2CODE) )
	       && (cmd == '<') ) {
			vdisasm(env->pc, &val, 0);
			tempbrk = env->pc + val;
			printf("<.."); 
			if (visbrkset(env->pc)) {
				env->psr |= PSR_T;
				cflags |= CF_BRKPRO;
				stepcnt = 1;
			} 
			if (visbrkset(tempbrk)) {
				tempbrk = 0;
			} else 
				vsetbrk(tempbrk);
			env->psr &= ~(PSR_P|PSR_T);
			return;
	    } else {
		env->psr |= PSR_T;	/* set the trace bit in the psr */
		if(cmd == '<') printf("<.");
		if (argc == 1) {
		    stepcnt = 1;
		    return;
		} else {
		    if ( !conv(argv[0], &stepcnt) ) continue;
		    return;
		} 
	    }
	case 'u':
	    if( (argc < 2) || (argc > 3) ) goto argcerr;
	    if( !conv(argv[0],&arg0) ) goto argcerr;
	    arg1 = 2;			/* default count to unassemble */
	    if(argc == 3) {
		if( !conv(argv[1],&arg1) ) goto argcerr;
	    } 
	    for(i=0;i<arg1;i++) {
	    psym(arg0);
	    disasm(arg0,&arg2,1);
	    arg0 += arg2;
	    OUTCHR('\n');
	    if(quitchk()) break;
	    }
	    continue;
	case 'f':		/* fill a block of memory with a constant */
	    if (argc != 4) goto argcerr;
	    if ( conv(argv[0],&arg0) &&
		 conv(argv[1],&arg1) &&
		 conv(argv[2],&arg2) ) fill(arg0,arg1,arg2);
	    continue;
	case 'j':
	    if(argc < 2) goto argcerr;
	    brkexec();			/* write breakpnts for execution */
	    if ( conv(argv[0],&arg0) ) {	/* must supply an address */
		conv(argv[1],&arg1);
		conv(argv[2],&arg2);
		conv(argv[3],&arg3);
	    	xcall(arg0,arg1,arg2,arg3);
	    }
	    continue;
	case 'z':		/* write a location of memory */
		if (argc != 4) goto argcerr;
		if ((conv(argv[0],&arg0)) &&
		    (conv(argv[1],&arg1))) {
			switch(*argv[2]) {
			case 'b': arg2 = 1; break;
			case 'w': arg2 = 2; break;
			case 'd': arg2 = 4; break;
			}
			zap(arg0,arg1,arg2);
		}
	    continue;
	default:
	    printf("unknown cmd\n");
	    continue;
	}
	argcerr:
	    printf("arg count?\n");
E 2
    }
}

D 2

E 2

D 2
getmap ()
E 2

D 2
/* getmap () -- Return a code corresponding to the target task's mapping
 *
 *	return:	PHYS		task was running physical
 *		V_SUPER		task was using PTB0
 *		V_USER		task was using PTB1
 */
{
	if (*savpsr & PSR_U)	/* if task was running at user mode */
		{
		if (env->msr & MSR_TU)	/* if translation enabled */
			{
			if (env->msr & MSR_DS)		/* if dual space */
				return(T_USER);		/* user mapping */
			else
				return(T_SUPER);	/* user / super */
			}
		}
	else			/* if task was at supervisor mode */
		{
		if (env->msr & MSR_TS)	/* if translation enabled */
			return(T_SUPER);
		}
	return(PHYS);		/* no translation enabled */
}




E 2
exec_init()
{
    brkexec();
I 2

#ifdef AUTOP
E 2
    if (cflags & CF_AUTOP) autoptr = autobuf;
D 2
}
E 2
I 2
#endif
E 2

D 2

E 2
I 2
}
E 2
E 1
