               JOB  Fortran compiler -- Dimension phase one -- 09
               CTL  6611
     *
     * A table of arrays is generated at the end of storage.
     * Each table element consists of the array name, its
     * dimensions and sufficient space for control statements
     * and data generated by the equivalence phases and by
     * dimension phase two.
     *
     * Dimension table elements are separated by group mark word mark.
     * At the top of each element is the array name, spelt backward.
     * Below that are two cells used to double link the elements.
     * The upper one points to the next one higher in core (unless
     * it's blank); the lower one points to the next one lower in
     * core (unless it's blank).  Below that are empty three character
     * and five character fields.  Below that are the dimensions, with
     * the first dimension at the higher address.  The digits of the
     * dimensions are not reversed.
     *
     * 81-83 = start (top address) of first (top in memory)
     * statement.  Remember, statements are sorted by type now,
     * and pushed to the bottom of available core.
     *
     * On exit, 84-86 is the address of the topmost (first)
     * dimension table.
     *
     x1        equ  89
     x2        equ  94
     x3        equ  99
     *
     * Stuff in the resident area
     *
     phasid    equ  110  Phase ID, for snapshot dumps
     glober    equ  184  Global error flag -- WM means error
     snapsh    equ  333  Core dump snapshot
     topcor    equ  688  Top core address from PARAM card
     imod      equ  690  Integer modulus -- number of digits
     mantis    equ  692  Floating point mantissa digits
     loadnx    equ  700  Load next overlay
     clearl    equ  707  CS at start of overlay loader
     cdovly    equ  769  Read (1) instruction if running from cards
     tpread    equ  780  Tape read instruction in overlay loader
     loadxx    equ  793  Exit from overlay loader
     clrbot    equ  833  Bottom of core to clear in overlay loader
     *
     110       dcw  @dimen 1@
     094       dcw  000
     096       dc   00
     099       dcw  000
     100       dc   0
     *
               ORG  838
     loaddd    equ  *&1          Load address
  838diff      DCW  @0@   WM if FP width /= integer width
  839beginn    SW   gm
  843          MCW  83,x1         Top of top (first) statement
  850          A    kb1,mantis    Get rid of zones in mantis
  857          MCW  mantis,manp2
  864          A    kp2,manp2     mantis + 2 = total FP width
  871          C    imod,manp2    FP width == integer width?
  878          BU   difwid
  883          CW   diff
  887difwid    LCA  gm,1&X1       Set GMWM above statement
  894          LCA  topcor,x2     x2 = topcor
  901          MN   0&X2
  905          MN
  906          MCW  kb1a
  910          SBR  x2            x2 = topcor - 3
  914prev      MCW  kb1,1-0       clobber previous less-than sign
  921          MCW  kless,2&X1    stmt top + 2 = less-than sign
  928          NOP  2&X1
  932          SAR  prev&6        Remember where we put it
  936          LCA  0&X1,prefix
  943          SAR  x1            Point X1
  947          SBR  x3              and X3 after label
  951          BCE  done,prefix,     No more statements?
  959          BCE  find,prefix-3,I  Dimension statement?
  967          BCE  end,prefix-3,/   End statement?
  975          B    done
     *
     * Skip over the array name -- must end with left paren
     *
  979find      BCE  lparen,0&X1,%
  987          BCE  syntax,0&X1,,
  995          BCE  syntax,0&X1,)
 1003          BCE  syntax,0&X1,}
 1011          SBR  x1
 1015          B    find
     *
     * Found the left paren
     *
 1019lparen    SW   lpflag
 1023          MN   0&X1       Get below
 1027          SAR  x1           left paren
 1031          SW   2&X1       Set word mark at bottom of symbol
 1035          MCW  x2,savx2
 1042          BW   first,firstf
     *
     * Check whether symbol is in the table.  X2 is at bottom
     * of the bottom symbol entry.
     *
 1050check     MCM  1&X2
 1054          SAR  x2
 1058          BCE  first,0&X2,  Top of the table?
 1066higher    MCM  2&X2       Move up to next element
 1070          MN
 1071          MN
 1072          SBR  x2         Top of element (maybe)
 1076          BCE  higher,1&X2,|  Need to move up more if RM
 1084compar    C    0&X2,0&X3  Same as already in table?
 1091          SAR  x2
 1095          BU   check
 1100          BW   double,1&X2
 1108          B    check
 1112first     MCW  savx2,x2
 1119          LCA  gm,0&X2    Mark top of element
 1126          LCA  0&X3       Symbol to element
 1130          LCA  newx3      chain
 1134          SBR  x2         below chain in element
 1138          MCW  newx3,x3
 1145          BCE  head,x3,
 1153          B    nohead
 1157head      A    kb1,x3     Convert blank x3 to zeroes
 1164nohead    LCA  k3b,0&X2   Put two three-character
 1171          LCA  k3b          fields into symbol table
 1175          SBR  6&X3       Link prev element to this one
 1179          SBR  newx3
 1183          LCA  k5b        Add five spaces to element
 1187          SBR  x2           and get x2 below it
 1191nother    MN   dimsav-4   Make x3&2
 1195          MN                be the high-order
 1196          SAR  x3             digit of dimsav
 1200          SBR  x1,0&X1    Strange kind of nop?
     *
     * Accumulate characters of dimension
     *
 1207more      MCW  0&X1,char  Get character from dimension field
 1214          SAR  x1           and step down to next one
 1218          BCE  dimfin,char,)
 1226          BCE  dimfin,char,}
 1234          BCE  dimfin,char,,
 1242          MCW  char,2&X3  Store char in dimension save
 1249          SBR  x3
 1253          B    more
 1257dimfin    BCE  syntax,1&X1,}
 1265          LCA  1&X3,0&X2  Move dimension to symbol table
 1272          SBR  x2
 1276          BCE  nother,1&X1,,  Get another dimension
 1284          MCW  prev&6,x3
 1291          BCE  notbig,0&X3,<
 1299          B    toobig
 1303notbig    CW   firstf  Clear first-time flag
 1307tstfin    BCE  fini,0&X1,}  Finished
 1315          B                   with statement?
 1316          BCE  newvar,0&X1,,  Another variable?
 1324          B    syntax
 1328newvar    MN   0&X1       Get below comma
 1332          SAR  x1
 1336          SBR  x3
 1340          B    find         and go find end of next variable
     *
     * Finished with dimension statement
     *
 1344fini      C    0&X1
 1348          SAR  x1
 1352          B    prev
     *
     * Doubly defined array
     *
 1356double    CS   332
 1360          CS
 1361          SW   glober
 1365          MCW  error2,230
 1372          MCW  compar&6,x2
 1379          MN   232
 1383          MN
 1384          SAR  x2
 1388          SBR  x3,0&X3
 1395morech    MCW  0&X3,ch
 1402          SAR  x3
 1406          MCW  ch,2&X2
 1413          SBR  x2
 1417          BW   donech,1&X3   At the end of the variable name?
 1425          B    morech
 1429donech    W
 1430          BCV  ovfl
 1435          B    noovfl
 1439ovfl      CC   1
 1441noovfl    BCE  bottom,0&X1,)  Bottom of statement?
 1449          SBR  x1
 1453          BCE  syntax,1&X1,}
 1461          B    noovfl
 1465bottom    MN   0&X1
 1469          SAR  x1
 1473          MCW  savx2,x2
 1480          B    tstfin
     *
     * Dimension syntax error
     *
 1484syntax    CS   332
 1488          CS
 1489          SW   glober
 1493          MN   prefix,241
 1500          MN
 1501          MN
 1502          MCW  error3
 1506          W
 1507          BCV  ovfl2
 1512          B    novl2
 1516ovfl2     CC   1
 1518novl2     MCW  savx2,x2
 1525          BCE  prev,1&X1,}
 1533end       C    0&X1
 1537          SAR  x1
 1541          B    prev
     *
 1545done      BW   gotlp,lpflag
 1553          LCA  gm,0&X2
 1560          LCA  colon
 1564          LCA  w3
 1568          LCA  w3
 1572          LCA  w3
 1576          LCA  w5
 1580          LCA  w10
 1584          SBR  x2
 1588gotlp     NOP  2&X1
 1592          MCM
 1593          MCW
 1594          SAR  x1
 1598          MCW  6,86           Topmost table entry address to 86
 1605          BSS  snapsh,C
 1610          SBR  tpread&6,839   Load address for next overlay
 1617          SBR  clrbot           and clear bottom
 1621          SBR  loadxx&3,1034  Exit from loader
 1628          SBR  clearl&3,1845  Clear top
 1635          LCA  equiv,phasid
 1642          B    loadnx
     *
     * Program is too big
     *
 1646toobig    CS   332
 1650          CS
 1651          CC   1
 1653          MCW  msg2,270
 1660          W
 1661          CC   1
 1663          BCE  halt,cdovly,1
 1671          RWD  1
 1676halt      H    halt
     *
     * Data
     *
 1690prefix    DCW  @0          @
 1691gm        dc   @}@
 1694newx3     DCW  #3
 1699dimsav    dcw  #5
 1700lpflag    DC   #1   WM in low-order character if left paren
 1701kb1       DCW  #1
 1703manp2     DCW  #2   mantis + 2
 1704kp2       dcw  &2
 1705kb1a      DCW  #1
 1706kless     DCW  @<@
 1709savx2     DCW  #3
 1710firstf    DCW  #1   WM is first-time flag
 1713k3b       DCW  #3
 1718k5b       DCW  #5
 1719char      DCW  #1   Character from dimension field
 1749error2    DCW  @ERROR 2 - DOUBLY DEFINED ARRAY@
 1750ch        DCW  #1
 1788error3    DCW  @ERROR 3 - DIMENSION SYNTAX, STATEMENT @
 1789colon     DCW  @:@
 1792w3        DCW  #3
 1797w5        DCW  #5
 1799w10       dcw  10
 1808equiv     DCW  @EQUIV ONE@
 1844msg2      DCW  @MESSAGE 2 - OBJECT PROGRAM TOO LARGE@
 1845gmwm      DCW  @}@
               org  201
  203          dsa  loaddd    load address for card-to-tape program
               ex   beginn
               END
