               JOB  Fortran compiler -- Equivalence phase one -- 10
               CTL  6611
     *
     * 1. Assure all arrays present in EQUIVALENCE statements are
     *    defined
     * 2. Add simple variables present in EQUIVALENCE statements
     *    to the table of arrays generated by the previous phase.
     *    These variables are treated, in effect, as one-element
     *    arrays.
     *
     * On entry, 81-83 = start (top address) of first (top in memory)
     * statement (remember, statements are sorted by type now, and
     * pushed to the bottom of available core), 84-86 = address of the
     * topmost (first) dimension table (eleven below the bottom of the
     * name), x1 = address of the last digit of the sequence number of
     * the first (topmost) unprocessed statement, x2 = address of the
     * lowest-address character of the array table, and x3 = address
     * of the first (topmost) character of the x1 statement (first
     * character after keyword and left paren if not arithmetic). 6&x2
     * is the "next" link and 9&x2 is the "previous" link in each
     * array table element.  Blank means "end of chain".
     *
     * Each element of the array table has one or two variable-width
     * dimension fields (first dimension higher in core), with the
     * digits of the dimensions not reversed, a five digit offset from
     * the base of the equivalence class (x2 points at the low-order
     * digit), a three-character link to the next member of the
     * equivalence class, a three-character link to the next element,
     * a three-character link to the previous element, the name
     * (variable width), and a group mark with a word mark.  The GMWM
     * of the topmost element is at topcor-3, and topcor-2 .. topcor
     * are blank.
     *
     x1        equ  89
     x2        equ  94
     x3        equ  99
     *
     * Stuff in the resident area
     *
     phasid    equ  110  Phase ID, for snapshot dumps
     snapsh    equ  333  Core dump snapshot
     loadnx    equ  700  Load next overlay
     clearl    equ  707  CS at start of overlay loader
     cdovly    equ  769  Read (1) instruction if running from cards
     tpread    equ  780  Tape read instruction in overlay loader
     loadxx    equ  793  Exit from overlay loader
     clrbot    equ  833  Bottom of core to clear in overlay loader
     *
     * From dimension one phase
     *
     diff      equ  838  WM if FP width /= integer width
     *
     * In equivalence two phase
     *
     done2     equ  1735
     notin2    equ  1800
     *
     110       dcw  @equiv one@
     099       dcw  000
     100       dc   0
     *
               ORG  839
     loaddd    equ  *&1          Load address
  839gm        DC   @}@
  849prefix    dc   #10
  852next      DCW  #3         One below next slot in array table
  860          DCW  #8         Offset and link work for next phase
  868          DCW  #8         Offset and link work for next phase
  876next3     DCW  #8         Offset and link work for next phase
  877          DC   #1
  882          DCW  #5
     *
     * Announce syntax error
     *
  883syntax    CS   332
  887          CS
  888          SW   184        Is this a global error flag?
  892          MN   prefix,243  Sequence
  899          MN                 number to
  900          MN                   error message
  901          MCW  error4
  905          W
  906          BCV  ovfl1
  911          B    novfl1
  915ovfl1     CC   1
  917novfl1    C    0&X1       Get down below prefix of
  921          SAR  x1           statement -- next word mark
  925          B    nxstmt
     *
     * Get to the next variable in the statement and then
     * check whether it's already in the array table
     *
  929find      BCE  atvar,0&X1,,  Skip punctuation before variable
  937          BCE  atvar,0&X1,%
  945          BCE  atvar,0&X1,)
  953          BCE  syntax,0&X1,}
  961          SBR  x1
  965          B    find
     *
     * X1 is now below a variable name in the statement, and
     * X2 is now at the top of a variable name in the table
     *
  969atvar     SW   1&X1  Set WM at bottom of variable
  973          MCW  next,x2
  980uneq      BCE  notin,2&X2,  Top of the table?
  988more1     MCM  2&X2  Move up to top of next table element
  992          MN           and then down
  993          MN             to table element name
  994          SAR  x2
  998          BCE  more1,1&X2,|  More to do if RM
 1006testv     C    0-0,0&X2   Test duplicate variable
 1013          SAR  x3         Stmt var - len(table var)
 1017          BU   uneq       Not found in the table yet
 1022tsteql    BW   found,1&X3  Equal length in stmt and table?
 1030          B    uneq       No, not found in the table yet
     *
     * Start here
     *
 1034beginn    MN   0&X2       Get down to
 1038          SAR  next         next available slot
 1042          SBR  next3          in array table
 1046          SW   gm
 1050          BW   difwid,diff  FP width /= integer width?
 1058          MCW  branch,switch
 1065difwid    MCW  x1,savex1
 1072          MCW  less,2&X1  Mark statement as processed
 1079          SBR  tstful&6,2&X1  Remember statement end mark addr
 1086more2     MCM  2&X2  Get above GMWM above bottom table element
 1090          MN           and then back
 1091          MN             below it.  x2 now points at first
 1092          SAR  x2          (topmost) character of name.
 1096          BCE  more2,1&X2,|  More to do if RM
 1104          C    0&X2  Skip name
 1108          C          Skip "next" pointer
 1109          C          Skip "prev" pointer
 1110          C          Skip ???
 1111          SAR  tabadr
 1115nxstmt    LCA  0&X1,prefix
 1122          SAR  x1         X1 is now first char below prefix
 1126fintst    BCE  done,prefix,  Done if no sequence number
 1134          BCE  goteqv,prefix-3,Q  EQUIVALENCE statement?
 1142finbr     B    done          Done if not EQUIVALENCE statement
 1146goteqv    BCE  gotlp,0&X1,%
 1154          B    syntax
 1158gotlp     SW   fpflg1,fpflg2  Got left paren -- syntax OK
 1165nxtvar    MN   0&X1       Skip left paren to get X1 to
 1169          SAR  x1           top char of variable
 1173          SBR  testv&3  variable to find in table
 1177switch    NOP  find  branch if FP width == integer width
     *
     * Check whether variables have same type
     *
 1181chktyp    MN   0&X1,tstint&7  Get ready to test first
 1188          MZ   0&X1,tstint&7    character of variable name
 1195tstint    BCE  intvar,intchr,X  Integer variable name?
 1203          chain5
 1208          CW   fpflg2
 1212          B    notint
 1216intvar    CW   fpflg1
 1220notint    BW   find,fpflg2
 1228          BWZ
     *
     * Error -- mixed FP and integer in equivalence while integer
     * and FP have different width
     *
 1229          CS   332
 1233          CS
 1234          SW   184        Is this a global error flag?
 1238          MN   prefix,251  Sequence number
 1245          MN                 to error
 1246          MN                    message
 1247          MCW  error5
 1251          W
 1252          BCV  ovfl2
 1257          B    novfl2
 1261ovfl2     CC   1
 1263novfl2    SW   fpflg1,fpflg2
 1270          B    find
     *
     * Not in the table yet.  X1 ==(?) X3 = punctuation below
     * the variable in the statement
     *
 1274notin     MCW  x1,x3    Does this change X3?
 1281          BCE  subsnd,0&X1,%  Subscript present?
 1289          MCW  next,x2  One below bottom slot in table
 1296          LCA  gm,1&X2  Set boundary
 1303          SBR  x2       Does this change X2?
 1307          MCW  testv&3,x3  Variable sought in table
 1314          LCA  0&X3,0&X2  Move variable to table
 1321          SBR  x2         X2 now points at "prev" link
 1325          MCW  tabadr,x3  Current bottom-of-table
 1332          LCA  tabadr,0&X2  Set "prev" link in new entry
 1339          LCA  w3         Space for "next" link
 1343          LCA  w3         Space for ???
 1347          SBR  tabadr     Set current bottom-of-table
 1351          SBR  x2         Set X2 nine below name in table
 1355          LCA  w5,0&X2
 1362          LCA  k1         Dimension == 1 for scalar
 1366          SBR  x2         X2 is now one below bottom element
 1370          MCW  tabadr,6&X3  Set "next" link in prev entry
 1377          BCE  notab,86,  No table yet?
     *
     * Save bottom of table and check size
     *
 1385savbot    MN   0&X2
 1389          SAR  next
 1393tstful    BCE  itfits,0,<
     *
     * Program is too big -- clobbered the sentinel
     *
 1401          CS   332
 1405          CS
 1406          CC   1
 1408          MCW  error2,270
 1415          W
 1416          CC   1
 1418          BCE  cards,cdovly,1
 1426          RWD  1
 1431cards     H    cards
     *
     * No table yet
     *
 1435notab     MCW  tabadr,86  Store top of table
 1442          B    savbot     Save bottom of table and check size
     *
     * Haven't clobbered the sentinel -- the program fits
     *
 1446itfits    BCE  doneqv,0&X1,)  Done with this equivalence?
 1454          B    moreqv
 1458doneqv    SW   fpflg1,fpflg2  Assume equivalence is OK
 1465moreqv    MN   0&X1       Skip punctuation below variable
 1469          SBR  x1
 1473          SBR  testv&3    Variable to find in table
 1477          BCE  nother,0&X1,,  Another variable in equivalence?
 1485          BCE  itfits,0&X1,}
 1493          BCE  nxstmt,1&X1,}
 1501          B    switch     Go test types
     *
     * Subscript appears in EQUIVALENCE statement but the variable
     * was not found in the array table
     *
 1505subsnd    CS   299
 1509          MCW  x3,x1  Does this change X1?
 1516          MCW  x2,savx2
 1523          MN   248    Why not
 1527          MN            just do
 1528          SAR  x2         sbr  x1,246?
 1532          SBR  x1,0&X1  This can't change X1
 1539findlp    MCW  0&X1,savech
 1546          SAR  x1
 1550          BCE  gotlp2,savech,%  Got to start of subscript?
 1558          MCW  savech,2&X2  Move saved character to message
 1565          SBR  x2         reversing variable back into order
 1569          B    findlp
 1573gotlp2    MCW  savx2,x2
 1580          SW   184        Is this a global error flag?
 1584          MN   prefix,240  Sequence number
 1591          MN                 to error
 1592          MN                   message
 1593          MCW  error6
 1597          BCV  ovfl3
 1602          B    novfl3
 1606ovfl3     CC   1
 1608novfl3    W
 1609skipv     MN   0&X1
 1613          SAR  x1
 1617          BCE  nother,0&X1,)  Found end of subscript
 1625          BCE  syntax,0&X1,%  Syntax error if left paren
 1633          BCE  syntax,0&X1,}  syntax error if end of statement
 1641          BCE  skipv,0&X1,,   Skip more if comma (is this OK?)
 1649          BWZ  skipv,0&X1,2   Skip more if numeric
 1657          B    syntax         Else syntax error
     *
     * Another variable in equivalence
     *
 1661nother    MN   0&X1
 1665          SAR  x1
 1669          B    itfits
     *
     * Found variable in array table
     *
 1673found     BCE  skipv,0&X1,%   Subscript OK since we found var
 1681          B    itfits
     *
 1685done      SBR  fintst&3,done2  These  
 1692          SBR  finbr&3,done2     addresses are
 1699          SBR  uneq&3,notin2       in next overlay
 1706          SBR  tsteql&3,chktyp
 1713          MCW  next,next3
 1720          MCW  savex1,x1
 1727          MCW  branch,switch
 1734          MCW  nop,gotlp
 1741          BSS  snapsh,C
 1746          SBR  tpread&6,chktyp  Set load addr for next overlay
 1753          SBR  clrbot
 1757          SBR  loadxx&3,nxstmt  Set entry addr for next overlay
 1764          SBR  clearl&3,gmwm
 1771          LCA  equiv2,phasid
 1778          B    loadnx
     *
     * More data
     *
 1821error4    DCW  @ERROR 4 - EQUIVALENCE SYNTAX, STATEMENT @
 1822branch    B
 1823less      DCW  @<@        Less-than sign
 1826tabadr    DCW  #3         Current array table address
 1827fpflg1    DCW  #1
 1828fpflg2    DCW  #1         WM if FP variable
 1834intchr    DCW  @IJKLMN@   First character of integer variables
 1882error5    DCW  @ERROR 5 - ILLEGAL EQUIVALENCE MIXING, STATEMENT @
 1885w3        DCW  #3  Used to create
 1887w5        DC   #2    empty table entry
 1888k1        dcw  1     Dimension for scalars
 1924error2    DCW  @MESSAGE 2 - OBJECT PROGRAM TOO LARGE@
 1927savx2     DCW  #3
 1928savech    DCW  #1
 1965error6    DCW  @ERROR 6 - UNDEFINED ARRAY, STATEMENT @
 1968savex1    DCW  #3
 1969nop       NOP
 1978equiv2    DCW  @EQUIV TWO@
 1979gmwm      DCW  @}@
               org  201
  203          dsa  loaddd    load address for card-to-tape program
               ex   beginn
               END
