Unit IBMTrace;
//******************************************************************************
//  Log/Trace
//------------------------------------------------------------------------------

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, StdCtrls, ExtCtrls;

Type
  TTraceForm = class(TForm)
    LBLog: TListBox;
    Panel1: TPanel;
    CBTraceMode: TCheckBox;
    CBTraceDets: TCheckBox;
    CBTraceRegs: TCheckBox;
    procedure CBTraceClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    LogText:  String;
  protected
  public
    Procedure Clear;
    Procedure Reset;
  end;

Var TraceForm: TTraceForm;

Procedure TracePut;
Procedure TraceAdd(SS: String);
Procedure TraceDump;

implementation

{$R *.DFM}

Uses B1401IEX;

procedure TTraceForm.FormCreate(Sender: TObject);
begin
  Top:=0; Left:=Screen.Width-Width;
  CBTraceMode.Checked:=True;
end;

procedure TTraceForm.CBTraceClick(Sender: TObject);
begin
  TraceMode:=CBTraceMode.Checked;
  TraceDets:=CBTraceDets.Checked;
  TraceRegs:=CBTraceRegs.Checked;
end;

Procedure TTraceForm.Clear;
begin
  With TraceForm do begin
    LBLog.Clear;
    LogText:='';
  End;
end;

procedure TTraceForm.Reset;
begin
  LogText:='';
end;

Procedure TraceAdd(SS: String);
Begin
  With TraceForm do LogText:=LogText+SS;
End;

Procedure TracePut;
Begin
  With TraceForm do begin
    If TraceMode then begin
      If LogText='' then Exit;
      With LBLog do begin
        Items.Add(LogText);
        TopIndex:=Items.Count-1;
      End;
    End;
    LogText:='';
  End;
End;

Procedure TraceDump;
Begin
  TraceForm.LBLog.Items.SaveToFile('IBMTrace.Log');
End;

end.

